/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.jboss.tools.portlet.ui.Messages;
import org.jboss.tools.portlet.ui.MultiSelectFilteredFileSelectionDialog;
import org.jboss.tools.portlet.ui.internal.wizard.NewJSFPortletWizard;
import org.jboss.tools.portlet.ui.internal.wizard.NewPortletClassDataModelProvider;

public class NewJSFPortletClassWizardPage
extends NewJavaClassWizardPage {
    protected Label projectNameLabel;
    private Combo projectNameCombo;
    private String projectName;
    private Label existingClassLabel;
    private Text existingClassText;
    private Button existingClassButton;
    private boolean disableExistingClassButton = false;

    public NewJSFPortletClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IArtifactEditOperationDataModelProperties.PROJECT_NAME"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)parent);
        this.addProjectNameGroup(composite);
        this.createUseExistingGroup(composite);
        return composite;
    }

    private void createUseExistingGroup(Composite composite) {
        this.existingClassLabel = new Label(composite, 16384);
        this.existingClassLabel.setText(IWebWizardConstants.CLASS_NAME_LABEL);
        this.existingClassLabel.setLayoutData((Object)new GridData(32));
        this.existingClassText = new Text(composite, 2060);
        this.existingClassText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.existingClassText, "NewJavaClassDataModel.CLASS_NAME", null);
        this.existingClassText.setText("javax.portlet.faces.GenericFacesPortlet");
        this.existingClassButton = new Button(composite, 8);
        this.existingClassButton.setText(IWebWizardConstants.BROWSE_BUTTON_LABEL);
        this.existingClassButton.setLayoutData((Object)new GridData(256));
        if (this.disableExistingClassButton) {
            this.existingClassButton.setEnabled(false);
        } else {
            this.existingClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewJSFPortletClassWizardPage.this.handleClassButtonSelected();
                }
            });
        }
    }

    private void handleClassButtonSelected() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        MultiSelectFilteredFileSelectionDialog ms = null;
        if (this.model.getBooleanProperty("NewPortletClassDataModel.IS_JSF_PORTLET")) {
            ms = new MultiSelectFilteredFileSelectionDialog(this.getShell(), Messages.NewJSFPortletClassWizardPage_New_JSF_Portlet, Messages.NewJSFPortletClassWizardPage_Choose_a_JSF_portlet_class, new String[0], false, project);
        }
        if (this.model.getBooleanProperty("NewPortletClassDataModel.IS_SEAM_PORTLET")) {
            ms = new MultiSelectFilteredFileSelectionDialog(this.getShell(), Messages.NewJSFPortletClassWizardPage_New_Seam_Portlet, Messages.NewJSFPortletClassWizardPage_Choose_a_Seam_portlet_class, new String[0], false, project);
        }
        IContainer root = component.getRootFolder().getUnderlyingFolder();
        ms.setInput(root);
        ms.open();
        if (ms.getReturnCode() == 0) {
            String qualifiedClassName = "";
            IType type = (IType)ms.getFirstResult();
            if (type != null) {
                qualifiedClassName = type.getFullyQualifiedName();
            }
            this.existingClassText.setText(qualifiedClassName);
        }
        this.getControl().setCursor(null);
    }

    private void addProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(J2EEUIMessages.getResourceString((String)"32"));
        GridData data = new GridData();
        this.projectNameLabel.setLayoutData((Object)data);
        this.projectNameCombo = new Combo(parent, 2056);
        data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        this.projectNameCombo.setLayoutData((Object)data);
        this.projectNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewJSFPortletClassWizardPage.this.updateProject();
            }

            public void widgetSelected(SelectionEvent e) {
                NewJSFPortletClassWizardPage.this.updateProject();
            }
        });
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        this.initializeProjectList();
        this.updateProject();
        new Label(parent, 0);
    }

    protected void updateProject() {
        String projectName = this.projectNameCombo.getText();
        if (projectName == null || projectName.trim().length() <= 0) {
            return;
        }
        IProject project = ProjectUtilities.getProject((String)projectName);
        try {
            boolean isSeamPortlet = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jboss.seamportlet");
            boolean isJSFPortlet = isSeamPortlet ? false : FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jboss.jsfportlet");
            NewJSFPortletWizard wizard = (NewJSFPortletWizard)this.getWizard();
            NewPortletClassDataModelProvider provider = (NewPortletClassDataModelProvider)wizard.getDefaultProvider();
            provider.setSeamPortlet(isSeamPortlet);
            provider.setJSFPortlet(isJSFPortlet);
        }
        catch (CoreException coreException) {}
    }

    private void initializeProjectList() {
        IProject[] workspaceProjects = ProjectUtilities.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (this.isProjectValid(project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            this.disableExistingClassButton = true;
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        IProject selectedProject = null;
        try {
            String projectNameFromModel;
            if (this.model != null && (projectNameFromModel = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = ProjectUtilities.getProject((String)projectNameFromModel);
            }
        }
        catch (Exception exception) {}
        try {
            if (selectedProject == null) {
                selectedProject = this.getSelectedProject();
            }
            if (selectedProject != null && selectedProject.isAccessible() && selectedProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                this.projectNameCombo.setText(selectedProject.getName());
                this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
            }
        }
        catch (CoreException coreException) {}
        if (this.projectName == null && names.length > 0) {
            this.projectName = names[0];
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && this.projectName != null) {
            this.projectNameCombo.setText(this.projectName);
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
        }
    }

    private IProject getSelectedProject() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection stucturedSelection = (IStructuredSelection)selection;
        if (stucturedSelection.getFirstElement() instanceof EObject) {
            return ProjectUtilities.getProject((Object)stucturedSelection.getFirstElement());
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        return this.getExtendedSelectedProject(stucturedSelection.getFirstElement());
    }

    protected boolean isProjectValid(IProject project) {
        boolean result = super.isProjectValid(project);
        if (!result) {
            return result;
        }
        try {
            result = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jboss.jsfportlet");
            if (!result) {
                return result;
            }
            boolean isSeamProject = this.model.getBooleanProperty("NewPortletClassDataModel.IS_SEAM_PORTLET");
            if (isSeamProject) {
                result = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jboss.seamportlet");
            }
        }
        catch (CoreException coreException) {
            result = false;
        }
        return result;
    }

    public boolean canFlipToNextPage() {
        if (this.model.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }
}

