/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.jboss.ide.eclipse.as.ui.actions.ServerManager;
import org.jboss.ide.eclipse.as.ui.actions.ServerManagerListener;

public abstract class AbstractServerActionDelegate
implements IWorkbenchWindowActionDelegate,
ServerManagerListener {
    static Map<String, AbstractServerActionDelegate> delegates = new HashMap<String, AbstractServerActionDelegate>();
    protected IWorkbenchWindow window;
    protected IAction action;
    protected boolean isInitialised = false;

    public AbstractServerActionDelegate() {
        delegates.put(this.getClass().getName(), this);
    }

    public static void updateAll() {
        AbstractServerActionDelegate[] ds = delegates.values().toArray(new AbstractServerActionDelegate[0]);
        int i = 0;
        while (i < ds.length) {
            try {
                ds[i].update();
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AbstractServerActionDelegate.this.initModel();
            }
        });
    }

    private void initModel() {
        ServerManager.getInstance().addListener(this);
        this.update();
        this.isInitialised = true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.action == action) {
            return;
        }
        this.action = action;
        this.serverManagerChanged();
    }

    public void run(IAction action) {
        if (!this.isInitialised) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (AbstractServerActionDelegate.this.isActionEnabled()) {
                        AbstractServerActionDelegate.this._run();
                    }
                }
            });
        } else {
            this._run();
        }
    }

    private void _run() {
        try {
            this.doRun();
        }
        catch (Exception exception) {}
    }

    public void dispose() {
    }

    protected void doRun() {
    }

    protected boolean isActionEnabled() {
        return true;
    }

    protected void update() {
        if (this.action != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AbstractServerActionDelegate.this.action.setEnabled(AbstractServerActionDelegate.this.isActionEnabled());
                    AbstractServerActionDelegate.this.setToolTip();
                }
            });
        }
    }

    public void serverManagerChanged() {
        this.update();
    }

    protected void setToolTip() {
        String tooltip;
        if (this.action != null && (tooltip = this.computeToolTip()) != null) {
            this.action.setToolTipText(tooltip);
        }
    }

    protected String computeToolTip() {
        return null;
    }

    protected static ISelectionProvider getSelectionProvider() {
        return new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
    }
}

