/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.actions.ServerActionMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeTimeStampActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow window;
    String tooltip = null;
    IProject project = null;
    private static final String ESB_PROJECT_FACET = "jst.jboss.esb";

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object o;
        IProject p;
        if (this.project == null && action.isEnabled()) {
            action.setEnabled(false);
        }
        if (this.tooltip != null && selection instanceof IStructuredSelection && (p = this.getProject(o = ((IStructuredSelection)selection).getFirstElement())) != null) {
            this.project = p;
            action.setEnabled(this.computeEnabled());
            action.setToolTipText(NLS.bind((String)ServerActionMessages.CHANGE_TIME_STAMP, (Object)this.project.getName()));
            return;
        }
        this.tooltip = ServerActionMessages.CHANGE_TIME_STAMP_DEFAULT;
        action.setToolTipText(this.tooltip);
    }

    IProject getProject(Object selection) {
        if (selection instanceof IResource) {
            return ((IResource)selection).getProject();
        }
        if (selection instanceof IAdaptable) {
            Object r = ((IAdaptable)selection).getAdapter(IResource.class);
            return r instanceof IResource ? ((IResource)r).getProject() : null;
        }
        return null;
    }

    protected boolean computeEnabled() {
        if (this.project == null || !this.project.isAccessible()) {
            return false;
        }
        boolean isWar = JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project);
        boolean isEar = JavaEEProjectUtilities.isEARProject((IProject)this.project);
        boolean isEJB = JavaEEProjectUtilities.isEJBProject((IProject)this.project);
        boolean isEsb = ChangeTimeStampActionDelegate.isESBProject(this.project);
        return isEar || isEJB || isWar || isEsb;
    }

    public void run(IAction action) {
        try {
            ChangeTimeStampActionDelegate.changeTimeStamp(this.project);
        }
        catch (Exception exception) {}
    }

    public void dispose() {
        this.window = null;
    }

    public static void changeTimeStamp(IProject project) throws CoreException {
        if (project == null || !project.isAccessible()) {
            return;
        }
        List<IFile> fs = ChangeTimeStampActionDelegate.getFilesToTouch(project);
        int i = 0;
        while (i < fs.size()) {
            IFile f = fs.get(i);
            f.setLocalTimeStamp(System.currentTimeMillis());
            f.touch((IProgressMonitor)new NullProgressMonitor());
            ++i;
        }
    }

    private static List<IFile> getFilesToTouch(IProject project) {
        IVirtualComponent component;
        IPath path;
        IFile f;
        ArrayList<IFile> fs = new ArrayList<IFile>();
        if (project == null || !project.isAccessible()) {
            return fs;
        }
        boolean isWar = JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
        boolean isEar = JavaEEProjectUtilities.isEARProject((IProject)project);
        boolean isReferencedByEar = false;
        if (!isEar) {
            IProject[] ps = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
            int i = 0;
            while (i < ps.length) {
                fs.addAll(ChangeTimeStampActionDelegate.getFilesToTouch(ps[i]));
                isReferencedByEar = true;
                ++i;
            }
        }
        if (isEar && (f = project.getFile((path = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getProjectRelativePath()).append("META-INF").append("application.xml"))) != null && f.exists()) {
            fs.add(f);
        }
        if (isWar && !isReferencedByEar && (f = project.getFile((path = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getProjectRelativePath()).append("WEB-INF").append("web.xml"))) != null && f.exists()) {
            fs.add(f);
        }
        if (ChangeTimeStampActionDelegate.isESBProject(project) && (f = project.getFile((path = (component = ComponentCore.createComponent((IProject)project)).getRootFolder().getProjectRelativePath()).append("META-INF").append("jboss-esb.xml"))) != null && f.exists()) {
            fs.add(f);
        }
        return fs;
    }

    private static boolean isESBProject(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            JBossServerUIPlugin.log(e.getMessage(), (Exception)((Object)e));
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)ESB_PROJECT_FACET)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)ESB_PROJECT_FACET);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }
}

