/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.Messages;

public class DeployAction
implements IObjectActionDelegate {
    protected ISelection selection;
    private Shell shell;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        action.setEnabled(this.verifyEnablement());
        action.setText(this.getText(this.verifyType()));
    }

    protected boolean verifyEnablement() {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            if (sel.isEmpty()) {
                return false;
            }
            Iterator i = sel.iterator();
            while (i.hasNext()) {
                if (i.next() instanceof IFile) continue;
                return false;
            }
        }
        return true;
    }

    protected String getText(boolean type) {
        if (type) {
            return Messages.ActionDelegateMakeUndeployable;
        }
        return Messages.ActionDelegateMakeDeployable;
    }

    protected boolean verifyType() {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            if (sel.isEmpty()) {
                return false;
            }
            for (Object o : sel) {
                if (o instanceof IFile && SingleDeployableFactory.findModule((IPath)((IFile)o).getFullPath()) != null) continue;
                return false;
            }
        }
        return true;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null && targetPart.getSite() != null) {
            this.shell = targetPart.getSite().getShell();
        }
    }

    public void run(IAction action) {
        if (this.verifyType()) {
            this.makeUndeployable();
        } else {
            this.makeDeployable();
        }
    }

    protected void makeDeployable() {
        IStructuredSelection sel2 = (IStructuredSelection)this.selection;
        Object[] objs = sel2.toArray();
        IModule[] modules = new IModule[objs.length];
        int i = 0;
        while (i < objs.length) {
            SingleDeployableFactory.makeDeployable((IPath)((IFile)objs[i]).getFullPath());
            modules[i] = SingleDeployableFactory.findModule((IPath)((IFile)objs[i]).getFullPath());
            ++i;
        }
        this.tryToPublish();
    }

    protected void makeUndeployable() {
        IStructuredSelection sel2 = (IStructuredSelection)this.selection;
        Object[] objs = sel2.toArray();
        ArrayList<IPath> paths = new ArrayList<IPath>();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof IFile) {
                paths.add(((IFile)objs[i]).getFullPath());
            }
            ++i;
        }
        new SingleDeployableFactory.UndeployFromServerJob(paths).schedule();
    }

    protected void tryToPublish() {
        IServer server;
        IServer[] deployableServersAsIServers = ServerConverter.getDeployableServersAsIServers();
        if (deployableServersAsIServers.length == 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.ActionDelegateDeployableServersNotFoundTitle, (String)Messages.ActionDelegateDeployableServersNotFoundDesc);
        }
        if ((server = this.getServer(this.shell, deployableServersAsIServers)) == null) {
            return;
        }
        Status errorStatus = null;
        String errorMessage = null;
        String errorTitle = null;
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel2 = (IStructuredSelection)this.selection;
            Object[] objs = sel2.toArray();
            if (server == null) {
                errorStatus = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ActionDelegateDeployableServersNotFoundTitle);
                errorTitle = Messages.ActionDelegateCannotPublish;
                errorMessage = Messages.ActionDelegateDeployableServersNotFoundDesc;
            } else if (objs == null || !this.allFiles(objs)) {
                errorStatus = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ActionDelegateFileResourcesOnly);
                errorTitle = Messages.ActionDelegateCannotPublish;
                errorMessage = Messages.ActionDelegateFileResourcesOnly;
            } else {
                IModule[] modules = new IModule[objs.length];
                int i = 0;
                while (i < objs.length) {
                    modules[i] = SingleDeployableFactory.findModule((IPath)((IFile)objs[i]).getFullPath());
                    ++i;
                }
                try {
                    IServerWorkingCopy copy = server.createWorkingCopy();
                    copy.modifyModules(modules, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
                    IServer saved = copy.save(false, (IProgressMonitor)new NullProgressMonitor());
                    new PublishServerJob(saved).schedule();
                }
                catch (CoreException ce) {
                    errorStatus = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.ActionDelegatePublishFailed, (Throwable)ce);
                    errorTitle = Messages.ActionDelegateCannotPublish;
                    errorMessage = Messages.ActionDelegatePublishFailed;
                }
            }
        }
        if (errorStatus != null) {
            ErrorDialog dialog = new ErrorDialog(new Shell(), errorTitle, errorMessage, errorStatus, 65535);
            dialog.open();
        }
    }

    protected boolean allFiles(Object[] objs) {
        int i = 0;
        while (i < objs.length) {
            if (!(objs[i] instanceof IFile)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected IServer getServer(Shell shell, IServer[] servers) {
        if (servers.length == 0) {
            return null;
        }
        if (servers.length == 1) {
            return servers[0];
        }
        SelectServerDialog d = new SelectServerDialog(shell);
        int result = d.open();
        if (result == 0) {
            return d.getSelectedServer();
        }
        return null;
    }

    public class SelectServerDialog
    extends Dialog {
        private Object selected;

        protected SelectServerDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.ActionDelegateSelectServer);
        }

        public IServer getSelectedServer() {
            if (this.selected instanceof IServer) {
                return (IServer)this.selected;
            }
            return null;
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            Tree tree = new Tree(c, 68356);
            tree.setLayoutData((Object)new GridData(1808));
            final TreeViewer viewer = new TreeViewer(tree);
            viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    return null;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object[] getElements(Object inputElement) {
                    return ServerConverter.getDeployableServersAsIServers();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderExtension());
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection sel = viewer.getSelection();
                    if (sel instanceof IStructuredSelection) {
                        SelectServerDialog.this.selected = ((IStructuredSelection)sel).getFirstElement();
                    }
                }
            });
            viewer.setInput((Object)new Boolean(true));
            return c;
        }

        private final class LabelProviderExtension
        extends BaseLabelProvider
        implements ILabelProvider {
            private LabelProviderExtension() {
            }

            public Image getImage(Object element) {
                if (element instanceof IServer) {
                    return ImageResource.getImage((String)((IServer)element).getServerType().getId());
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IServer) {
                    return ((IServer)element).getName();
                }
                return "";
            }
        }
    }
}

