/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;

public class ExploreUtils {
    public static final String PATH = "{%}";
    public static final String EXPLORE = Messages.ExploreUtils_Action_Text;
    public static final String EXPLORE_DESCRIPTION = Messages.ExploreUtils_Description;
    private static String exploreFolderCommand;
    private static String[] exploreFolderCommandArray;
    private static String exploreFileCommand;

    public static String getExploreCommand() {
        if (exploreFolderCommand == null) {
            ExploreUtils.setExploreCommands();
        }
        return exploreFolderCommand;
    }

    public static String getExploreFileCommand() {
        if (exploreFileCommand == null) {
            ExploreUtils.setExploreCommands();
        }
        return exploreFileCommand;
    }

    private static void setExploreCommands() {
        if ("macosx".equals(Platform.getOS())) {
            exploreFileCommand = exploreFolderCommand = "/usr/bin/open -a /System/Library/CoreServices/Finder.app \"{%}\"";
        } else if ("win32".equals(Platform.getOS())) {
            exploreFolderCommand = "cmd /C start explorer /root,/e,\"{%}\"";
            exploreFileCommand = "cmd /C start explorer /select,/e,\"{%}\"";
        } else if ("linux".equals(Platform.getOS())) {
            if (new File("/usr/bin/nautilus").exists()) {
                exploreFolderCommandArray = new String[3];
                ExploreUtils.exploreFolderCommandArray[0] = "/usr/bin/nautilus";
                ExploreUtils.exploreFolderCommandArray[1] = "--no-desktop";
                exploreFolderCommand = "";
            } else if (new File("/usr/bin/konqueror").exists()) {
                exploreFolderCommandArray = new String[2];
                ExploreUtils.exploreFolderCommandArray[0] = "/usr/bin/konqueror";
                exploreFolderCommand = "";
            }
            exploreFileCommand = exploreFolderCommand;
        }
    }

    public static String getDeployDirectory(IServer server) {
        IDeployableServer deployableServer = ServerConverter.getDeployableServer((IServer)server);
        if (server.getRuntime() != null && deployableServer != null) {
            return deployableServer.getDeployFolder();
        }
        IServerWorkingCopy swc = server.createWorkingCopy();
        ServerAttributeHelper helper = new ServerAttributeHelper(swc.getOriginal(), swc);
        String deployDirectory = helper.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", "");
        return deployDirectory.trim();
    }

    public static boolean canExplore(IServer server) {
        String deployDirectory = ExploreUtils.getDeployDirectory(server);
        if (deployDirectory == null || deployDirectory.length() <= 0) {
            return false;
        }
        return ExploreUtils.getExploreCommand() != null;
    }

    public static void explore(String name) {
        File file = new File(name);
        String command = null;
        command = file.isFile() ? ExploreUtils.getExploreFileCommand() : ExploreUtils.getExploreCommand();
        if (command != null) {
            if (Platform.getOS().equals("win32")) {
                name = name.replace('/', '\\');
            }
            try {
                if ("linux".equals(Platform.getOS())) {
                    int len = exploreFolderCommandArray.length;
                    ExploreUtils.exploreFolderCommandArray[len - 1] = name;
                    Runtime.getRuntime().exec(exploreFolderCommandArray);
                } else {
                    command = command.replace(PATH, name);
                    Runtime.getRuntime().exec(command);
                }
            }
            catch (IOException e) {
                JBossServerUIPlugin.log(e.getMessage(), e);
            }
        }
    }

    public static IPath getDeployPath(IDeployableServer server, IModule[] moduleTree) {
        Path root = new Path(server.getDeployFolder());
        int i = 0;
        while (i < moduleTree.length) {
            String type = moduleTree[i].getModuleType().getId();
            String name = moduleTree[i].getName();
            if (new Path(name).segmentCount() > 1) {
                return root.append(new Path(name).lastSegment());
            }
            root = "jst.ear".equals(type) ? root.append(String.valueOf(name) + ".ear") : ("jst.web".equals(type) ? root.append(String.valueOf(name) + ".war") : ("jst.utility".equals(type) && i >= 1 && "jst.web".equals(moduleTree[i - 1].getModuleType().getId()) ? root.append("WEB-INF").append("lib").append(String.valueOf(name) + ".jar") : ("jst.connector".equals(type) ? root.append(String.valueOf(name) + ".rar") : ("jst.jboss.esb".equals(type) ? root.append(String.valueOf(name) + ".esb") : root.append(String.valueOf(name) + ".jar")))));
            ++i;
        }
        return root;
    }
}

