/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.wizard.NewServerWizard;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.actions.AbstractServerActionDelegate;
import org.jboss.ide.eclipse.as.ui.actions.ServerActionMessages;
import org.jboss.ide.eclipse.as.ui.actions.ServerManager;

public class SelectServerActionDelegate
extends AbstractServerActionDelegate
implements IWorkbenchWindowPulldownDelegate {
    private ArrayList images = new ArrayList();

    protected void safeSelectionChanged(IAction action, ISelection selection) {
        this.action = action;
        this.update();
    }

    protected void update() {
        if (this.action == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SelectServerActionDelegate.this.update0();
            }
        });
    }

    private void update0() {
        if (this.action == null) {
            return;
        }
        IServer server = ServerManager.getInstance().getSelectedServer();
        if (server != null) {
            ImageDescriptor id = ImageResource.getImageDescriptor((String)server.getServerType().getId());
            this.action.setImageDescriptor(id);
        }
        this.action.setText(null);
        this.action.setToolTipText(ServerActionMessages.SELECT_A_SERVER);
    }

    protected void doRun() {
        this.getMenu((Control)this.window.getShell()).setVisible(true);
    }

    public void dispose() {
        this.action = null;
    }

    public Menu getMenu(Control parent) {
        this.cleanImages();
        Menu menu = new Menu(parent);
        IServer[] servers = ServerManager.getInstance().getServers();
        int i = 0;
        while (i < servers.length) {
            this.createServerItem(menu, servers[i]);
            ++i;
        }
        new MenuItem(menu, 2);
        this.createNewServerItem(menu);
        return menu;
    }

    protected void cleanImages() {
        Iterator i = this.images.iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.images.clear();
    }

    private void createServerItem(Menu menu, final IServer server) {
        MenuItem item = new MenuItem(menu, 16);
        if (server == ServerManager.getInstance().getSelectedServer()) {
            item.setSelection(true);
        }
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServerManager.getInstance().setSelectedServer(server.getId());
                SelectServerActionDelegate.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        item.setText(server.getName());
        ImageDescriptor id = ImageResource.getImageDescriptor((String)server.getServerType().getId());
        Image i = id.createImage();
        this.images.add(i);
        item.setImage(i);
    }

    private void createNewServerItem(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(ServerActionMessages.SelectServerActionDelegate_NewServerMenuItem);
        item.setImage(JBossServerUISharedImages.getImage("GENERIC_SERVER_IMAGE"));
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectServerActionDelegate.this.newServer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectServerActionDelegate.this.newServer();
                this.widgetSelected(e);
            }
        });
    }

    private void newServer() {
        IServer server;
        NewServerWizard wizard = new NewServerWizard();
        WizardDialog dialog = new WizardDialog(this.window.getShell(), (IWizard)wizard);
        if (dialog.open() != 1 && (server = (IServer)wizard.getRootFragment().getTaskModel().getObject("server")) != null) {
            ServerManager.getInstance().setSelectedServer(server.getId());
            this.update();
        }
    }
}

