/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.TwiddleLaunchConfiguration;
import org.jboss.ide.eclipse.as.core.server.internal.launch.TwiddleLauncher;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;

public class TwiddleDialog
extends TrayDialog {
    private static final int EXECUTE_ID = 2042;
    private Text query;
    private Text results;
    private Label queryLabel;
    private IServer server = null;
    private Composite parentComposite;

    public TwiddleDialog(Shell parentShell, Object selection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (selection instanceof IServer) {
            this.server = (IServer)selection;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TwiddleDialog);
        newShell.setImage(JBossServerUISharedImages.getImage("TWIDDLE_IMAGE"));
    }

    protected Point getInitialSize() {
        return new Point(600, 300);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2042, Messages.TwiddleDialogExecute, true);
        this.createButton(parent, 0, Messages.TwiddleDialogDone, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (2042 == buttonId) {
            this.executePressed();
        }
    }

    protected void executePressed() {
        final String args = this.query.getText();
        final Display dis = this.getShell().getDisplay();
        final IServer jbs = this.server;
        this.getButton(2042).setEnabled(false);
        Thread t = new Thread(){

            public void run() {
                try {
                    TwiddleLauncher launcher = new TwiddleLauncher();
                    TwiddleLauncher.ProcessData[] datas = launcher.getTwiddleResults(jbs, args, false);
                    if (datas.length == 1) {
                        final String s2 = datas[0].getOut();
                        dis.asyncExec(new Runnable(){

                            public void run() {
                                TwiddleDialog.this.results.setText(s2);
                                TwiddleDialog.this.getButton(2042).setEnabled(true);
                                Shell shell = TwiddleDialog.this.parentComposite.getShell();
                                TwiddleDialog.this.query.setFocus();
                                TwiddleDialog.this.query.setSelection(0, TwiddleDialog.this.query.getText().length());
                                if (shell != null) {
                                    shell.setDefaultButton(TwiddleDialog.this.getButton(2042));
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.jboss.ide.eclipse.as.ui", Messages.TwiddleDialog_UnexpectedError, (Throwable)e);
                    JBossServerUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        };
        t.start();
    }

    protected Control createDialogArea(Composite parent) {
        this.parentComposite = parent;
        Composite c = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(c, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new FormLayout());
        this.queryLabel = new Label(main, 0);
        this.queryLabel.setText(Messages.TwiddleDialogArguments);
        FormData queryLabelData = new FormData();
        queryLabelData.left = new FormAttachment(0, 5);
        queryLabelData.top = new FormAttachment(0, 5);
        this.queryLabel.setLayoutData((Object)queryLabelData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.jboss.ide.eclipse.as.ui.twiddle_usage_tutorial_help");
        this.query = new Text(main, 2048);
        FormData queryData = new FormData();
        queryData.top = new FormAttachment((Control)this.queryLabel, 5);
        queryData.right = new FormAttachment(100, -5);
        queryData.left = new FormAttachment(0, 5);
        this.query.setLayoutData((Object)queryData);
        this.results = new Text(main, 2570);
        FormData resultsData = new FormData();
        resultsData.left = new FormAttachment(0, 5);
        resultsData.right = new FormAttachment(100, -5);
        resultsData.bottom = new FormAttachment(100, -5);
        resultsData.top = new FormAttachment((Control)this.query, 5);
        this.results.setLayoutData((Object)resultsData);
        this.results.setFont(new Font(null, "Courier New", 8, 0));
        try {
            String args = TwiddleLaunchConfiguration.getDefaultArgs((IServer)this.server);
            this.query.setText(args);
            this.query.setFocus();
            this.query.setSelection(args.length());
        }
        catch (CoreException coreException) {}
        return c;
    }
}

