/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.DeploymentPreferenceLoader;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentEditorTab;
import org.jboss.ide.eclipse.as.ui.editor.ModuleDeploymentPage;

public class LocalDeploymentModuleTab
implements IDeploymentEditorTab {
    private ModuleDeploymentPage page;
    private DeploymentPreferenceLoader.DeploymentPreferences preferences;
    private TreeViewer viewer;
    private static final String LOCAL_COLUMN_NAME = "name";
    private static final String LOCAL_COLUMN_LOC = "location";
    private static final String LOCAL_COLUMN_TEMP_LOC = "tempLocation";
    private Text deployText;
    private Text tempDeployText;
    private Button metadataRadio;
    private Button serverRadio;
    private Button customRadio;
    private Button currentSelection;
    private Button deployButton;
    private Button tempDeployButton;
    private ModifyListener deployListener;
    private ModifyListener tempDeployListener;
    private SelectionListener radioListener;
    private SelectionListener zipListener;
    private ServerAttributeHelper helper;
    private Button zipDeployWTPProjects;
    private String lastCustomDeploy;
    private String lastCustomTemp;

    public String getTabName() {
        return Messages.EditorLocalDeployment;
    }

    public void setDeploymentPage(ModuleDeploymentPage page) {
        this.page = page;
    }

    public void setDeploymentPrefs(DeploymentPreferenceLoader.DeploymentPreferences prefs) {
        this.preferences = prefs;
    }

    public Control createControl(Composite parent) {
        this.helper = new ServerAttributeHelper(this.page.getServer().getOriginal(), this.page.getServer());
        Composite random = new Composite(parent, 0);
        GridData randomData = new GridData(1808);
        random.setLayoutData((Object)randomData);
        random.setLayout((Layout)new FormLayout());
        Composite defaultComposite = this.createDefaultComposite(random);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        defaultComposite.setLayoutData((Object)fd);
        Composite viewComposite = this.createViewerPortion(random);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment((Control)defaultComposite, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -5);
        viewComposite.setLayoutData((Object)fd);
        return random;
    }

    protected Composite createDefaultComposite(Composite parent) {
        Label descriptionLabel;
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.swf_DeployEditorHeading);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        Label top = descriptionLabel = toolkit.createLabel(composite, Messages.swf_DeploymentDescription);
        Composite inner = toolkit.createComposite(composite);
        inner.setLayout((Layout)new GridLayout(1, false));
        IRuntime rt = this.getServer().getServer().getRuntime();
        boolean showRadios = true;
        if (rt == null) {
            showRadios = false;
        } else {
            IJBossServerRuntime jbsrt = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            if (jbsrt == null) {
                showRadios = false;
            }
        }
        if (showRadios) {
            this.metadataRadio = toolkit.createButton(inner, Messages.EditorUseWorkspaceMetadata, 16);
            this.serverRadio = toolkit.createButton(inner, Messages.EditorUseServersDeployFolder, 16);
            this.customRadio = toolkit.createButton(inner, Messages.EditorUseCustomDeployFolder, 16);
            this.metadataRadio.setSelection(this.getDeployType().equals("metadata"));
            this.serverRadio.setSelection(this.getDeployType().equals("server"));
            this.customRadio.setSelection(this.getDeployType().equals("custom"));
            this.currentSelection = this.metadataRadio.getSelection() ? this.metadataRadio : (this.serverRadio.getSelection() ? this.serverRadio : this.customRadio);
            this.radioListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e.getSource() == LocalDeploymentModuleTab.this.currentSelection) {
                        return;
                    }
                    LocalDeploymentModuleTab.this.page.execute(new RadioClickedCommand((Button)e.getSource(), LocalDeploymentModuleTab.this.currentSelection));
                    LocalDeploymentModuleTab.this.currentSelection = (Button)e.getSource();
                }
            };
            this.metadataRadio.addSelectionListener(this.radioListener);
            this.serverRadio.addSelectionListener(this.radioListener);
            this.customRadio.addSelectionListener(this.radioListener);
        }
        FormData radios = new FormData();
        radios.top = new FormAttachment((Control)descriptionLabel, 5);
        radios.left = new FormAttachment(0, 5);
        radios.right = new FormAttachment(100, -5);
        inner.setLayoutData((Object)radios);
        top = inner;
        Label label = toolkit.createLabel(composite, Messages.swf_DeployDirectory);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.deployText = toolkit.createText(composite, this.getDeployDir(), 2048);
        this.deployListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalDeploymentModuleTab.this.page.execute(new SetDeployDirCommand());
            }
        };
        this.deployText.addModifyListener(this.deployListener);
        this.deployButton = toolkit.createButton(composite, Messages.browse, 8);
        this.deployButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog d = new DirectoryDialog(new Shell());
                d.setFilterPath(LocalDeploymentModuleTab.this.page.makeGlobal(LocalDeploymentModuleTab.this.deployText.getText()));
                String x = d.open();
                if (x != null) {
                    LocalDeploymentModuleTab.this.deployText.setText(LocalDeploymentModuleTab.this.page.makeRelative(x));
                }
            }
        });
        Label tempDeployLabel = toolkit.createLabel(composite, Messages.swf_TempDeployDirectory);
        tempDeployLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.tempDeployText = toolkit.createText(composite, this.getTempDeployDir(), 2048);
        this.tempDeployListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalDeploymentModuleTab.this.page.execute(new SetTempDeployDirCommand());
            }
        };
        this.tempDeployText.addModifyListener(this.tempDeployListener);
        this.tempDeployButton = toolkit.createButton(composite, Messages.browse, 8);
        this.tempDeployButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog d = new DirectoryDialog(new Shell());
                d.setFilterPath(LocalDeploymentModuleTab.this.page.makeGlobal(LocalDeploymentModuleTab.this.tempDeployText.getText()));
                String x = d.open();
                if (x != null) {
                    LocalDeploymentModuleTab.this.tempDeployText.setText(LocalDeploymentModuleTab.this.page.makeRelative(x));
                }
            }
        });
        this.deployText.setEnabled(this.customRadio == null || this.customRadio.getSelection());
        this.tempDeployText.setEnabled(this.customRadio == null || this.customRadio.getSelection());
        FormData descriptionLabelData = new FormData();
        descriptionLabelData.left = new FormAttachment(0, 5);
        descriptionLabelData.top = new FormAttachment(0, 5);
        descriptionLabel.setLayoutData((Object)descriptionLabelData);
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, 5);
        labelData.right = new FormAttachment((Control)this.deployText, -5);
        labelData.top = new FormAttachment((Control)top, 5);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.left = new FormAttachment((Control)this.deployButton, -305);
        textData.top = new FormAttachment((Control)top, 5);
        textData.right = new FormAttachment((Control)this.deployButton, -5);
        this.deployText.setLayoutData((Object)textData);
        FormData buttonData = new FormData();
        buttonData.right = new FormAttachment(100, -5);
        buttonData.left = new FormAttachment(100, -100);
        buttonData.top = new FormAttachment((Control)top, 2);
        this.deployButton.setLayoutData((Object)buttonData);
        FormData tempLabelData = new FormData();
        tempLabelData.left = new FormAttachment(0, 5);
        tempLabelData.right = new FormAttachment((Control)this.deployText, -5);
        tempLabelData.top = new FormAttachment((Control)this.deployText, 5);
        tempDeployLabel.setLayoutData((Object)tempLabelData);
        FormData tempTextData = new FormData();
        tempTextData.left = new FormAttachment((Control)this.tempDeployButton, -305);
        tempTextData.top = new FormAttachment((Control)this.deployText, 5);
        tempTextData.right = new FormAttachment((Control)this.tempDeployButton, -5);
        this.tempDeployText.setLayoutData((Object)tempTextData);
        FormData tempButtonData = new FormData();
        tempButtonData.right = new FormAttachment(100, -5);
        tempButtonData.left = new FormAttachment(100, -100);
        tempButtonData.top = new FormAttachment((Control)this.deployText, 5);
        this.tempDeployButton.setLayoutData((Object)tempButtonData);
        this.zipDeployWTPProjects = toolkit.createButton(composite, Messages.EditorZipDeployments, 32);
        boolean zippedPublisherAvailable = this.isLocalZippedPublisherAvailable();
        boolean value = this.getServer().zipsWTPDeployments();
        this.zipDeployWTPProjects.setEnabled(zippedPublisherAvailable);
        this.zipDeployWTPProjects.setSelection(zippedPublisherAvailable && value);
        FormData zipButtonData = new FormData();
        zipButtonData.right = new FormAttachment(100, -5);
        zipButtonData.left = new FormAttachment(0, 5);
        zipButtonData.top = new FormAttachment((Control)this.tempDeployText, 5);
        this.zipDeployWTPProjects.setLayoutData((Object)zipButtonData);
        this.zipListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LocalDeploymentModuleTab.this.page.execute(new SetZipCommand());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.zipDeployWTPProjects.addSelectionListener(this.zipListener);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.page.getSaveStatus();
        return section;
    }

    protected boolean isLocalZippedPublisherAvailable() {
        IJBossServerPublisher[] publishers = ExtensionManager.getDefault().getZippedPublishers();
        int i = 0;
        while (i < publishers.length) {
            if (publishers[i].accepts("local", this.getServer().getServer(), null)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getDeployType() {
        return this.getServer().getDeployLocationType();
    }

    private String getDeployDir() {
        return this.page.getServer().getRuntime() == null ? "" : ModuleDeploymentPage.makeRelative(this.getServer().getDeployFolder(), this.page.getServer().getRuntime());
    }

    private String getTempDeployDir() {
        return this.page.getServer().getRuntime() == null ? "" : ModuleDeploymentPage.makeRelative(this.getServer().getTempDeployFolder(), this.page.getServer().getRuntime());
    }

    private IDeployableServer getServer() {
        return (IDeployableServer)this.page.getServer().loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected Composite createViewerPortion(Composite random) {
        Composite root = new Composite(random, 0);
        root.setLayout((Layout)new FormLayout());
        this.page.getFormToolkit(random).adapt(root);
        this.viewer = new TreeViewer(root, 2048);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        TreeColumn moduleColumn = new TreeColumn(this.viewer.getTree(), 0);
        TreeColumn publishLocColumn = new TreeColumn(this.viewer.getTree(), 0);
        TreeColumn publishTempLocColumn = new TreeColumn(this.viewer.getTree(), 0);
        moduleColumn.setText(Messages.EditorModule);
        publishLocColumn.setText(Messages.EditorSetDeployLabel);
        publishTempLocColumn.setText(Messages.EditorSetTempDeployLabel);
        moduleColumn.setWidth(200);
        publishLocColumn.setWidth(200);
        publishTempLocColumn.setWidth(200);
        FormData treeData = new FormData();
        treeData.top = new FormAttachment(0, 5);
        treeData.bottom = new FormAttachment(100, -5);
        treeData.left = new FormAttachment(0, 5);
        treeData.right = new FormAttachment(100, -5);
        this.viewer.getTree().setLayoutData((Object)treeData);
        this.viewer.setContentProvider((IContentProvider)new ModulePageContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ModulePageLabelProvider());
        this.viewer.setColumnProperties(new String[]{LOCAL_COLUMN_NAME, LOCAL_COLUMN_LOC, LOCAL_COLUMN_TEMP_LOC});
        this.viewer.setInput((Object)"");
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.viewer.getTree()), new TextCellEditor((Composite)this.viewer.getTree()), new TextCellEditor((Composite)this.viewer.getTree())};
        this.viewer.setCellModifier((ICellModifier)new LocalDeploymentCellModifier());
        this.viewer.setCellEditors(editors);
        return root;
    }

    private class LocalDeploymentCellModifier
    implements ICellModifier {
        private LocalDeploymentCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property != LocalDeploymentModuleTab.LOCAL_COLUMN_NAME;
        }

        public Object getValue(Object element, String property) {
            DeploymentPreferenceLoader.DeploymentModulePrefs p = LocalDeploymentModuleTab.this.preferences.getPreferences("local").getModulePrefs((IModule)element);
            if (property == LocalDeploymentModuleTab.LOCAL_COLUMN_LOC) {
                String ret = p.getProperty(LocalDeploymentModuleTab.LOCAL_COLUMN_LOC);
                return ret == null ? "" : ret;
            }
            if (property == LocalDeploymentModuleTab.LOCAL_COLUMN_TEMP_LOC) {
                String ret = p.getProperty(LocalDeploymentModuleTab.LOCAL_COLUMN_TEMP_LOC);
                return ret == null ? "" : ret;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            IModule module = (IModule)((TreeItem)element).getData();
            DeploymentPreferenceLoader.DeploymentModulePrefs p = LocalDeploymentModuleTab.this.preferences.getPreferences("local").getModulePrefs(module);
            if (property == LocalDeploymentModuleTab.LOCAL_COLUMN_LOC) {
                LocalDeploymentModuleTab.this.page.firePropertyChangeCommand(p, LocalDeploymentModuleTab.LOCAL_COLUMN_LOC, (String)value, Messages.EditorEditDeployLocCommand);
                LocalDeploymentModuleTab.this.viewer.refresh();
            } else if (property == LocalDeploymentModuleTab.LOCAL_COLUMN_TEMP_LOC) {
                LocalDeploymentModuleTab.this.page.firePropertyChangeCommand(p, LocalDeploymentModuleTab.LOCAL_COLUMN_TEMP_LOC, (String)value, Messages.EditorEditDeployLocCommand);
                LocalDeploymentModuleTab.this.viewer.refresh();
            }
        }
    }

    private class ModulePageContentProvider
    implements ITreeContentProvider {
        private ModulePageContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return LocalDeploymentModuleTab.this.page.getPossibleModules();
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    }

    private class ModulePageLabelProvider
    implements ITableLabelProvider {
        private ModulePageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IModule && columnIndex == 0) {
                ILabelProvider labelProvider = ServerUICore.getLabelProvider();
                Image image = labelProvider.getImage((Object)((IModule)element));
                labelProvider.dispose();
                return image;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IModule) {
                IModule m = (IModule)element;
                if (columnIndex == 0) {
                    return m.getName();
                }
                if (columnIndex == 1) {
                    DeploymentPreferenceLoader.DeploymentModulePrefs modPref = LocalDeploymentModuleTab.this.preferences.getOrCreatePreferences("local").getOrCreateModulePrefs(m);
                    String result = modPref.getProperty(LocalDeploymentModuleTab.LOCAL_COLUMN_LOC);
                    if (result != null) {
                        return result;
                    }
                    modPref.setProperty(LocalDeploymentModuleTab.LOCAL_COLUMN_LOC, "");
                    return "";
                }
                if (columnIndex == 2) {
                    DeploymentPreferenceLoader.DeploymentModulePrefs modPref = LocalDeploymentModuleTab.this.preferences.getOrCreatePreferences("local").getOrCreateModulePrefs(m);
                    String result = modPref.getProperty(LocalDeploymentModuleTab.LOCAL_COLUMN_TEMP_LOC);
                    if (result != null) {
                        return result;
                    }
                    modPref.setProperty(LocalDeploymentModuleTab.LOCAL_COLUMN_TEMP_LOC, "");
                    return "";
                }
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class RadioClickedCommand
    extends ServerCommand {
        private Button newSelection;
        private Button oldSelection;
        private String oldDir;
        private String newDir;
        private String oldTemp;
        private String newTemp;
        private String id;

        public RadioClickedCommand(Button clicked, Button previous) {
            super(LocalDeploymentModuleTab.this.page.getServer(), Messages.EditorSetRadioClicked);
            this.newSelection = clicked;
            this.oldSelection = previous;
            this.id = this.server.getId();
        }

        public void execute() {
            String oldType;
            boolean custom = this.newSelection == LocalDeploymentModuleTab.this.customRadio;
            LocalDeploymentModuleTab.this.deployText.setEnabled(custom);
            LocalDeploymentModuleTab.this.tempDeployText.setEnabled(custom);
            LocalDeploymentModuleTab.this.deployButton.setEnabled(custom);
            LocalDeploymentModuleTab.this.tempDeployButton.setEnabled(custom);
            this.oldDir = LocalDeploymentModuleTab.this.deployText.getText();
            this.oldTemp = LocalDeploymentModuleTab.this.tempDeployText.getText();
            String type = null;
            String string = this.oldSelection == LocalDeploymentModuleTab.this.customRadio ? "custom" : (oldType = this.oldSelection == LocalDeploymentModuleTab.this.serverRadio ? "server" : "metadata");
            if (this.newSelection == LocalDeploymentModuleTab.this.metadataRadio) {
                this.newDir = JBossServerCorePlugin.getServerStateLocation((String)this.id).append("deploy").makeAbsolute().toString();
                this.newTemp = JBossServerCorePlugin.getServerStateLocation((String)this.id).append("tempDeploy").makeAbsolute().toString();
                type = "metadata";
                new File(this.newDir).mkdirs();
                new File(this.newTemp).mkdirs();
            } else if (this.newSelection == LocalDeploymentModuleTab.this.serverRadio) {
                IJBossServerRuntime jbsrt;
                IRuntime rt = this.server.getRuntime();
                if (rt != null && (jbsrt = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    String loc = jbsrt.getConfigLocation();
                    String config = jbsrt.getJBossConfiguration();
                    this.newDir = new Path(loc).append(config).append("deploy").toString();
                    this.newTemp = new Path(loc).append(config).append("tmp").append("jbosstoolsTemp").toString();
                    new File(this.newTemp).mkdirs();
                    type = "server";
                }
            } else {
                this.newDir = LocalDeploymentModuleTab.this.lastCustomDeploy;
                this.newTemp = LocalDeploymentModuleTab.this.lastCustomTemp;
                type = "custom";
            }
            if (!this.newSelection.getSelection()) {
                this.oldSelection.removeSelectionListener(LocalDeploymentModuleTab.this.radioListener);
                this.oldSelection.setSelection(false);
                this.oldSelection.addSelectionListener(LocalDeploymentModuleTab.this.radioListener);
                this.newSelection.removeSelectionListener(LocalDeploymentModuleTab.this.radioListener);
                this.newSelection.setSelection(true);
                this.newSelection.addSelectionListener(LocalDeploymentModuleTab.this.radioListener);
            }
            type = type == null ? oldType : type;
            this.newDir = this.newDir == null ? this.oldDir : this.newDir;
            this.newTemp = this.newTemp == null ? this.oldTemp : this.newTemp;
            LocalDeploymentModuleTab.this.deployText.removeModifyListener(LocalDeploymentModuleTab.this.deployListener);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.newDir);
            LocalDeploymentModuleTab.this.deployText.setText(this.newDir);
            LocalDeploymentModuleTab.this.deployText.addModifyListener(LocalDeploymentModuleTab.this.deployListener);
            LocalDeploymentModuleTab.this.tempDeployText.removeModifyListener(LocalDeploymentModuleTab.this.tempDeployListener);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.newTemp);
            LocalDeploymentModuleTab.this.tempDeployText.setText(this.newTemp);
            LocalDeploymentModuleTab.this.tempDeployText.addModifyListener(LocalDeploymentModuleTab.this.tempDeployListener);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", type);
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }

        public void undo() {
            LocalDeploymentModuleTab.this.deployText.removeModifyListener(LocalDeploymentModuleTab.this.deployListener);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.oldDir);
            LocalDeploymentModuleTab.this.deployText.setText(this.oldDir);
            LocalDeploymentModuleTab.this.deployText.addModifyListener(LocalDeploymentModuleTab.this.deployListener);
            LocalDeploymentModuleTab.this.tempDeployText.removeModifyListener(LocalDeploymentModuleTab.this.tempDeployListener);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.oldTemp);
            LocalDeploymentModuleTab.this.tempDeployText.setText(this.oldTemp);
            LocalDeploymentModuleTab.this.tempDeployText.addModifyListener(LocalDeploymentModuleTab.this.tempDeployListener);
            this.oldSelection.removeSelectionListener(LocalDeploymentModuleTab.this.radioListener);
            this.oldSelection.setSelection(true);
            this.oldSelection.addSelectionListener(LocalDeploymentModuleTab.this.radioListener);
            this.newSelection.removeSelectionListener(LocalDeploymentModuleTab.this.radioListener);
            this.newSelection.setSelection(false);
            this.newSelection.addSelectionListener(LocalDeploymentModuleTab.this.radioListener);
            LocalDeploymentModuleTab.this.deployText.setEnabled(LocalDeploymentModuleTab.this.customRadio.getSelection());
            LocalDeploymentModuleTab.this.tempDeployText.setEnabled(LocalDeploymentModuleTab.this.customRadio.getSelection());
            String oldType = this.oldSelection == LocalDeploymentModuleTab.this.customRadio ? "custom" : (this.oldSelection == LocalDeploymentModuleTab.this.serverRadio ? "server" : "metadata");
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", oldType);
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }
    }

    public class SetDeployDirCommand
    extends ServerCommand {
        private String oldDir;
        private String newDir;
        private Text text;
        private ModifyListener listener;

        public SetDeployDirCommand() {
            super(LocalDeploymentModuleTab.this.page.getServer(), Messages.EditorSetDeployLabel);
            this.text = LocalDeploymentModuleTab.this.deployText;
            this.newDir = LocalDeploymentModuleTab.this.deployText.getText();
            this.listener = LocalDeploymentModuleTab.this.deployListener;
            this.oldDir = LocalDeploymentModuleTab.this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", "");
        }

        public void execute() {
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.newDir);
            LocalDeploymentModuleTab.this.lastCustomDeploy = this.newDir;
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }

        public void undo() {
            this.text.removeModifyListener(this.listener);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.oldDir);
            this.text.setText(this.oldDir);
            this.text.addModifyListener(this.listener);
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }
    }

    public class SetTempDeployDirCommand
    extends ServerCommand {
        private String oldDir;
        private String newDir;
        private Text text;
        private ModifyListener listener;

        public SetTempDeployDirCommand() {
            super(LocalDeploymentModuleTab.this.page.getServer(), Messages.EditorSetTempDeployLabel);
            this.text = LocalDeploymentModuleTab.this.tempDeployText;
            this.newDir = LocalDeploymentModuleTab.this.tempDeployText.getText();
            this.listener = LocalDeploymentModuleTab.this.tempDeployListener;
            this.oldDir = LocalDeploymentModuleTab.this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", "");
        }

        public void execute() {
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.newDir);
            LocalDeploymentModuleTab.this.lastCustomTemp = this.newDir;
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }

        public void undo() {
            this.text.removeModifyListener(this.listener);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.oldDir);
            this.text.setText(this.oldDir);
            this.text.addModifyListener(this.listener);
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }
    }

    public class SetZipCommand
    extends ServerCommand {
        boolean oldVal;
        boolean newVal;

        public SetZipCommand() {
            super(LocalDeploymentModuleTab.this.page.getServer(), Messages.EditorZipDeployments);
            this.oldVal = LocalDeploymentModuleTab.this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false);
            this.newVal = LocalDeploymentModuleTab.this.zipDeployWTPProjects.getSelection();
        }

        public void execute() {
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", this.newVal);
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }

        public void undo() {
            LocalDeploymentModuleTab.this.zipDeployWTPProjects.removeSelectionListener(LocalDeploymentModuleTab.this.zipListener);
            LocalDeploymentModuleTab.this.zipDeployWTPProjects.setSelection(this.oldVal);
            LocalDeploymentModuleTab.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", this.oldVal);
            LocalDeploymentModuleTab.this.zipDeployWTPProjects.addSelectionListener(LocalDeploymentModuleTab.this.zipListener);
            LocalDeploymentModuleTab.this.page.getSaveStatus();
        }
    }
}

