/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.DeploymentPreferenceLoader;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentEditorTab;
import org.jboss.ide.eclipse.as.ui.editor.LocalDeploymentModuleTab;

public class ModuleDeploymentPage
extends ServerEditorPart {
    protected ServerResourceCommandManager commandManager;
    protected ArrayList<IModule> possibleModules;
    protected DeploymentPreferenceLoader.DeploymentPreferences preferences;
    protected ArrayList<IDeploymentEditorTab> tabs;
    protected ServerAttributeHelper helper;

    public IModule[] getPossibleModules() {
        return this.possibleModules.toArray(new IModule[this.possibleModules.size()]);
    }

    public FormToolkit getFormToolkit(Composite parent) {
        return this.getFormToolkit(parent.getDisplay());
    }

    public IServerWorkingCopy getServer() {
        return this.server;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        ArrayList<IModule> possibleChildren = new ArrayList<IModule>();
        IModule[] modules2 = ServerUtil.getModules((IModuleType[])this.server.getServerType().getRuntimeType().getModuleTypes());
        if (modules2 != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IModule module = modules2[i];
                IStatus status = this.server.canModifyModules(new IModule[]{module}, null, null);
                if (status != null && status.getSeverity() != 4) {
                    possibleChildren.add(module);
                }
                ++i;
            }
        }
        this.possibleModules = possibleChildren;
        if (input instanceof IServerEditorPartInput) {
            IServerEditorPartInput sepi = (IServerEditorPartInput)input;
            this.server = sepi.getServer();
            this.commandManager = ((ServerEditorPartInput)sepi).getServerCommandManager();
            this.readOnly = sepi.isServerReadOnly();
        }
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createPartControl(Composite parent) {
        this.preferences = DeploymentPreferenceLoader.loadPreferencesFromServer((IServer)this.server.getOriginal());
        this.tabs = new ArrayList();
        FormToolkit toolkit = this.getFormToolkit(parent);
        ScrolledForm form = toolkit.createScrolledForm(parent);
        toolkit.decorateFormHeading(form.getForm());
        form.setText("Deployment");
        form.getBody().setLayout((Layout)new GridLayout());
        TabFolder tabFolder = new TabFolder(form.getBody(), 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        toolkit.adapt((Composite)tabFolder);
        toolkit.adapt((Composite)form);
        toolkit.adapt(form.getBody());
        IDeploymentEditorTab[] newItems = this.createTabs(toolkit, tabFolder);
        int i = 0;
        while (i < newItems.length) {
            this.tabs.add(newItems[i]);
            ++i;
        }
    }

    protected IDeploymentEditorTab[] createTabs(FormToolkit toolkit, TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        LocalDeploymentModuleTab tab = new LocalDeploymentModuleTab();
        tabItem.setText(tab.getTabName());
        tab.setDeploymentPage(this);
        tab.setDeploymentPrefs(this.preferences);
        tabItem.setControl(tab.createControl((Composite)tabFolder));
        toolkit.adapt((Composite)tabItem.getControl());
        return new IDeploymentEditorTab[]{tab};
    }

    public void execute(ServerCommand command) {
        this.commandManager.execute((IUndoableOperation)command);
    }

    public void firePropertyChangeCommand(DeploymentPreferenceLoader.DeploymentModulePrefs p, String key, String val, String cmdName) {
        this.commandManager.execute((IUndoableOperation)new ChangePropertyCommand(p, key, val, cmdName));
    }

    public String makeGlobal(String path) {
        return ModuleDeploymentPage.makeGlobal(path, this.server.getRuntime());
    }

    public static String makeGlobal(String path, IRuntime runtime) {
        IJBossServerRuntime rt = ModuleDeploymentPage.getRuntime(runtime);
        if (rt != null) {
            return org.jboss.ide.eclipse.as.core.util.ServerUtil.makeGlobal((IJBossServerRuntime)rt, (IPath)new Path(path)).toString();
        }
        return path;
    }

    public String makeRelative(String path) {
        return ModuleDeploymentPage.makeRelative(path, this.server.getRuntime());
    }

    public static String makeRelative(String path, IRuntime runtime) {
        IJBossServerRuntime rt = ModuleDeploymentPage.getRuntime(runtime);
        if (rt == null) {
            return path;
        }
        return org.jboss.ide.eclipse.as.core.util.ServerUtil.makeRelative((IJBossServerRuntime)rt, (IPath)new Path(path)).toString();
    }

    private IJBossServerRuntime getRuntime() {
        IRuntime r = this.server.getRuntime();
        return ModuleDeploymentPage.getRuntime(r);
    }

    public static IJBossServerRuntime getRuntime(IRuntime r) {
        IJBossServerRuntime ajbsrt = null;
        if (r != null) {
            ajbsrt = (IJBossServerRuntime)r.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return ajbsrt;
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            DeploymentPreferenceLoader.savePreferences((IServer)this.server.getOriginal(), (DeploymentPreferenceLoader.DeploymentPreferences)this.preferences);
        }
        catch (IOException iOException) {}
    }

    private class ChangePropertyCommand
    extends ServerCommand {
        private DeploymentPreferenceLoader.DeploymentModulePrefs p;
        private String key;
        private String oldVal;
        private String newVal;

        public ChangePropertyCommand(DeploymentPreferenceLoader.DeploymentModulePrefs p, String key, String val, String commandName) {
            super(ModuleDeploymentPage.this.server, commandName);
            this.p = p;
            this.key = key;
            this.newVal = val;
            this.oldVal = p.getProperty(key);
        }

        public void execute() {
            this.p.setProperty(this.key, this.newVal);
            this.saveToWC();
        }

        public void undo() {
            this.p.setProperty(this.key, this.oldVal);
            this.saveToWC();
        }

        protected void saveToWC() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeploymentPreferenceLoader.savePreferences((OutputStream)bos, (DeploymentPreferenceLoader.DeploymentPreferences)ModuleDeploymentPage.this.preferences);
            String asXML = new String(bos.toByteArray());
            ModuleDeploymentPage.this.helper.setAttribute("org.jboss.ide.eclipse.as.core.util.deploymentPreferenceKey", asXML);
        }
    }
}

