/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.server.internal.ServerStatePollerType;
import org.jboss.ide.eclipse.as.ui.Messages;

public class PollerSection
extends ServerEditorSection {
    private Combo startPollerCombo;
    private Combo stopPollerCombo;
    private Composite pollers;
    private String[] startupTypesStrings;
    private String[] shutdownTypesStrings;
    private ServerStatePollerType[] startupTypes;
    private ServerStatePollerType[] shutdownTypes;
    private ModifyListener startPollerListener;
    private ModifyListener stopPollerListener;
    protected ServerAttributeHelper helper;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.findPossiblePollers();
        this.createUI(parent);
        this.addListeners();
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.PollerSection_ServerPollingSection);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        this.pollers = toolkit.createComposite(composite);
        this.pollers.setLayout((Layout)new GridLayout(2, false));
        Label start = new Label(this.pollers, 0);
        this.startPollerCombo = new Combo(this.pollers, 8);
        Label stop = new Label(this.pollers, 0);
        this.stopPollerCombo = new Combo(this.pollers, 8);
        start.setText(Messages.EditorStartupPollerLabel);
        stop.setText(Messages.EditorShutdownPollerLabel);
        this.startPollerCombo.setItems(this.startupTypesStrings);
        this.stopPollerCombo.setItems(this.shutdownTypesStrings);
        this.startPollerCombo.setEnabled(true);
        this.stopPollerCombo.setEnabled(true);
        String currentStartId = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.JMXPoller");
        String currentStopId = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller");
        this.startPollerCombo.select(this.startPollerCombo.indexOf(ExtensionManager.getDefault().getPollerType(currentStartId).getName()));
        this.stopPollerCombo.select(this.stopPollerCombo.indexOf(ExtensionManager.getDefault().getPollerType(currentStopId).getName()));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    protected void findPossiblePollers() {
        this.startupTypes = ExtensionManager.getDefault().getStartupPollers();
        this.shutdownTypes = ExtensionManager.getDefault().getShutdownPollers();
        this.startupTypesStrings = new String[this.startupTypes.length];
        this.shutdownTypesStrings = new String[this.shutdownTypes.length];
        int i = 0;
        while (i < this.startupTypes.length) {
            this.startupTypesStrings[i] = this.startupTypes[i].getName();
            ++i;
        }
        i = 0;
        while (i < this.shutdownTypes.length) {
            this.shutdownTypesStrings[i] = this.shutdownTypes[i].getName();
            ++i;
        }
    }

    protected void addListeners() {
        this.startPollerListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PollerSection.this.execute((IUndoableOperation)new SetStartupPollerCommand(PollerSection.this.server));
            }
        };
        this.stopPollerListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PollerSection.this.execute((IUndoableOperation)new SetStopPollerCommand(PollerSection.this.server));
            }
        };
        this.startPollerCombo.addModifyListener(this.startPollerListener);
        this.stopPollerCombo.addModifyListener(this.stopPollerListener);
    }

    public class SetPollerCommand
    extends ServerCommand {
        private String preChange;
        private String attributeKey;
        private String defaultValue;
        private ServerStatePollerType[] pollerArray;
        private Combo combo;
        private ModifyListener listener;

        public SetPollerCommand(IServerWorkingCopy server, String name, String attributeKey, String defaultValue, ServerStatePollerType[] pollerArray, Combo pollerCombo, ModifyListener listener) {
            super(server, name);
            this.attributeKey = attributeKey;
            this.defaultValue = defaultValue;
            this.pollerArray = pollerArray;
            this.combo = pollerCombo;
            this.listener = listener;
        }

        public void execute() {
            this.preChange = PollerSection.this.helper.getAttribute(this.attributeKey, this.defaultValue);
            PollerSection.this.helper.setAttribute(this.attributeKey, this.pollerArray[this.combo.getSelectionIndex()].getId());
        }

        public void undo() {
            PollerSection.this.helper.setAttribute(this.attributeKey, this.preChange);
            this.combo.removeModifyListener(this.listener);
            int ind = this.findIndex(this.preChange);
            if (ind == -1) {
                this.combo.clearSelection();
            } else {
                this.combo.select(ind);
            }
            this.combo.addModifyListener(this.listener);
        }

        protected int findIndex(String id) {
            int i = 0;
            while (i < this.pollerArray.length) {
                if (this.pollerArray[i].getId().equals(id)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public class SetStartupPollerCommand
    extends SetPollerCommand {
        public SetStartupPollerCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangeStartPollerCommandName, "org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.JMXPoller", PollerSection.this.startupTypes, PollerSection.this.startPollerCombo, PollerSection.this.startPollerListener);
        }
    }

    public class SetStopPollerCommand
    extends SetPollerCommand {
        public SetStopPollerCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangeStopPollerCommandName, "org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey", "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller", PollerSection.this.shutdownTypes, PollerSection.this.stopPollerCombo, PollerSection.this.stopPollerListener);
        }
    }
}

