/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.server.IJBossServerConstants;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.dialogs.ChangePortDialog;

public class PortSection
extends ServerEditorSection {
    private ArrayList<IPortEditorExtension> sectionList = new ArrayList();
    protected ServerAttributeHelper helper;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
        if (this.sectionList.size() <= 0) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.ui", "ServerEditorPortSection");
            int i = 0;
            while (i < cf.length) {
                try {
                    Object o = cf[i].createExecutableExtension("class");
                    if (o != null && o instanceof IPortEditorExtension) {
                        this.sectionList.add((IPortEditorExtension)o);
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.EditorServerPorts);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        Label description = new Label(composite, 0);
        description.setText(Messages.EditorServerPortsDescription);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        description.setLayoutData((Object)data);
        this.addUIAdditions(composite, (Control)description);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.getSaveStatus();
    }

    private void addUIAdditions(Composite parent, Control top) {
        IPortEditorExtension[] extensions = this.sectionList.toArray(new IPortEditorExtension[this.sectionList.size()]);
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(top, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -5);
        wrapper.setLayoutData((Object)data);
        top = null;
        int i = 0;
        while (i < extensions.length) {
            extensions[i].setServerAttributeHelper(this.helper);
            extensions[i].setSection(this);
            Control c = extensions[i].createControl(wrapper);
            data = new FormData();
            data.top = top == null ? new FormAttachment(0, 5) : new FormAttachment(top, 5);
            data.left = new FormAttachment(0, 5);
            data.right = new FormAttachment(100, -5);
            c.setLayoutData((Object)data);
            top = c;
            ++i;
        }
    }

    protected String[] getXPathStrings() {
        ArrayList<String> list = new ArrayList<String>();
        XPathCategory[] categories = XPathModel.getDefault().getCategories(this.server.getOriginal());
        int i = 0;
        while (i < categories.length) {
            XPathQuery[] queries = categories[i].getQueries();
            int j = 0;
            while (j < queries.length) {
                list.add(String.valueOf(categories[i].getName()) + '/' + queries[j].getName());
                ++j;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    protected static String findPort(IServer server, IPath path) {
        XPathQuery query = XPathModel.getDefault().getQuery(server, path);
        String result = "";
        if (query != null) {
            try {
                query.refresh();
                result = query.getFirstResult();
                result = result == null ? "" : result;
                return new Integer(Integer.parseInt(result)).toString();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return result;
    }

    public IStatus[] getSaveStatus() {
        IStatus[] iStatusArray;
        Iterator<IPortEditorExtension> i = this.sectionList.iterator();
        boolean errorFound = false;
        while (i.hasNext()) {
            IPortEditorExtension ext1 = i.next();
            try {
                int temp = Integer.parseInt(ext1.getValue());
                if (temp >= 0) continue;
                errorFound = true;
            }
            catch (NumberFormatException numberFormatException) {
                errorFound = true;
            }
        }
        this.setErrorMessage(errorFound ? Messages.EditorPortInvalid : null);
        if (errorFound) {
            IStatus[] iStatusArray2 = new IStatus[1];
            iStatusArray = iStatusArray2;
            iStatusArray2[0] = new Status(2, "org.jboss.ide.eclipse.as.ui", Messages.EditorPortInvalid);
        } else {
            iStatusArray = new IStatus[]{};
        }
        return iStatusArray;
    }

    public static interface IPortEditorExtension {
        public void setServerAttributeHelper(ServerAttributeHelper var1);

        public void setSection(PortSection var1);

        public Control createControl(Composite var1);

        public String getValue();
    }

    public static class JNDIPortEditorExtension
    extends PortEditorExtension {
        public JNDIPortEditorExtension() {
            super(Messages.EditorJNDIPort, "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.jndiPort", IJBossServerConstants.JNDI_PORT_DEFAULT_XPATH);
        }

        public ServerCommand getCommand() {
            return new SetPortCommand(this.helper.getWorkingCopy(), this.helper, Messages.EditorChangeJNDICommandName, "org.jboss.ide.eclipse.as.core.server.jndiPort", "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect.XPath", IJBossServerConstants.JNDI_PORT_DEFAULT_XPATH, this);
        }

        protected ChangePortDialog.ChangePortDialogInfo getDialogInfo() {
            ChangePortDialog.ChangePortDialogInfo info = new ChangePortDialog.ChangePortDialogInfo();
            info.port = Messages.EditorJNDIPort;
            info.defaultValue = IJBossServerConstants.JNDI_PORT_DEFAULT_XPATH;
            info.server = this.helper.getWorkingCopy().getOriginal();
            info.currentXPath = this.currentXPath;
            return info;
        }
    }

    public static abstract class PortEditorExtension
    implements IPortEditorExtension {
        protected Button detect;
        protected Text text;
        protected Label label;
        protected Link link;
        protected String labelText;
        protected String currentXPathKey;
        protected String detectXPathKey;
        protected String overrideValueKey;
        protected String defaultXPath;
        protected String currentXPath;
        protected ServerAttributeHelper helper;
        protected Listener listener;
        protected PortSection section;

        public PortEditorExtension(String labelText, String currentXPathKey, String detectXPathKey, String overrideValueKey, String defaultXPath) {
            this.labelText = labelText;
            this.currentXPathKey = currentXPathKey;
            this.detectXPathKey = detectXPathKey;
            this.overrideValueKey = overrideValueKey;
            this.defaultXPath = defaultXPath;
        }

        public void setServerAttributeHelper(ServerAttributeHelper helper) {
            this.helper = helper;
        }

        public void setSection(PortSection section) {
            this.section = section;
        }

        public Control createControl(Composite parent) {
            Control c = this.createUI(parent);
            this.initialize();
            this.addListeners();
            return c;
        }

        protected Control createUI(Composite parent) {
            Composite child = new Composite(parent, 0);
            child.setLayout((Layout)new FormLayout());
            this.label = new Label(child, 0);
            this.text = new Text(child, -1);
            this.detect = new Button(child, 32);
            this.link = new Link(child, 0);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 8);
            data.right = new FormAttachment(100, -5);
            this.link.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment((Control)this.link, -5);
            data.top = new FormAttachment(0, 5);
            this.detect.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment((Control)this.detect, -5);
            data.left = new FormAttachment(0, 100);
            data.top = new FormAttachment(0, 5);
            this.text.setLayoutData((Object)data);
            data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.top = new FormAttachment(0, 8);
            this.label.setLayoutData((Object)data);
            this.label.setText(this.labelText);
            this.detect.setText(Messages.EditorAutomaticallyDetectPort);
            this.link.setText("<a href=\"\">" + Messages.Configure + "</a>");
            return child;
        }

        protected void initialize() {
            boolean shouldDetect = this.helper.getAttribute(this.detectXPathKey, true);
            this.detect.setSelection(shouldDetect);
            this.link.setEnabled(shouldDetect);
            this.text.setEnabled(!shouldDetect);
            this.text.setEditable(!shouldDetect);
            this.currentXPath = this.helper.getAttribute(this.currentXPathKey, this.defaultXPath);
            if (shouldDetect) {
                this.text.setText(PortSection.findPort(this.helper.getServer(), (IPath)new Path(this.currentXPath)));
            } else {
                this.text.setText(this.helper.getAttribute(this.overrideValueKey, ""));
            }
        }

        protected void addListeners() {
            this.listener = new Listener(){

                public void handleEvent(Event event) {
                    PortEditorExtension.this.section.execute((IUndoableOperation)PortEditorExtension.this.getCommand());
                }
            };
            this.text.addListener(24, this.listener);
            this.detect.addListener(13, this.listener);
            this.link.addListener(13, this.createLinkListener());
        }

        protected Listener createLinkListener() {
            return new Listener(){

                public void handleEvent(Event event) {
                    ChangePortDialog dialog = PortEditorExtension.this.getDialog();
                    int result = dialog.open();
                    if (result == 0) {
                        PortEditorExtension.this.currentXPath = dialog.getSelection();
                        PortEditorExtension.this.section.execute((IUndoableOperation)PortEditorExtension.this.getCommand());
                        PortEditorExtension.this.text.setFocus();
                    }
                }
            };
        }

        public ChangePortDialog getDialog() {
            return new ChangePortDialog(this.section.getShell(), this.getDialogInfo());
        }

        protected abstract ChangePortDialog.ChangePortDialogInfo getDialogInfo();

        protected ServerCommand getCommand() {
            return null;
        }

        public String getValue() {
            return this.text.getText();
        }
    }

    public static class SetPortCommand
    extends ServerCommand {
        ServerAttributeHelper helper;
        String textAttribute;
        String overrideAttribute;
        String overridePathAttribute;
        String preText;
        String prePath;
        String defaultPath;
        boolean preOverride;
        Text text;
        Button button;
        Listener listener;
        String xpath;
        Link link;
        PortSection pSection;

        public SetPortCommand(IServerWorkingCopy server, ServerAttributeHelper helper, String name, String textAttribute, String overrideAttribute, String overridePathAttribute, String pathDefault, PortEditorExtension ext) {
            super(server, name);
            this.helper = helper;
            this.textAttribute = textAttribute;
            this.overrideAttribute = overrideAttribute;
            this.overridePathAttribute = overridePathAttribute;
            this.defaultPath = pathDefault;
            this.text = ext.text;
            this.button = ext.detect;
            this.listener = ext.listener;
            this.xpath = ext.currentXPath;
            this.link = ext.link;
            this.pSection = ext.section;
        }

        public void execute() {
            this.preText = this.helper.getAttribute(this.textAttribute, null);
            if (this.preText == null) {
                this.preText = PortSection.findPort(this.helper.getServer(), (IPath)new Path(this.defaultPath));
            }
            this.prePath = this.helper.getAttribute(this.overridePathAttribute, this.defaultPath);
            this.preOverride = this.helper.getAttribute(this.overrideAttribute, true);
            this.helper.setAttribute(this.textAttribute, this.text.getText());
            this.helper.setAttribute(this.overrideAttribute, this.button.getSelection());
            this.link.setEnabled(this.button.getSelection());
            this.helper.setAttribute(this.overridePathAttribute, this.xpath);
            this.text.setEnabled(!this.button.getSelection());
            this.text.setEditable(!this.button.getSelection());
            if (this.button.getSelection()) {
                this.text.removeListener(24, this.listener);
                this.text.setText(PortSection.findPort(this.helper.getServer(), (IPath)new Path(this.xpath)));
                this.text.addListener(24, this.listener);
            }
            this.pSection.getSaveStatus();
        }

        public void undo() {
            this.helper.setAttribute(this.textAttribute, this.preText);
            this.helper.setAttribute(this.overrideAttribute, this.preOverride);
            this.link.setEnabled(this.preOverride);
            this.helper.setAttribute(this.overridePathAttribute, this.prePath);
            this.text.removeListener(24, this.listener);
            this.button.removeListener(13, this.listener);
            this.button.setSelection(this.preOverride);
            this.text.setText(this.preText == null ? "" : this.preText);
            this.text.setEnabled(!this.preOverride);
            this.text.setEditable(!this.preOverride);
            this.button.addListener(13, this.listener);
            this.text.addListener(24, this.listener);
            this.pSection.getSaveStatus();
        }
    }

    public static class WebPortEditorExtension
    extends PortEditorExtension {
        public WebPortEditorExtension() {
            super(Messages.EditorWebPort, "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.webPort", IJBossServerConstants.WEB_PORT_DEFAULT_XPATH);
        }

        public ServerCommand getCommand() {
            return new SetPortCommand(this.helper.getWorkingCopy(), this.helper, Messages.EditorChangeWebCommandName, "org.jboss.ide.eclipse.as.core.server.webPort", "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect.XPath", IJBossServerConstants.WEB_PORT_DEFAULT_XPATH, this);
        }

        protected ChangePortDialog.ChangePortDialogInfo getDialogInfo() {
            ChangePortDialog.ChangePortDialogInfo info = new ChangePortDialog.ChangePortDialogInfo();
            info.port = Messages.EditorWebPort;
            info.defaultValue = IJBossServerConstants.WEB_PORT_DEFAULT_XPATH;
            info.server = this.helper.getWorkingCopy().getOriginal();
            info.currentXPath = this.currentXPath;
            return info;
        }
    }
}

