/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.Messages;

public class ServerPasswordSection
extends ServerEditorSection {
    private ModifyListener nameModifyListener;
    private ModifyListener passModifyListener;
    private Text nameText;
    private Text passText;
    private ServerAttributeHelper helper;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.swf_AuthenticationGroup);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label explanation = toolkit.createLabel(composite, Messages.swf_AuthorizationDescription);
        GridData d = new GridData();
        d.horizontalSpan = 2;
        explanation.setLayoutData((Object)d);
        Label username = toolkit.createLabel(composite, Messages.swf_Username);
        username.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        String n = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.userName", "");
        String p = this.helper.getAttribute("org.jboss.ide.eclipse.as.core.server.password", "");
        this.nameText = toolkit.createText(composite, n);
        Label password = toolkit.createLabel(composite, Messages.swf_Password);
        password.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.passText = toolkit.createText(composite, p);
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.widthHint = 100;
        this.nameText.setLayoutData((Object)d);
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.widthHint = 100;
        this.passText.setLayoutData((Object)d);
        this.nameModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPasswordSection.this.execute((IUndoableOperation)new SetUserCommand(ServerPasswordSection.this.server));
            }
        };
        this.passModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPasswordSection.this.execute((IUndoableOperation)new SetPassCommand(ServerPasswordSection.this.server));
            }
        };
        this.nameText.addModifyListener(this.nameModifyListener);
        this.passText.addModifyListener(this.passModifyListener);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    public class SetPassCommand
    extends SetVarCommand {
        public SetPassCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangePasswordCommandName, ServerPasswordSection.this.passText, ServerPasswordSection.this.passText.getText(), "org.jboss.ide.eclipse.as.core.server.password", ServerPasswordSection.this.passModifyListener);
        }
    }

    public class SetUserCommand
    extends SetVarCommand {
        public SetUserCommand(IServerWorkingCopy server) {
            super(server, Messages.EditorChangeUsernameCommandName, ServerPasswordSection.this.nameText, ServerPasswordSection.this.nameText.getText(), "org.jboss.ide.eclipse.as.core.server.userName", ServerPasswordSection.this.nameModifyListener);
        }
    }

    public class SetVarCommand
    extends ServerCommand {
        private String oldVal;
        private String newVal;
        private String key;
        private Text text;
        private ModifyListener listener;

        public SetVarCommand(IServerWorkingCopy wc, String name, Text text, String newVal, String attributeKey, ModifyListener listener) {
            super(wc, name);
            this.text = text;
            this.key = attributeKey;
            this.newVal = newVal;
            this.listener = listener;
            this.oldVal = ServerPasswordSection.this.helper.getAttribute(attributeKey, "");
        }

        public void execute() {
            ServerPasswordSection.this.helper.setAttribute(this.key, this.newVal);
        }

        public void undo() {
            this.text.removeModifyListener(this.listener);
            ServerPasswordSection.this.helper.setAttribute(this.key, this.oldVal);
            this.text.setText(this.oldVal);
            this.text.addModifyListener(this.listener);
        }
    }
}

