/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.xpl.JavaMainTabClone;

public class JBossLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new JavaArgumentsTabExtension(), new JavaMainTabExtension(), new JavaClasspathTab(), new SourceLookupTab(), new EnvironmentTab(), new CommonTab()};
        int i = 0;
        while (i < tabs.length) {
            tabs[i].setLaunchConfigurationDialog(dialog);
            ++i;
        }
        this.setTabs(tabs);
    }

    public class JavaArgumentsTabExtension
    extends JavaArgumentsTab {
        private String originalHost = null;
        private String originalConf = null;

        public void initializeFrom(ILaunchConfiguration configuration) {
            super.initializeFrom(configuration);
            try {
                String startArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
                this.originalHost = ArgsUtil.getValue((String)startArgs, (String)"-b", (String)"--host");
                this.originalConf = ArgsUtil.getValue((String)startArgs, (String)"-c", (String)"--configuration");
            }
            catch (CoreException coreException) {}
        }

        public boolean isValid(ILaunchConfiguration config) {
            String newHost;
            block5: {
                if (!super.isValid(config)) {
                    return false;
                }
                try {
                    String startArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
                    newHost = ArgsUtil.getValue((String)startArgs, (String)"-b", (String)"--host");
                    String newConf = ArgsUtil.getValue((String)startArgs, (String)"-c", (String)"--configuration");
                    if (newConf != null && newConf.equals(this.originalConf)) break block5;
                    return false;
                }
                catch (CoreException coreException) {}
            }
            if (newHost == null || !newHost.equals(this.originalHost)) {
                return false;
            }
            return true;
        }

        public String getErrorMessage() {
            String m = super.getErrorMessage();
            if (m == null) {
                String startArgs = this.getAttributeValueFrom(this.fPrgmArgumentsText);
                String newHost = ArgsUtil.getValue((String)startArgs, (String)"-b", (String)"--host");
                String newConf = ArgsUtil.getValue((String)startArgs, (String)"-c", (String)"--configuration");
                if (newConf == null || !newConf.equals(this.originalConf)) {
                    return Messages.LaunchInvalidConfigChanged;
                }
                if (newHost == null || !newHost.equals(this.originalHost)) {
                    return Messages.LaunchInvalidHostChanged;
                }
            }
            return m;
        }
    }

    public class JavaMainTabExtension
    extends JavaMainTabClone {
        public void createControl(Composite parent) {
            Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
            ((GridLayout)comp.getLayout()).verticalSpacing = 0;
            this.createMainTypeEditor(comp, LauncherMessages.JavaMainTab_Main_cla_ss__4);
            this.setControl((Control)comp);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
        }

        public void initializeFrom(ILaunchConfiguration config) {
            this.setCurrentLaunchConfiguration(config);
            this.updateMainTypeFromConfig(config);
            this.updateStopInMainFromConfig(config);
            this.updateInheritedMainsFromConfig(config);
            this.updateExternalJars(config);
        }

        public boolean isValid(ILaunchConfiguration config) {
            this.setErrorMessage(null);
            this.setMessage(null);
            String name = this.fMainText.getText().trim();
            if (name.length() == 0) {
                this.setErrorMessage(LauncherMessages.JavaMainTab_Main_type_not_specified_16);
                return false;
            }
            return true;
        }

        protected IJavaProject getJavaProject() {
            return null;
        }
    }
}

