/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.launch;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IPollerFailureHandler;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.dialogs.RequiredCredentialsDialog;

public class SecurityFailureHandler
implements IPollerFailureHandler {
    public boolean accepts(IServerStatePoller poller, String action, List requiredProperties) {
        return poller.getPollerType().getId().equals("org.jboss.ide.eclipse.as.core.runtime.server.JMXPoller");
    }

    public void handle(final IServerStatePoller poller, String action, List requiredProperties) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IServer server = poller.getServer();
                IServerWorkingCopy copy = server.createWorkingCopy();
                JBossServer jbs = ServerConverter.getJBossServer((IServerWorkingCopy)copy);
                RequiredCredentialsDialog d = new RequiredCredentialsDialog(new Shell(), jbs);
                if (d.open() == 0) {
                    if (d.getSave()) {
                        jbs.setPassword(d.getPass());
                        jbs.setUsername(d.getUser());
                        try {
                            copy.save(false, null);
                        }
                        catch (CoreException ce) {
                            JBossServerUIPlugin.log(Messages.ServerSaveFailed, (Exception)((Object)ce));
                        }
                    }
                    Properties p = new Properties();
                    p.put("org.jboss.ide.eclipse.as.core.extensions.polling.jmx.REQUIRED_USER", d.getUser());
                    p.put("org.jboss.ide.eclipse.as.core.extensions.polling.jmx.REQUIRED_PASS", d.getPass());
                    poller.failureHandled(p);
                } else {
                    poller.failureHandled(null);
                }
            }
        });
    }
}

