/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnection;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerContentProvider;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerLabelProvider;

public class JMXProvider {

    public static class ActionProvider
    extends CommonActionProvider {
        private ICommonActionExtensionSite actionSite;
        private ShowInJMXViewAction showInJMXViewAction;

        public void init(ICommonActionExtensionSite aSite) {
            super.init(aSite);
            this.actionSite = aSite;
            this.createActions(aSite);
        }

        protected void createActions(ICommonActionExtensionSite aSite) {
            StructuredViewer v;
            ICommonViewerSite site = aSite.getViewSite();
            if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
                CommonViewer cfr_ignored_0 = (CommonViewer)v;
                ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
                this.showInJMXViewAction = new ShowInJMXViewAction(wsSite.getSelectionProvider());
            }
        }

        public void fillContextMenu(IMenuManager menu) {
            IContributionItem quick;
            ICommonViewerSite site = this.actionSite.getViewSite();
            IStructuredSelection selection = null;
            if (site instanceof ICommonViewerWorkbenchSite) {
                ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
                selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
            }
            if ((quick = menu.find("org.eclipse.ui.navigate.showInQuickMenu")) != null && selection != null && selection.toArray().length == 1 && selection.getFirstElement() instanceof IServer && menu instanceof MenuManager) {
                ((MenuManager)quick).add((IAction)this.showInJMXViewAction);
            }
        }

        public class ShowInJMXViewAction
        extends AbstractServerAction {
            public ShowInJMXViewAction(ISelectionProvider sp) {
                super(sp, null);
                IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
                IViewDescriptor desc = reg.find("org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorer");
                this.setText(desc.getLabel());
                this.setImageDescriptor(desc.getImageDescriptor());
            }

            public boolean accept(IServer server) {
                return server.getServerType() != null && server.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor()) != null && server.getServerState() == 2;
            }

            public void perform(final IServer server) {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    IViewPart part = page.findView("org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorer");
                    if (part == null) {
                        try {
                            part = page.showView("org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorer");
                        }
                        catch (PartInitException partInitException) {}
                    } else {
                        final JMXNavigator view = (JMXNavigator)part.getAdapter(JMXNavigator.class);
                        if (view != null) {
                            view.setFocus();
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    JBossServerConnectionProvider provider = (JBossServerConnectionProvider)ExtensionManager.getProvider((String)"org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider");
                                    JBossServerConnection connection = JBossServerConnectionProvider.getConnection((IServer)server);
                                    if (connection != null) {
                                        view.getCommonViewer().collapseAll();
                                        StructuredSelection sel = new StructuredSelection(new Object[]{connection});
                                        view.getCommonViewer().setSelection((ISelection)sel, true);
                                        view.getCommonViewer().expandToLevel((Object)connection, 2);
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    public static class ContentProvider
    implements ITreeContentProvider {
        private MBeanExplorerContentProvider delegate = new MBeanExplorerContentProvider();

        public Object[] getChildren(Object parentElement) {
            JBossServerConnection sel;
            if (parentElement instanceof IServer && (sel = JBossServerConnectionProvider.getConnection((IServer)((IServer)parentElement))) != null) {
                return new Object[]{sel};
            }
            return this.delegate.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return this.delegate.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.delegate.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return this.delegate.getElements(inputElement);
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.delegate.inputChanged(viewer, oldInput, newInput);
        }
    }

    public static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private MBeanExplorerLabelProvider delegate = new MBeanExplorerLabelProvider();

        public void dispose() {
            this.delegate.dispose();
        }

        public String getText(Object element) {
            if (element instanceof IConnectionWrapper) {
                return "JMX";
            }
            return this.delegate.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IConnectionWrapper) {
                return JBossServerUISharedImages.getImage("JMX_IMAGE");
            }
            return this.delegate.getImage(element);
        }
    }
}

