/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.publishers.JstPublisher;
import org.jboss.ide.eclipse.as.core.publishers.SingleFilePublisher;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.util.ModuleUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.actions.ExploreUtils;

public class ModuleActionProvider
extends CommonActionProvider {
    private Action deleteModuleAction;
    private Action fullPublishModuleAction;
    private Action incrementalPublishModuleAction;
    private Action exploreAction;
    private ModuleServer[] selection;
    private ICommonActionExtensionSite actionSite;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.actionSite = aSite;
        this.createActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        if (this.allAre(selection, ModuleServer.class)) {
            ModuleServer moduleServer;
            IServer server;
            Object[] arr = selection.toArray();
            ModuleServer[] ms = new ModuleServer[arr.length];
            int i = 0;
            while (i < arr.length) {
                ms[i] = (ModuleServer)arr[i];
                ++i;
            }
            this.selection = ms;
            IContributionItem sep = menu.find("org.jboss.tools.as.wst.server.ui.internal.cnf.controlModuleSectionEnd");
            if (sep == null) {
                sep = new Separator("org.jboss.tools.as.wst.server.ui.internal.cnf.controlModuleSectionEnd");
                sep.setVisible(false);
                menu.add(sep);
            }
            menu.insertBefore("org.jboss.tools.as.wst.server.ui.internal.cnf.controlModuleSectionEnd", (IAction)this.incrementalPublishModuleAction);
            menu.insertBefore("org.jboss.tools.as.wst.server.ui.internal.cnf.controlModuleSectionEnd", (IAction)this.fullPublishModuleAction);
            if (selection.size() > 1) {
                menu.insertBefore("org.jboss.tools.as.wst.server.ui.internal.cnf.controlModuleSectionEnd", (IAction)this.deleteModuleAction);
            }
            if (selection.size() == 1 && ExploreUtils.canExplore(server = (moduleServer = (ModuleServer)selection.getFirstElement()).getServer()) && this.getDeployPath() != null) {
                menu.insertBefore("org.jboss.tools.as.wst.server.ui.internal.cnf.controlModuleSectionEnd", (IAction)this.exploreAction);
            }
        }
    }

    protected boolean allAre(IStructuredSelection sel, Class c) {
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            if (i.next().getClass().equals(c)) continue;
            return false;
        }
        return true;
    }

    protected void createActions() {
        this.deleteModuleAction = new Action(){

            public void run() {
                ModuleActionProvider.this.deleteModule();
            }
        };
        this.deleteModuleAction.setText(Messages.DeleteModuleText);
        this.deleteModuleAction.setDescription(Messages.DeleteModuleDescription);
        this.deleteModuleAction.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("UNPUBLISH_IMAGE"));
        this.fullPublishModuleAction = new Action(){

            public void run() {
                ModuleActionProvider.this.actionPublish(3);
            }
        };
        this.fullPublishModuleAction.setText(Messages.FullPublishModuleText);
        this.fullPublishModuleAction.setDescription(Messages.PublishModuleDescription);
        this.fullPublishModuleAction.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("PUBLISH_IMAGE"));
        this.incrementalPublishModuleAction = new Action(){

            public void run() {
                ModuleActionProvider.this.actionPublish(2);
            }
        };
        this.incrementalPublishModuleAction.setText(Messages.IncrementalPublishModuleText);
        this.incrementalPublishModuleAction.setDescription(Messages.PublishModuleDescription);
        this.incrementalPublishModuleAction.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("PUBLISH_IMAGE"));
        this.exploreAction = new Action(){

            public void run() {
                File file;
                IPath path = ModuleActionProvider.this.getDeployPath();
                if (path != null && (file = path.toFile()).exists()) {
                    ExploreUtils.explore(file.getAbsolutePath());
                }
            }
        };
        this.exploreAction.setText(ExploreUtils.EXPLORE);
        this.exploreAction.setDescription(ExploreUtils.EXPLORE_DESCRIPTION);
        this.exploreAction.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("EXPLORE_IMAGE"));
    }

    protected void actionPublish(int type) {
        if (this.selection != null && this.selection.length > 0) {
            Server s = (Server)this.selection[0].server;
            int i = 0;
            while (i < this.selection.length) {
                IModule[] mod = this.selection[i].module;
                s.setModulePublishState(mod, type);
                ArrayList allChildren = ModuleUtil.getDeepChildren((IServer)s, (IModule[])mod);
                int j = 0;
                while (j < allChildren.size()) {
                    s.setModulePublishState((IModule[])allChildren.get(j), type);
                    ++j;
                }
                ++i;
            }
            new PublishServerJob((IServer)s, 1, true).schedule();
        }
    }

    protected void deleteModule() {
        if (MessageDialog.openConfirm((Shell)new Shell(), (String)Messages.ServerDialogHeading, (String)Messages.DeleteModuleConfirm)) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        if (ModuleActionProvider.this.selection.length > 0 && ((ModuleActionProvider)ModuleActionProvider.this).selection[0].server != null) {
                            IServer server = ((ModuleActionProvider)ModuleActionProvider.this).selection[0].server;
                            ArrayList<IModule> topModsToRemove = new ArrayList<IModule>();
                            int i = 0;
                            while (i < ModuleActionProvider.this.selection.length) {
                                if (!topModsToRemove.contains(((ModuleActionProvider)ModuleActionProvider.this).selection[i].module[0])) {
                                    topModsToRemove.add(((ModuleActionProvider)ModuleActionProvider.this).selection[i].module[0]);
                                }
                                ++i;
                            }
                            IServerWorkingCopy serverWC = server.createWorkingCopy();
                            IModule[] modsToRemove = topModsToRemove.toArray(new IModule[topModsToRemove.size()]);
                            ServerUtil.modifyModules((IServerWorkingCopy)serverWC, (IModule[])new IModule[0], (IModule[])modsToRemove, (IProgressMonitor)new NullProgressMonitor());
                            IServer server2 = serverWC.save(true, null);
                            new PublishServerJob(server2, 1, true).schedule();
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            t.start();
        }
    }

    private IPath getDeployPath() {
        ModuleServer ms = this.selection[0];
        IModule[] module = ms.module;
        IJBossServerPublisher publisher = ExtensionManager.getDefault().getPublisher(ms.getServer(), module, "local");
        IPath path = null;
        IDeployableServer deployableServer = ServerConverter.getDeployableServer((IServer)ms.server);
        if (deployableServer != null) {
            if (publisher instanceof JstPublisher) {
                path = ExploreUtils.getDeployPath(deployableServer, module);
            } else if (publisher instanceof SingleFilePublisher) {
                SingleDeployableFactory.SingleDeployableModuleDelegate delegate = (SingleDeployableFactory.SingleDeployableModuleDelegate)module[0].loadAdapter(SingleDeployableFactory.SingleDeployableModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
                if (delegate != null) {
                    IPath sourcePath = delegate.getGlobalSourcePath();
                    Path destFolder = new Path(deployableServer.getDeployFolder());
                    path = destFolder.append(sourcePath.lastSegment());
                } else {
                    path = new Path(deployableServer.getDeployFolder());
                }
            } else {
                path = new Path(deployableServer.getDeployFolder());
            }
        }
        return path;
    }
}

