/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.ui.views.ServerLogView;

public class ServerLogActionProvider
extends CommonActionProvider {
    private ICommonActionExtensionSite actionSite;
    private ShowInServerLogAction showInServerLogAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.actionSite = aSite;
        this.createActions(aSite);
    }

    protected void createActions(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cfr_ignored_0 = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.showInServerLogAction = new ShowInServerLogAction(wsSite.getSelectionProvider());
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IContributionItem quick;
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        if ((quick = menu.find("org.eclipse.ui.navigate.showInQuickMenu")) != null && selection != null && selection.toArray().length == 1 && selection.getFirstElement() instanceof IServer && menu instanceof MenuManager) {
            ((MenuManager)quick).add((IAction)this.showInServerLogAction);
        }
    }

    public class ShowInServerLogAction
    extends AbstractServerAction {
        public ShowInServerLogAction(ISelectionProvider sp) {
            super(sp, null);
            IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
            IViewDescriptor desc = reg.find("org.jboss.ide.eclipse.as.ui.view.serverLogView");
            this.setText(desc.getLabel());
            this.setImageDescriptor(desc.getImageDescriptor());
        }

        public boolean accept(IServer server) {
            return server.getServerType() != null && server.loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor()) != null;
        }

        public void perform(IServer server) {
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                ServerLogView view;
                IViewPart part = page.findView("org.jboss.ide.eclipse.as.ui.view.serverLogView");
                if (part == null) {
                    try {
                        part = page.showView("org.jboss.ide.eclipse.as.ui.view.serverLogView");
                    }
                    catch (PartInitException partInitException) {}
                }
                if (part != null && (view = (ServerLogView)((Object)part.getAdapter(ServerLogView.class))) != null) {
                    view.setFocus();
                    view.setServer(server);
                }
            }
        }
    }
}

