/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.XPathDecorator;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.XPathTreeLabelProvider;

public class XPathChangeValueAction
extends SelectionProviderAction {
    protected CustomTreeEditor treeEditor;
    protected Tree tree;
    protected TreeViewer viewer;
    protected Text textEditor;
    protected Composite textEditorParent;
    private TextActionHandler textActionHandler;
    protected Shell shell;
    protected int width = -1;
    protected Rectangle newParentBounds;
    protected boolean saving = false;

    public XPathChangeValueAction(Shell shell, TreeViewer viewer, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.XPathChangeValueAction_ActionText);
        this.shell = shell;
        this.viewer = viewer;
        this.tree = viewer.getTree();
        this.treeEditor = new CustomTreeEditor(this.tree);
    }

    public boolean shouldRun() {
        if (this.getStructuredSelection().toArray().length > 1) {
            return false;
        }
        Object o = this.getStructuredSelection().getFirstElement();
        return XPathDecorator.getDecoration(o) != null;
    }

    public void run() {
        this.queryNewValueInline(this.getStructuredSelection().getFirstElement());
    }

    private static int getCellEditorInset(Control c) {
        if ("carbon".equals(SWT.getPlatform()) && (System.getProperty("org.eclipse.swt.internal.carbon.noFocusRing") == null || c.getShell().getParent() != null)) {
            return -2;
        }
        return 1;
    }

    private Tree getTree() {
        return this.tree;
    }

    private Composite createParent() {
        Tree tree2 = this.getTree();
        Composite result = new Composite((Composite)tree2, 0);
        TreeItem[] selectedItems = tree2.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void queryNewValueInline(Object node) {
        if (this.textEditorParent == null) {
            this.createTextEditor(node);
        }
        this.textEditor.setText(XPathModel.getResultNode((Object)node).getText());
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = XPathChangeValueAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditor.setText(new XPathTreeLabelProvider().getText(node));
        this.width = this.textEditor.getSize().x - 10;
        this.textEditor.setText(XPathModel.getResultNode((Object)node).getText());
        this.treeEditor.layout();
        this.textEditorParent.setVisible(true);
        this.textEditor.setVisible(true);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    private void createTextEditor(final Object node) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        final int inset = XPathChangeValueAction.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point textSize = XPathChangeValueAction.this.textEditor.getSize();
                    Point parentSize = XPathChangeValueAction.this.textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.tree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = XPathChangeValueAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = XPathChangeValueAction.this.textEditorParent.getSize();
                XPathChangeValueAction.this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
                XPathChangeValueAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        XPathChangeValueAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        XPathChangeValueAction.this.saveChangesAndDispose(node);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                XPathChangeValueAction.this.saveChangesAndDispose(node);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
        this.textEditor.setVisible(false);
    }

    protected void disposeTextWidget() {
        this.width = -1;
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected void saveChangesAndDispose(Object node) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        String newVal = this.textEditor.getText();
        XPathFileResult.XPathResultNode itemToChange = XPathModel.getResultNode((Object)node);
        if (!itemToChange.getText().equals(newVal)) {
            itemToChange.setText(newVal);
            if (itemToChange.getDocument() != null) {
                itemToChange.saveDescriptor();
            }
        }
        this.getTree().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    XPathChangeValueAction.this.disposeTextWidget();
                    if (XPathChangeValueAction.this.tree != null && !XPathChangeValueAction.this.tree.isDisposed()) {
                        XPathChangeValueAction.this.tree.setFocus();
                        XPathChangeValueAction.this.viewer.refresh(XPathChangeValueAction.this.getStructuredSelection().getFirstElement());
                    }
                }
                finally {
                    XPathChangeValueAction.this.saving = false;
                }
            }
        });
    }

    protected class CustomTreeEditor
    extends TreeEditor {
        private boolean hadFocus;

        public CustomTreeEditor(Tree tree) {
            super(tree);
            this.hadFocus = false;
        }

        public void setItem(TreeItem item) {
            super.setItem(item);
        }

        public void layout() {
            if (XPathChangeValueAction.this.tree == null || XPathChangeValueAction.this.tree.isDisposed()) {
                return;
            }
            if (this.getItem() == null || this.getItem().isDisposed()) {
                return;
            }
            int columnCount = XPathChangeValueAction.this.tree.getColumnCount();
            if (columnCount == 0 && this.getColumn() != 0) {
                return;
            }
            if (columnCount > 0 && (this.getColumn() < 0 || this.getColumn() >= columnCount)) {
                return;
            }
            if (this.getEditor() == null || this.getEditor().isDisposed()) {
                return;
            }
            if (this.getEditor().getVisible()) {
                this.hadFocus = this.getEditor().isFocusControl();
            }
            this.getEditor().setBounds(this.customComputeBounds(this.superComputeBounds()));
            if (this.hadFocus) {
                if (this.getEditor() == null || this.getEditor().isDisposed()) {
                    return;
                }
                this.getEditor().setFocus();
            }
        }

        Rectangle customComputeBounds(Rectangle rect) {
            Rectangle r = new Rectangle(rect.x + (XPathChangeValueAction.this.width == -1 ? 0 : XPathChangeValueAction.this.width), rect.y, rect.width, rect.height);
            return r;
        }

        Rectangle superComputeBounds() {
            if (this.getItem() == null || this.getColumn() == -1 || this.getItem().isDisposed()) {
                return new Rectangle(0, 0, 0, 0);
            }
            Rectangle cell = this.getItem().getBounds(this.getColumn());
            Rectangle rect = this.getItem().getImageBounds(this.getColumn());
            cell.x = rect.x + rect.width;
            cell.width -= rect.width;
            Rectangle area = XPathChangeValueAction.this.tree.getClientArea();
            if (cell.x < area.x + area.width && cell.x + cell.width > area.x + area.width) {
                cell.width = area.x + area.width - cell.x;
            }
            Rectangle editorRect = new Rectangle(cell.x, cell.y, this.minimumWidth, this.minimumHeight);
            if (this.grabHorizontal) {
                if (XPathChangeValueAction.this.tree.getColumnCount() == 0) {
                    cell.width = area.x + area.width - cell.x;
                }
                editorRect.width = Math.max(cell.width, this.minimumWidth);
            }
            if (this.grabVertical) {
                editorRect.height = Math.max(cell.height, this.minimumHeight);
            }
            if (this.horizontalAlignment == 131072) {
                editorRect.x += cell.width - editorRect.width;
            } else if (this.horizontalAlignment != 16384) {
                editorRect.x += (cell.width - editorRect.width) / 2;
            }
            editorRect.x = Math.max(cell.x, editorRect.x);
            if (this.verticalAlignment == 1024) {
                editorRect.y += cell.height - editorRect.height;
            } else if (this.verticalAlignment != 128) {
                editorRect.y += (cell.height - editorRect.height) / 2;
            }
            return editorRect;
        }
    }
}

