/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.XPathTreeContentProvider;

public class XPathTreeLabelProvider
extends LabelProvider {
    private Image rootImage;

    public XPathTreeLabelProvider() {
        ImageDescriptor des = ImageDescriptor.createFromURL((URL)JBossServerUIPlugin.getDefault().getBundle().getEntry("icons/XMLFile.gif"));
        this.rootImage = des.createImage();
    }

    public Image getImage(Object element) {
        if (element instanceof XPathTreeContentProvider.ServerWrapper) {
            return this.rootImage;
        }
        if (element instanceof XPathCategory) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof XPathQuery) {
            return JBossServerUISharedImages.getImage("xpath_level_1");
        }
        if (element instanceof XPathFileResult) {
            return JBossServerUISharedImages.getImage("xpath_level_2");
        }
        if (element instanceof XPathFileResult.XPathResultNode) {
            return JBossServerUISharedImages.getImage("xpath_level_3");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof XPathTreeContentProvider.ServerWrapper) {
            return Messages.XPathTreeLabelProvider_XMLConfigLabel;
        }
        if (element == XPathTreeContentProvider.LOADING) {
            return Messages.XPathTreeLabelProvider_LoadingLabel;
        }
        if (element instanceof XPathCategory) {
            return ((XPathCategory)element).getName();
        }
        if (element instanceof XPathQuery) {
            return ((XPathQuery)element).getName();
        }
        if (element instanceof XPathFileResult) {
            return ((XPathFileResult)element).getFileLocation();
        }
        if (element instanceof XPathFileResult.XPathResultNode) {
            return MessageFormat.format(Messages.XPathTreeLabelProvider_MatchIndexLabel, ((XPathFileResult.XPathResultNode)element).getIndex());
        }
        return "";
    }

    public XPathFileResult.XPathResultNode[] getResultNodes(XPathQuery query) {
        ArrayList<XPathFileResult.XPathResultNode> l = new ArrayList<XPathFileResult.XPathResultNode>();
        XPathFileResult[] files = query.getResults();
        int i = 0;
        while (i < files.length) {
            l.addAll(Arrays.asList(files[i].getChildren()));
            ++i;
        }
        return l.toArray(new XPathFileResult.XPathResultNode[l.size()]);
    }
}

