/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;

public class JBossConfigurationTableViewer
extends TableViewer {
    private String selectedConfiguration;

    public JBossConfigurationTableViewer(Composite parent) {
        super(parent);
        this.init();
    }

    public JBossConfigurationTableViewer(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public JBossConfigurationTableViewer(Table table) {
        super(table);
        this.init();
    }

    public void setFolder(String folder) {
        this.setInput(folder);
    }

    public String getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    public void setConfiguration(String defaultConfiguration) {
        this.setSelection((ISelection)new StructuredSelection((Object)defaultConfiguration));
        this.selectedConfiguration = defaultConfiguration;
    }

    private void init() {
        ConfigurationProvider provider = new ConfigurationProvider();
        this.setContentProvider((IContentProvider)provider);
        this.setLabelProvider((IBaseLabelProvider)provider);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JBossConfigurationTableViewer.this.configurationSelected();
            }
        });
    }

    protected String getCurrentlySelectedConfiguration() {
        if (this.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            return (String)selection.getFirstElement();
        }
        return null;
    }

    protected void configurationSelected() {
        this.selectedConfiguration = this.getCurrentlySelectedConfiguration();
    }

    protected class ConfigurationProvider
    implements IStructuredContentProvider,
    ILabelProvider {
        protected ConfigurationProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> configList = new ArrayList<String>();
            File serverDirectory = new File(inputElement.toString());
            if (serverDirectory.exists()) {
                File[] types = serverDirectory.listFiles();
                int i = 0;
                while (i < types.length) {
                    File serviceDescriptor = new File(String.valueOf(types[i].getAbsolutePath()) + File.separator + "conf" + File.separator + "jboss-service.xml");
                    if (types[i].isDirectory() && serviceDescriptor.exists()) {
                        String configuration = types[i].getName();
                        configList.add(configuration);
                    }
                    ++i;
                }
                if (configList.size() > 0) {
                    JBossConfigurationTableViewer.this.getControl().setEnabled(true);
                }
            }
            return configList.toArray();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return JBossServerUISharedImages.getImage("jbossconfiguration");
        }

        public String getText(Object element) {
            return (String)element;
        }
    }
}

