/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.LocalJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.util.JBossServerType;
import org.jboss.ide.eclipse.as.core.util.ServerBeanLoader;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.wizards.JBossConfigurationTableViewer;
import org.jboss.tools.jmx.core.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRuntimeWizardFragment
extends WizardFragment {
    private IWizardHandle handle;
    private boolean beenEntered = false;
    private Label nameLabel;
    private Label homeDirLabel;
    private Label installedJRELabel;
    private Label explanationLabel;
    private Text nameText;
    private Text homeDirText;
    private Combo jreCombo;
    private int jreComboIndex;
    private Button homeDirButton;
    private Button jreButton;
    private Composite nameComposite;
    private Composite homeDirComposite;
    private Composite jreComposite;
    private String name;
    private String homeDir;
    private Composite configComposite;
    private Group configGroup;
    private Label configDirLabel;
    private Text configDirText;
    private JBossConfigurationTableViewer configurations;
    private Button configCopy;
    private Button configBrowse;
    private Button configDelete;
    private String configDirTextVal;
    protected List<IVMInstall> installedJREs;
    protected String[] jreNames;
    protected int defaultVMIndex;
    private IVMInstall selectedVM;
    private String originalName;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.updateJREs();
        this.createExplanation(main);
        this.createNameComposite(main);
        this.createHomeComposite(main);
        this.createJREComposite(main);
        this.createConfigurationComposite(main);
        this.fillWidgets();
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        String version = r.getRuntimeType().getVersion();
        handle.setTitle(Messages.rwf_JBossRuntime);
        String description = NLS.bind((String)(this.isEAP() ? Messages.JBEAP_version : Messages.JBAS_version), (Object)version);
        handle.setImageDescriptor(this.getImageDescriptor());
        handle.setDescription(description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.ide.eclipse.as.doc.user.new_server_runtime");
        return main;
    }

    protected boolean isEAP() {
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        return rt.getRuntimeType().getId().startsWith("org.jboss.ide.eclipse.as.runtime.eap.");
    }

    protected ImageDescriptor getImageDescriptor() {
        String imageKey = "jbossLogo";
        return JBossServerUISharedImages.getImageDescriptor(imageKey);
    }

    private void fillWidgets() {
        boolean canEdit = true;
        IJBossServerRuntime rt = this.getRuntime();
        if (rt != null) {
            this.originalName = rt.getRuntime().getName();
            this.nameText.setText(this.originalName);
            this.name = this.originalName;
            if (rt.getRuntime().getLocation() == null) {
                Preferences prefs = JBossServerUIPlugin.getDefault().getPluginPreferences();
                String value = prefs.getString("org.jboss.ide.eclipse.as.ui.preferences.runtime.last.type." + rt.getRuntime().getRuntimeType().getId());
                String locationDefault = Platform.getOS().equals("win32") ? "c:/program files/jboss-" : "/usr/bin/jboss-";
                String version = rt.getRuntime().getRuntimeType().getVersion();
                locationDefault = String.valueOf(locationDefault) + version + ".x";
                this.homeDir = value != null && value.length() != 0 ? value : locationDefault;
            } else {
                this.homeDir = rt.getRuntime().getLocation().toOSString();
            }
            this.homeDirText.setText(this.homeDir);
            ((IRuntimeWorkingCopy)rt.getRuntime()).setLocation((IPath)new Path(this.homeDir));
            String dirText = rt.getConfigLocation();
            this.configDirText.setText(dirText == null ? "server" : dirText);
            this.configurations.setConfiguration(rt.getJBossConfiguration() == null ? "default" : rt.getJBossConfiguration());
            if (rt.isUsingDefaultJRE()) {
                this.jreCombo.select(0);
            } else {
                IVMInstall install = rt.getVM();
                if (install != null) {
                    String vmName = install.getName();
                    String[] jres = this.jreCombo.getItems();
                    int i = 0;
                    while (i < jres.length) {
                        if (vmName.equals(jres[i])) {
                            this.jreCombo.select(i);
                        }
                        ++i;
                    }
                }
            }
            this.jreComboIndex = this.jreCombo.getSelectionIndex();
            this.homeDirText.setEditable(canEdit);
            this.homeDirButton.setEnabled(canEdit);
            this.configurations.getTable().setVisible(canEdit);
            if (this.jreCombo.getSelectionIndex() < 0 && this.jreCombo.getItemCount() > 0) {
                this.jreCombo.select(0);
            }
        }
    }

    private IJBossServerRuntime getRuntime() {
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        IJBossServerRuntime ajbsrt = null;
        if (r != null) {
            ajbsrt = (IJBossServerRuntime)r.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return ajbsrt;
    }

    private void createExplanation(Composite main) {
        this.explanationLabel = new Label(main, 64);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.explanationLabel.setLayoutData((Object)data);
        this.explanationLabel.setText(Messages.rwf_Explanation);
    }

    private void createNameComposite(Composite main) {
        this.nameComposite = new Composite(main, 0);
        FormData cData = new FormData();
        cData.left = new FormAttachment(0, 5);
        cData.right = new FormAttachment(100, -5);
        cData.top = new FormAttachment((Control)this.explanationLabel, 10);
        this.nameComposite.setLayoutData((Object)cData);
        this.nameComposite.setLayout((Layout)new FormLayout());
        this.nameLabel = new Label(this.nameComposite, 0);
        this.nameLabel.setText(Messages.wf_NameLabel);
        this.nameText = new Text(this.nameComposite, 2048);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossRuntimeWizardFragment.this.name = JBossRuntimeWizardFragment.this.nameText.getText();
                JBossRuntimeWizardFragment.this.updatePage();
            }
        });
        FormData nameLabelData = new FormData();
        nameLabelData.left = new FormAttachment(0, 0);
        this.nameLabel.setLayoutData((Object)nameLabelData);
        FormData nameTextData = new FormData();
        nameTextData.left = new FormAttachment(0, 5);
        nameTextData.right = new FormAttachment(100, -5);
        nameTextData.top = new FormAttachment((Control)this.nameLabel, 5);
        this.nameText.setLayoutData((Object)nameTextData);
    }

    private void createHomeComposite(Composite main) {
        this.homeDirComposite = new Composite(main, 0);
        FormData cData = new FormData();
        cData.left = new FormAttachment(0, 5);
        cData.right = new FormAttachment(100, -5);
        cData.top = new FormAttachment((Control)this.nameComposite, 10);
        this.homeDirComposite.setLayoutData((Object)cData);
        this.homeDirComposite.setLayout((Layout)new FormLayout());
        this.homeDirLabel = new Label(this.homeDirComposite, 0);
        this.homeDirLabel.setText(Messages.wf_HomeDirLabel);
        this.homeDirText = new Text(this.homeDirComposite, 2048);
        this.homeDirButton = new Button(this.homeDirComposite, 0);
        this.homeDirButton.setText(Messages.browse);
        this.homeDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossRuntimeWizardFragment.this.homeDir = JBossRuntimeWizardFragment.this.homeDirText.getText();
                JBossRuntimeWizardFragment.this.updatePage();
            }
        });
        this.homeDirButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.browseHomeDirClicked();
            }

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.browseHomeDirClicked();
            }
        });
        FormData labelData = new FormData();
        FormData textData = new FormData();
        FormData buttonData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        this.homeDirLabel.setLayoutData((Object)labelData);
        textData.left = new FormAttachment(0, 5);
        textData.right = new FormAttachment((Control)this.homeDirButton, -5);
        textData.top = new FormAttachment((Control)this.homeDirLabel, 5);
        this.homeDirText.setLayoutData((Object)textData);
        buttonData.top = new FormAttachment((Control)this.homeDirLabel, 5);
        buttonData.right = new FormAttachment(100, 0);
        this.homeDirButton.setLayoutData((Object)buttonData);
    }

    private void createJREComposite(Composite main) {
        this.jreComposite = new Composite(main, 0);
        FormData cData = new FormData();
        cData.left = new FormAttachment(0, 5);
        cData.right = new FormAttachment(100, -5);
        cData.top = new FormAttachment((Control)this.homeDirComposite, 10);
        this.jreComposite.setLayoutData((Object)cData);
        this.jreComposite.setLayout((Layout)new FormLayout());
        this.installedJRELabel = new Label(this.jreComposite, 0);
        this.installedJRELabel.setText(Messages.wf_JRELabel);
        this.jreCombo = new Combo(this.jreComposite, 12);
        this.jreCombo.setItems(this.jreNames);
        if (this.defaultVMIndex != -1) {
            this.jreCombo.select(this.defaultVMIndex);
        }
        this.jreButton = new Button(this.jreComposite, 0);
        this.jreButton.setText(Messages.wf_JRELabel);
        this.jreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = JBossRuntimeWizardFragment.this.jreCombo.getText();
                if (JBossRuntimeWizardFragment.this.showPreferencePage()) {
                    JBossRuntimeWizardFragment.this.updateJREs();
                    JBossRuntimeWizardFragment.this.jreCombo.setItems(JBossRuntimeWizardFragment.this.jreNames);
                    JBossRuntimeWizardFragment.this.jreCombo.setText(currentVM);
                    if (JBossRuntimeWizardFragment.this.jreCombo.getSelectionIndex() == -1) {
                        JBossRuntimeWizardFragment.this.jreCombo.select(JBossRuntimeWizardFragment.this.defaultVMIndex);
                    }
                    JBossRuntimeWizardFragment.this.jreComboIndex = JBossRuntimeWizardFragment.this.jreCombo.getSelectionIndex();
                    JBossRuntimeWizardFragment.this.updateErrorMessage();
                }
            }
        });
        this.jreCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.updatePage();
            }

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.updatePage();
            }
        });
        FormData labelData = new FormData();
        FormData comboData = new FormData();
        FormData buttonData = new FormData();
        labelData.left = new FormAttachment(0, 0);
        this.installedJRELabel.setLayoutData((Object)labelData);
        comboData.left = new FormAttachment(0, 5);
        comboData.right = new FormAttachment((Control)this.jreButton, -5);
        comboData.top = new FormAttachment((Control)this.installedJRELabel, 5);
        this.jreCombo.setLayoutData((Object)comboData);
        buttonData.top = new FormAttachment((Control)this.installedJRELabel, 5);
        buttonData.right = new FormAttachment(100, 0);
        this.jreButton.setLayoutData((Object)buttonData);
    }

    private void createConfigurationComposite(Composite main) {
        UIUtil u = new UIUtil();
        this.configComposite = new Composite(main, 0);
        this.configComposite.setLayoutData((Object)u.createFormData(this.jreComposite, 10, 100, -5, 0, 5, 100, -5));
        this.configComposite.setLayout((Layout)new FormLayout());
        this.configGroup = new Group(this.configComposite, -1);
        this.configGroup.setText(Messages.wf_ConfigLabel);
        this.configGroup.setLayoutData((Object)u.createFormData(0, 0, 100, 0, 0, 0, 100, 0));
        this.configGroup.setLayout((Layout)new FormLayout());
        this.configDirLabel = new Label((Composite)this.configGroup, 0);
        this.configDirLabel.setText(Messages.directory);
        this.configDirText = new Text((Composite)this.configGroup, 2048);
        this.configurations = new JBossConfigurationTableViewer((Composite)this.configGroup, 2052);
        this.configBrowse = new Button((Composite)this.configGroup, -1);
        this.configCopy = new Button((Composite)this.configGroup, -1);
        this.configDelete = new Button((Composite)this.configGroup, -1);
        this.configBrowse.setText(Messages.browse);
        this.configCopy.setText(Messages.copy);
        this.configDelete.setText(Messages.delete);
        this.configDirLabel.setLayoutData((Object)u.createFormData(2, 5, null, 0, 0, 5, null, 0));
        this.configDirText.setLayoutData((Object)u.createFormData(0, 5, null, 0, this.configDirLabel, 5, this.configBrowse, -5));
        this.configBrowse.setLayoutData((Object)u.createFormData(0, 5, null, 0, this.configurations.getTable(), 5, 100, -5));
        this.configurations.getTable().setLayoutData((Object)u.createFormData(this.configDirText, 5, 100, -5, 0, 5, 80, 0));
        this.configCopy.setLayoutData((Object)u.createFormData(this.configBrowse, 5, null, 0, this.configurations.getTable(), 5, 100, -5));
        this.configDelete.setLayoutData((Object)u.createFormData(this.configCopy, 5, null, 0, this.configurations.getTable(), 5, 100, -5));
        this.configDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossRuntimeWizardFragment.this.updatePage();
            }
        });
        this.configBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.configBrowsePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.configCopy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.configCopyPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.configDelete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRuntimeWizardFragment.this.configDeletePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.configurations.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JBossRuntimeWizardFragment.this.updateErrorMessage();
                JBossRuntimeWizardFragment.this.configDelete.setEnabled(!((IStructuredSelection)JBossRuntimeWizardFragment.this.configurations.getSelection()).isEmpty());
                JBossRuntimeWizardFragment.this.configCopy.setEnabled(!((IStructuredSelection)JBossRuntimeWizardFragment.this.configurations.getSelection()).isEmpty());
            }
        });
    }

    protected void configBrowsePressed() {
        File directory;
        String folder = new Path(this.configDirText.getText()).isAbsolute() ? this.configDirText.getText() : new Path(this.homeDir).append(this.configDirText.getText()).toString();
        File file = new File(folder);
        if (!file.exists()) {
            file = null;
        }
        if ((directory = JBossRuntimeWizardFragment.getDirectory(file, this.homeDirComposite.getShell())) != null) {
            if (directory.getAbsolutePath().startsWith(new Path(this.homeDir).toString())) {
                String result = directory.getAbsolutePath().substring(this.homeDir.length());
                this.configDirText.setText(new Path(result).makeRelative().toString());
            } else {
                this.configDirText.setText(directory.getAbsolutePath());
            }
        }
    }

    protected void configCopyPressed() {
        CopyConfigurationDialog d = new CopyConfigurationDialog(this.configCopy.getShell(), this.homeDir, this.configDirText.getText(), this.configurations.getCurrentlySelectedConfiguration());
        if (d.open() == 0) {
            Path source = new Path(this.configDirText.getText());
            if (!source.isAbsolute()) {
                source = new Path(this.homeDir).append((IPath)source);
            }
            source = source.append(this.configurations.getCurrentlySelectedConfiguration());
            Path dest = new Path(d.getNewDest());
            if (!dest.isAbsolute()) {
                dest = new Path(this.homeDir).append((IPath)dest);
            }
            dest = dest.append(d.getNewConfig());
            dest.toFile().mkdirs();
            FileUtil.copyDir((File)source.toFile(), (File)dest.toFile());
            this.configDirText.setText(d.getNewDest());
            this.configurations.setSelection((ISelection)new StructuredSelection((Object)d.getNewConfig()));
        }
    }

    protected void configDeletePressed() {
        MessageDialog dialog = new MessageDialog(this.configBrowse.getShell(), Messages.JBossRuntimeWizardFragment_DeleteConfigTitle, null, Messages.JBossRuntimeWizardFragment_DeleteConfigConfirmation, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (dialog.open() == 0) {
            String config = this.configurations.getCurrentlySelectedConfiguration();
            String configDir = this.configDirText.getText();
            File folder = !new Path(configDir).isAbsolute() ? new Path(this.homeDir).append(configDir).append(config).toFile() : new Path(configDir).append(config).toFile();
            org.jboss.ide.eclipse.as.core.util.FileUtil.completeDelete((File)folder);
            this.configurations.refresh();
            this.updatePage();
        }
    }

    private void updatePage() {
        String folder;
        if (!this.isHomeValid()) {
            this.configurations.getControl().setEnabled(false);
            folder = this.homeDirText.getText();
        } else {
            Path p = new Path(this.configDirText.getText());
            folder = p.isAbsolute() ? p.toString() : new Path(this.homeDirText.getText()).append((IPath)p).toString();
        }
        this.configurations.setFolder(folder);
        File f = new File(folder);
        this.configurations.getControl().setEnabled(f.exists() && f.isDirectory());
        this.configurations.setConfiguration("default");
        int sel = this.jreCombo.getSelectionIndex();
        int offset = -1;
        this.selectedVM = sel + offset >= 0 ? this.installedJREs.get(sel + offset) : null;
        this.configDirTextVal = this.configDirText.getText();
        this.updateErrorMessage();
    }

    private void updateErrorMessage() {
        String error = this.getErrorString();
        if (error == null) {
            String warn = this.getWarningString();
            if (warn != null) {
                this.handle.setMessage(warn, 2);
            } else {
                this.handle.setMessage(null, 0);
            }
        } else {
            this.handle.setMessage(error, 3);
        }
    }

    protected String getErrorString() {
        if (this.nameText == null) {
            return null;
        }
        if (this.getRuntime(this.name) != null) {
            return Messages.rwf_NameInUse;
        }
        if (this.getValidJREs().size() == 0) {
            String error = "No valid JREs found for execution environment \"" + this.getRuntime().getExecutionEnvironment().getId() + "\"";
            return error;
        }
        if (!this.isHomeValid()) {
            return Messages.rwf_homeMissingFiles;
        }
        if (this.name == null || this.name.equals("")) {
            return Messages.rwf_nameTextBlank;
        }
        if (this.homeDir == null || this.homeDir.equals("")) {
            return Messages.rwf_homeDirBlank;
        }
        if (this.jreComboIndex < 0) {
            return Messages.rwf_NoVMSelected;
        }
        if (this.configurations.getSelection().isEmpty()) {
            return Messages.JBossRuntimeWizardFragment_MustSelectValidConfig;
        }
        return null;
    }

    private String getWarningString() {
        if (this.getHomeVersionWarning() != null) {
            return this.getHomeVersionWarning();
        }
        return null;
    }

    protected boolean isHomeValid() {
        if (this.homeDir == null || !new File(this.homeDir).exists()) {
            return false;
        }
        return new Path(this.homeDir).append("bin").append("run.jar").toFile().exists();
    }

    protected String getHomeVersionWarning() {
        IRuntime rt;
        String v;
        String version = new ServerBeanLoader().getFullServerVersion(new File(this.homeDir, JBossServerType.AS.getSystemJarPath()));
        return version.startsWith(v = (rt = (IRuntime)this.getTaskModel().getObject("runtime")).getRuntimeType().getVersion()) ? null : NLS.bind((String)Messages.rwf_homeIncorrectVersion, (Object)v, (Object)version);
    }

    private void browseHomeDirClicked() {
        File directory;
        File file = new File(this.homeDir);
        if (!file.exists()) {
            file = null;
        }
        if ((directory = JBossRuntimeWizardFragment.getDirectory(file, this.homeDirComposite.getShell())) != null) {
            this.homeDir = directory.getAbsolutePath();
            this.homeDirText.setText(this.homeDir);
        }
    }

    protected static File getDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    protected boolean showPreferencePage() {
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode("org.eclipse.jdt.debug.ui.preferences.VMPreferencePage");
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        final PreferenceDialog dialog = new PreferenceDialog(this.jreButton.getShell(), manager2);
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.jreButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                if (dialog.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    protected void updateJREs() {
        this.installedJREs = this.getValidJREs();
        int size = this.installedJREs.size();
        int index = 0;
        this.jreNames = new String[++size];
        this.jreNames[index++] = "Default JRE for " + this.getRuntime().getExecutionEnvironment().getId();
        int i = 0;
        while (i < this.installedJREs.size()) {
            IVMInstall vmInstall = this.installedJREs.get(i);
            this.jreNames[index++] = vmInstall.getName();
            ++i;
        }
        this.defaultVMIndex = 0;
    }

    protected List<IVMInstall> getValidJREs() {
        return Arrays.asList(LocalJBossServerRuntime.getValidJREs((IRuntimeType)this.getRuntimeType()));
    }

    public void enter() {
        this.beenEntered = true;
    }

    public void exit() {
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        IRuntimeWorkingCopy runtimeWC = r.isWorkingCopy() ? (IRuntimeWorkingCopy)r : r.createWorkingCopy();
        runtimeWC.setName(this.name);
        runtimeWC.setLocation((IPath)new Path(this.homeDir));
        IJBossServerRuntime srt = (IJBossServerRuntime)runtimeWC.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        srt.setVM(this.selectedVM);
        srt.setJBossConfiguration(this.configurations.getSelectedConfiguration());
        srt.setConfigLocation(this.configDirTextVal);
        this.getTaskModel().putObject("runtime", (Object)runtimeWC);
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.exit();
        IRuntimeWorkingCopy r = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        IRuntime saved = r.save(false, (IProgressMonitor)new NullProgressMonitor());
        Preferences prefs = JBossServerUIPlugin.getDefault().getPluginPreferences();
        prefs.setValue("org.jboss.ide.eclipse.as.ui.preferences.runtime.last.type." + saved.getRuntimeType().getId(), this.homeDir);
        this.getTaskModel().putObject("runtime", (Object)saved);
    }

    public boolean isComplete() {
        return this.beenEntered && this.getErrorString() == null;
    }

    public boolean hasComposite() {
        return true;
    }

    private IRuntime getRuntime(String runtimeName) {
        if (runtimeName.equals(this.originalName)) {
            return null;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            if (runtimes[i].getName().equals(runtimeName)) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    public IRuntimeType getRuntimeType() {
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        return r.getRuntimeType();
    }

    public static class CopyConfigurationDialog
    extends TitleAreaDialog {
        private String origHome;
        private String origDest;
        private String origConfig;
        private String newDest;
        private String newConfig;
        private Text destText;

        protected CopyConfigurationDialog(Shell parentShell, String home, String dir, String config) {
            super(new Shell(parentShell));
            this.origHome = home;
            this.origDest = dir;
            this.origConfig = config;
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            Composite main = new Composite(c, 0);
            main.setLayoutData((Object)new GridData(1808));
            main.setLayout((Layout)new FormLayout());
            this.setCleanMessage();
            Label nameLabel = new Label(main, 0);
            nameLabel.setText(Messages.wf_NameLabel);
            final Text nameText = new Text(main, 2048);
            Label destLabel = new Label(main, 0);
            destLabel.setText(Messages.rwf_DestinationLabel);
            this.destText = new Text(main, 2048);
            Button browse = new Button(main, 8);
            browse.setText(Messages.browse);
            Point nameSize = new GC((Drawable)nameLabel).textExtent(nameLabel.getText());
            Point destSize = new GC((Drawable)destLabel).textExtent(destLabel.getText());
            Label wider = nameSize.x > destSize.x ? nameLabel : destLabel;
            nameText.setLayoutData((Object)UIUtil.createFormData2(0, 13, null, 0, wider, 5, 100, -5));
            nameLabel.setLayoutData((Object)UIUtil.createFormData2(0, 15, null, 0, 0, 5, null, 0));
            this.destText.setLayoutData((Object)UIUtil.createFormData2(nameText, 5, null, 0, wider, 5, browse, -5));
            destLabel.setLayoutData((Object)UIUtil.createFormData2(nameText, 7, null, 0, 0, 5, null, 0));
            browse.setLayoutData((Object)UIUtil.createFormData2(nameText, 5, null, 0, null, 0, 100, -5));
            nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CopyConfigurationDialog.this.newConfig = nameText.getText();
                    CopyConfigurationDialog.this.validate();
                }
            });
            this.destText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CopyConfigurationDialog.this.newDest = CopyConfigurationDialog.this.destText.getText();
                    CopyConfigurationDialog.this.validate();
                }
            });
            browse.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    File directory;
                    File file;
                    Path p = new Path(CopyConfigurationDialog.this.newDest);
                    if (!p.isAbsolute()) {
                        p = new Path(CopyConfigurationDialog.this.origHome).append(CopyConfigurationDialog.this.newDest);
                    }
                    if (!(file = p.toFile()).exists()) {
                        file = null;
                    }
                    if ((directory = JBossRuntimeWizardFragment.getDirectory(file, CopyConfigurationDialog.this.getShell())) != null) {
                        Path newP = new Path(directory.getAbsolutePath());
                        Object result = newP.toOSString().startsWith(new Path(CopyConfigurationDialog.this.origHome).toOSString()) ? newP.removeFirstSegments(new Path(CopyConfigurationDialog.this.origHome).segmentCount()) : newP;
                        CopyConfigurationDialog.this.destText.setText(result.toString());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.destText.setText(this.origDest);
            nameText.setText(this.findNewest(String.valueOf(this.origConfig) + "_copy"));
            return c;
        }

        public void validate() {
            boolean valid = false;
            Path p = null;
            if (this.newDest != null && this.newConfig != null) {
                p = new Path(this.newDest);
                if (!p.isAbsolute()) {
                    p = new Path(this.origHome).append(this.newDest);
                }
                if (!p.append(this.newConfig).toFile().exists()) {
                    valid = true;
                }
            }
            if (!valid) {
                if (this.newDest == null || this.newConfig == null) {
                    this.setMessage(Messages.JBossRuntimeWizardFragment_AllFieldsRequired, 3);
                } else {
                    this.setMessage(String.valueOf(Messages.JBossRuntimeWizardFragment_OutputFolderExists) + p.append(this.newConfig).toString(), 3);
                }
            } else {
                this.setCleanMessage();
            }
            if (this.getOKButton() != null) {
                this.getOKButton().setEnabled(valid);
            }
        }

        protected void setCleanMessage() {
            this.setMessage(NLS.bind((String)Messages.rwf_CopyConfigLabel, (Object)this.origConfig, (Object)this.origDest));
        }

        protected String findNewest(String suggested) {
            Path p = new Path(this.origDest);
            if (!p.isAbsolute()) {
                p = new Path(this.origHome).append(this.origDest);
            }
            if (p.append(suggested).toFile().exists()) {
                int i = 1;
                while (p.append(String.valueOf(suggested) + i).toFile().exists()) {
                    ++i;
                }
                return String.valueOf(suggested) + i;
            }
            return suggested;
        }

        protected Point getInitialSize() {
            return new Point(500, super.getInitialSize().y);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.JBossRuntimeWizardFragment_CopyAConfigShellText);
        }

        public String getNewDest() {
            return this.newDest;
        }

        public String getNewConfig() {
            return this.newConfig;
        }
    }
}

