/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;

public class JBossServerWizardFragment
extends WizardFragment {
    private IWizardHandle handle;
    private Label serverExplanationLabel;
    private Label runtimeExplanationLabel;
    private Label homeDirLabel;
    private Label installedJRELabel;
    private Label configLabel;
    private Label homeValLabel;
    private Label jreValLabel;
    private Label configValLabel;
    private Label configLocValLabel;
    private Group runtimeGroup;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.createExplanationLabel(main);
        this.createRuntimeGroup(main);
        handle.setTitle(Messages.swf_Title);
        handle.setImageDescriptor(this.getImageDescriptor());
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        String version = r.getRuntimeType().getVersion();
        String description = NLS.bind((String)(this.isEAP() ? Messages.JBEAP_version : Messages.JBAS_version), (Object)version);
        handle.setDescription(description);
        return main;
    }

    protected boolean isEAP() {
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        return rt.getRuntimeType().getId().startsWith("org.jboss.ide.eclipse.as.runtime.eap.");
    }

    public ImageDescriptor getImageDescriptor() {
        String imageKey = "jbossLogo";
        return JBossServerUISharedImages.getImageDescriptor(imageKey);
    }

    private void createExplanationLabel(Composite main) {
        this.serverExplanationLabel = new Label(main, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.serverExplanationLabel.setLayoutData((Object)data);
        this.serverExplanationLabel.setText(Messages.swf_Explanation);
    }

    private void createRuntimeGroup(Composite main) {
        this.runtimeGroup = new Group(main, 0);
        this.runtimeGroup.setText(Messages.swf_RuntimeInformation);
        FormData groupData = new FormData();
        groupData.left = new FormAttachment(0, 5);
        groupData.right = new FormAttachment(100, -5);
        groupData.top = new FormAttachment((Control)this.serverExplanationLabel, 5);
        this.runtimeGroup.setLayoutData((Object)groupData);
        this.runtimeGroup.setLayout((Layout)new GridLayout(2, false));
        GridData d = new GridData(1, 0x1000000, true, false);
        this.runtimeExplanationLabel = new Label((Composite)this.runtimeGroup, 0);
        this.runtimeExplanationLabel.setText(Messages.swf_Explanation2);
        GridData explanationData = new GridData(1, 0x1000000, true, false);
        explanationData.horizontalSpan = 2;
        this.runtimeExplanationLabel.setLayoutData((Object)explanationData);
        this.homeDirLabel = new Label((Composite)this.runtimeGroup, 0);
        this.homeDirLabel.setText(Messages.wf_HomeDirLabel);
        this.homeValLabel = new Label((Composite)this.runtimeGroup, 0);
        this.homeValLabel.setLayoutData((Object)d);
        this.installedJRELabel = new Label((Composite)this.runtimeGroup, 0);
        this.installedJRELabel.setText(Messages.wf_JRELabel);
        this.jreValLabel = new Label((Composite)this.runtimeGroup, 0);
        d = new GridData(1, 0x1000000, true, false);
        this.jreValLabel.setLayoutData((Object)d);
        Label configLocationLabel = new Label((Composite)this.runtimeGroup, 0);
        configLocationLabel.setText(Messages.swf_ConfigurationLocation);
        this.configLocValLabel = new Label((Composite)this.runtimeGroup, 0);
        this.configLabel = new Label((Composite)this.runtimeGroup, 0);
        this.configLabel.setText(Messages.wf_ConfigLabel);
        this.configValLabel = new Label((Composite)this.runtimeGroup, 0);
        d = new GridData(1, 0x1000000, true, false);
        this.configValLabel.setLayoutData((Object)d);
    }

    private void updateErrorMessage() {
        String error = this.getErrorString();
        if (error == null) {
            this.handle.setMessage(null, 0);
        } else {
            this.handle.setMessage(error, 3);
        }
    }

    private String getErrorString() {
        return null;
    }

    public void enter() {
        if (this.homeValLabel != null && !this.homeValLabel.isDisposed()) {
            IJBossServerRuntime srt = this.getRuntime();
            this.homeValLabel.setText(srt.getRuntime().getLocation().toOSString());
            this.configValLabel.setText(srt.getJBossConfiguration());
            this.jreValLabel.setText(String.valueOf(srt.getVM().getInstallLocation().getAbsolutePath()) + " (" + srt.getVM().getName() + ")");
            this.configLocValLabel.setText(srt.getConfigLocation());
            this.runtimeGroup.layout();
            this.updateErrorMessage();
        }
    }

    public void exit() {
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IServerWorkingCopy serverWC = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        JBossServer jbs = (JBossServer)serverWC.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor());
        jbs.setUsername("admin");
        jbs.setPassword("admin");
        jbs.setDeployLocationType(this.isAS5() ? "server" : "metadata");
        serverWC.setRuntime((IRuntime)this.getTaskModel().getObject("runtime"));
        serverWC.setServerConfiguration(null);
    }

    private IJBossServerRuntime getRuntime() {
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        IJBossServerRuntime ajbsrt = null;
        if (r != null) {
            ajbsrt = (IJBossServerRuntime)r.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return ajbsrt;
    }

    protected boolean isAS5() {
        return this.getRuntime().getRuntime().getRuntimeType().getVersion().equals("5.0");
    }

    public boolean isComplete() {
        return this.getErrorString() == null;
    }

    public boolean hasComposite() {
        return true;
    }
}

