/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;

public class StrippedServerWizardFragment
extends WizardFragment {
    private IWizardHandle handle;
    private Label deployLabel;
    private Label nameLabel;
    private Text deployText;
    private Text nameText;
    private Button browse;
    private String name;
    private String deployLoc;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.nameLabel = new Label(main, 0);
        this.nameText = new Text(main, 2048);
        this.nameLabel.setText(Messages.serverName);
        this.deployLabel = new Label(main, 0);
        this.deployText = new Text(main, 2048);
        this.browse = new Button(main, 8);
        this.deployLabel.setText(Messages.swf_DeployDirectory);
        this.browse.setText(Messages.browse);
        FormData namelData = new FormData();
        namelData.top = new FormAttachment(0, 5);
        namelData.left = new FormAttachment(0, 5);
        this.nameLabel.setLayoutData((Object)namelData);
        FormData nametData = new FormData();
        nametData.top = new FormAttachment(0, 5);
        nametData.left = new FormAttachment((Control)this.deployLabel, 5);
        nametData.right = new FormAttachment(100, -5);
        this.nameText.setLayoutData((Object)nametData);
        FormData lData = new FormData();
        lData.top = new FormAttachment((Control)this.nameText, 5);
        lData.left = new FormAttachment(0, 5);
        this.deployLabel.setLayoutData((Object)lData);
        FormData tData = new FormData();
        tData.top = new FormAttachment((Control)this.nameText, 5);
        tData.left = new FormAttachment((Control)this.deployLabel, 5);
        tData.right = new FormAttachment((Control)this.browse, -5);
        this.deployText.setLayoutData((Object)tData);
        FormData bData = new FormData();
        bData.right = new FormAttachment(100, -5);
        bData.top = new FormAttachment((Control)this.nameText, 5);
        this.browse.setLayoutData((Object)bData);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrippedServerWizardFragment.this.textChanged();
            }
        };
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog d = new DirectoryDialog(new Shell());
                d.setFilterPath(StrippedServerWizardFragment.this.deployText.getText());
                String x = d.open();
                if (x != null) {
                    StrippedServerWizardFragment.this.deployText.setText(x);
                }
            }
        });
        this.deployText.addModifyListener(ml);
        this.nameText.addModifyListener(ml);
        this.nameText.setText(this.getDefaultNameText());
        handle.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("jbossLogo"));
        return main;
    }

    protected void textChanged() {
        IStatus status = this.checkErrors();
        if (status.isOK()) {
            this.deployLoc = this.deployText.getText();
            this.name = this.nameText.getText();
            this.handle.setMessage("", 0);
            this.handle.update();
        } else {
            this.handle.setMessage(status.getMessage(), 2);
        }
    }

    protected IStatus checkErrors() {
        if (this.findServer(this.nameText.getText()) != null) {
            return new Status(2, "org.jboss.ide.eclipse.as.ui", 0, Messages.StrippedServerWizardFragment_NameInUseStatusMessage, null);
        }
        File f = new File(this.deployText.getText());
        if (!f.exists() || !f.isDirectory()) {
            return new Status(2, "org.jboss.ide.eclipse.as.ui", 0, Messages.StrippedServerWizardFragment_DeployFolderDoesNotExistStatusMessage, null);
        }
        return new Status(0, "org.jboss.ide.eclipse.as.ui", 0, "", null);
    }

    public void enter() {
        this.handle.setTitle(Messages.sswf_Title);
        IServer s = (IServer)this.getTaskModel().getObject("server");
        IServerWorkingCopy swc = s instanceof IServerWorkingCopy ? (IServerWorkingCopy)s : s.createWorkingCopy();
        if (swc instanceof ServerWorkingCopy) {
            ServerWorkingCopy swcInternal = (ServerWorkingCopy)swc;
            this.deployText.setText(swcInternal.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", ""));
        }
    }

    public void exit() {
        this.textChanged();
        IServer s = (IServer)this.getTaskModel().getObject("server");
        IServerWorkingCopy swc = s instanceof IServerWorkingCopy ? (IServerWorkingCopy)s : s.createWorkingCopy();
        if (swc instanceof ServerWorkingCopy) {
            ServerWorkingCopy swcInternal = (ServerWorkingCopy)swc;
            swcInternal.setName(this.name);
            swcInternal.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.deployLoc);
            String tempFolder = JBossServerCorePlugin.getServerStateLocation((IServer)s).append("tempDeploy").makeAbsolute().toString();
            swcInternal.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", tempFolder);
            this.getTaskModel().putObject("server", (Object)swcInternal);
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IServerWorkingCopy serverWC = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        ServerWorkingCopy serverwc2 = serverWC instanceof ServerWorkingCopy ? (ServerWorkingCopy)serverWC : null;
        try {
            serverwc2.setServerConfiguration(null);
            serverwc2.setName(this.name);
            serverwc2.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.deployLoc);
            this.getTaskModel().putObject("server", (Object)serverwc2);
        }
        catch (Exception exception) {}
    }

    public boolean isComplete() {
        return this.checkErrors().isOK();
    }

    public boolean hasComposite() {
        return true;
    }

    private String getDefaultNameText() {
        String base = Messages.sswf_BaseName;
        if (this.findServer(base) == null) {
            return base;
        }
        int i = 1;
        while (ServerCore.findServer((String)(String.valueOf(base) + " (" + i + ")")) != null) {
            ++i;
        }
        return String.valueOf(base) + " (" + i + ")";
    }

    private IServer findServer(String name) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            Server server = (Server)servers[i];
            if (name.equals(server.getName())) {
                return server;
            }
            ++i;
        }
        return null;
    }
}

