/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.wst.server.ui.xpl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentExportDataModelProperties;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.ide.eclipse.as.ui.Messages;

public abstract class J2EEModuleExportOperation
extends AbstractDataModelOperation {
    protected IProgressMonitor progressMonitor;
    private IVirtualComponent component;
    private IModule module;
    private IPath destinationPath;
    private boolean exportSource = false;
    protected final int REFRESH_WORK = 100;
    protected final int JAVA_BUILDER_WORK = 100;
    protected final int LIB_BUILDER_WORK = 100;
    protected final int EXPORT_WORK = 1000;
    protected final int CLOSE_WORK = 10;
    protected final int SINGLE_PARTICIPANT_WORK = 200;

    public J2EEModuleExportOperation() {
    }

    public J2EEModuleExportOperation(IDataModel model) {
        super(model);
    }

    protected int computeTotalWork() {
        int totalWork = 100;
        if (this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
            totalWork += 200;
        }
        totalWork += 1010;
        IDataModel dm = this.getDataModel();
        if (dm.getProperty("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME") == Boolean.TRUE) {
            List extensions = (List)dm.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS");
            totalWork += extensions.size() * 200;
        }
        return totalWork;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.setComponent((IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT"));
        this.setDestinationPath((IPath)new Path(this.model.getStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")));
        this.setExportSource(this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES"));
        try {
            monitor.beginTask(ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Exporting_archive, (Object[])new Object[]{this.getDestinationPath().lastSegment()}), this.computeTotalWork());
            this.setProgressMonitor(monitor);
            try {
                this.component.getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
                    this.runNecessaryBuilders(this.component, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                }
                this.export();
            }
            catch (Exception e) {
                monitor.worked(10);
                throw new ExecutionException(MessageFormat.format(Messages.J2EEModuleExportOperation_ErrorExportingArchive, this.archiveString()), (Throwable)e);
            }
            IDataModel dm = this.getDataModel();
            if (dm.getProperty("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME") == Boolean.TRUE) {
                for (IJ2EEComponentExportDataModelProperties.IArchiveExportParticipantData extData : (List)dm.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS")) {
                    IDataModelOperation op = extData.getParticipant().createOperation(extData.getDataModel());
                    op.execute(null, null);
                    monitor.worked(200);
                }
            }
        }
        finally {
            monitor.done();
        }
        return OK_STATUS;
    }

    protected abstract String archiveString();

    protected void setProgressMonitor(IProgressMonitor newProgressMonitor) {
        this.progressMonitor = newProgressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private void setComponent(IVirtualComponent newComponent) {
        this.component = newComponent;
        this.setModule();
    }

    protected IVirtualComponent getComponent() {
        if (this.component == null) {
            this.component = (IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        }
        return this.component;
    }

    protected IPath getDestinationPath() {
        return this.destinationPath;
    }

    protected void setDestinationPath(IPath newDestinationPath) {
        this.destinationPath = newDestinationPath;
    }

    protected boolean isExportSource() {
        return this.exportSource;
    }

    protected void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    protected void setModule() {
        String moduleType = this.getModuleTypeID();
        if (this.component != null && this.component.getProject() != null && moduleType != null) {
            IModule[] modules = ServerUtil.getModules((IProject)this.component.getProject());
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getModuleType().getId().equals(moduleType)) {
                    this.module = modules[i];
                    return;
                }
                ++i;
            }
        }
        this.module = null;
    }

    protected abstract String getModuleTypeID();

    protected String getChildURI(IModule parent, IModule child) {
        IEnterpriseApplication app = (IEnterpriseApplication)parent.loadAdapter(IEnterpriseApplication.class, (IProgressMonitor)new NullProgressMonitor());
        if (app != null) {
            return app.getURI(child);
        }
        return null;
    }

    protected void runNecessaryBuilders(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(null, 200);
            if (!component.isBinary()) {
                ICommand libCopyBuilder;
                IProject project = component.getProject();
                IProjectDescription description = project.getDescription();
                ICommand javaBuilder = this.getJavaCommand(description);
                if (javaBuilder != null) {
                    project.build(10, "org.eclipse.jdt.core.javabuilder", javaBuilder.getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                if ((libCopyBuilder = this.getLibCopyBuilder(description)) != null) {
                    project.build(10, "org.eclipse.jst.j2ee.LibCopyBuilder", libCopyBuilder.getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    protected ICommand getLibCopyBuilder(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jst.j2ee.LibCopyBuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule() {
        Set projs = this.gatherDependentProjects(this.getComponent(), new HashSet());
        ISchedulingRule combinedRule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        for (IProject proj : projs) {
            ISchedulingRule rule = ruleFactory.createRule((IResource)proj);
            combinedRule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)combinedRule);
        }
        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.buildRule(), combinedRule);
        return combinedRule;
    }

    private Set gatherDependentProjects(IVirtualComponent comp, Set projs) {
        if (!projs.contains(comp.getProject())) {
            projs.add(comp.getProject());
            IVirtualReference[] refs = comp.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference refComp = refs[i];
                projs.addAll(this.gatherDependentProjects(refComp.getReferencedComponent(), projs));
                ++i;
            }
        }
        return projs;
    }

    protected void export() throws SaveFailureException, CoreException, InvocationTargetException, InterruptedException {
        if (this.module == null) {
            throw new SaveFailureException();
        }
        try {
            File dest = this.getDestinationPath().toFile();
            File parent = dest.getParentFile();
            if (dest.exists() && dest.isDirectory()) {
                throw new IOException(MessageFormat.format(Messages.J2EEModuleExportOperation_DestinationFileIsDirectoryError, dest.getAbsolutePath()));
            }
            if (parent != null) {
                parent.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(dest);
            ZipStreamModuleSaveAdapterImpl saver = new ZipStreamModuleSaveAdapterImpl(out);
            ModuleDelegate moduleDelegate = (ModuleDelegate)this.module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            this.addResources(saver, moduleDelegate.members());
            this.addChildren(saver, this.module, moduleDelegate.getChildModules());
            saver.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaveFailureException();
        }
    }

    protected void addChildren(ZipStreamModuleSaveAdapterImpl saver, IModule parent, IModule[] children) throws IOException, SaveFailureException, CoreException {
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                String path = this.getChildURI(parent, children[i]);
                ModuleDelegate childDelegate = (ModuleDelegate)children[i].loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
                IJ2EEModule tempMod = (IJ2EEModule)children[i].loadAdapter(IJ2EEModule.class, (IProgressMonitor)new NullProgressMonitor());
                boolean isBinary = tempMod.isBinary();
                if (path != null) {
                    if (isBinary) {
                        this.addResources(saver, childDelegate.members());
                    } else {
                        ZipStreamModuleSaveAdapterImpl childSaver = saver.createNestedSaveAdapter(path);
                        this.addResources(childSaver, childDelegate.members());
                        this.addChildren(childSaver, children[i], childDelegate.getChildModules());
                        childSaver.finish();
                    }
                }
                ++i;
            }
        }
    }

    protected void addResources(ZipStreamModuleSaveAdapterImpl saver, IModuleResource[] resources) throws SaveFailureException {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IModuleFile) {
                saver.save(resources[i]);
            } else if (resources[i] instanceof IModuleFolder) {
                this.addResources(saver, ((IModuleFolder)resources[i]).members());
            }
            ++i;
        }
    }

    public static class SaveFailureException
    extends Exception {
        public SaveFailureException() {
        }

        public SaveFailureException(Exception parent) {
            super(parent);
        }
    }

    public static class ZipStreamModuleSaveAdapterImpl {
        protected OutputStream destinationStream;
        protected ZipOutputStream zipOutputStream;

        public ZipStreamModuleSaveAdapterImpl(OutputStream out) {
            this.destinationStream = out;
            this.zipOutputStream = new ZipOutputStream(out);
        }

        public void close() throws IOException {
            this.getDestinationStream().close();
        }

        protected ZipStreamModuleSaveAdapterImpl createNestedSaveAdapter(String entry) throws IOException {
            ZipEntry nest = new ZipEntry(entry);
            this.getZipOutputStream().putNextEntry(nest);
            return new ZipStreamModuleSaveAdapterImpl(this.getZipOutputStream());
        }

        public void finish() throws IOException {
            this.getZipOutputStream().finish();
            if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
                this.getDestinationStream().close();
            }
        }

        public OutputStream getDestinationStream() {
            return this.destinationStream;
        }

        protected ZipOutputStream getZipOutputStream() {
            return this.zipOutputStream;
        }

        protected void save(IModuleResource resource) throws SaveFailureException {
            if (resource instanceof IModuleFile) {
                IFile ifile;
                File f = (File)((IModuleFile)resource).getAdapter(File.class);
                if (f == null && (ifile = (IFile)((IModuleFile)resource).getAdapter(IFile.class)) != null) {
                    f = ifile.getLocation().toFile();
                }
                this.saveFile(f, resource.getModuleRelativePath().append(resource.getName()));
            }
        }

        protected void saveFile(File f, IPath entryPath) throws SaveFailureException {
            try {
                ZipEntry entry = new ZipEntry(entryPath.toString());
                if (f.lastModified() > 0L) {
                    entry.setTime(f.lastModified());
                }
                this.getZipOutputStream().putNextEntry(entry);
                ArchiveUtil.copy((InputStream)new FileInputStream(f), (OutputStream)this.getZipOutputStream());
                this.getZipOutputStream().closeEntry();
            }
            catch (IOException e) {
                throw new SaveFailureException(e);
            }
        }
    }
}

