/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.wst.server.ui.xpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.UpdateServerJob;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;
import org.jboss.ide.eclipse.as.ui.Messages;

public class ServerContentProvider
extends BaseContentProvider
implements ITreeContentProvider {
    public static Object INITIALIZING = new Object();
    protected IServerLifecycleListener serverResourceListener;
    protected IPublishListener publishListener;
    protected IServerListener serverListener;
    protected static Set<String> publishing = new HashSet<String>(4);
    protected static Set<String> starting = new HashSet<String>(4);
    protected boolean animationActive = false;
    protected boolean stopAnimation = false;
    protected boolean initialized = false;
    private StructuredViewer viewer;

    public ServerContentProvider() {
        this.addListeners();
    }

    public Object[] getElements(Object element) {
        if (!this.initialized) {
            this.deferInitialization();
            return new Object[]{INITIALIZING};
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (!((Server)servers[i]).isPrivate()) {
                    list.add(servers[i]);
                }
                ++i;
            }
        }
        return list.toArray();
    }

    public Object[] getChildren(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            try {
                IModule[] children = ms.server.getChildModules(ms.module, null);
                int size = children.length;
                Object[] ms2 = new ModuleServer[size];
                int i = 0;
                while (i < size) {
                    int size2 = ms.module.length;
                    IModule[] module = new IModule[size2 + 1];
                    System.arraycopy(ms.module, 0, module, 0, size2);
                    module[size2] = children[i];
                    ms2[i] = new ModuleServer(ms.server, module);
                    ++i;
                }
                return ms2;
            }
            catch (Exception exception) {
                return new Object[0];
            }
        }
        if (element instanceof IServer) {
            IServer server = (IServer)element;
            IModule[] modules = server.getModules();
            int size = modules.length;
            Object[] ms = new ModuleServer[size];
            int i = 0;
            while (i < size) {
                ms[i] = new ModuleServer(server, new IModule[]{modules[i]});
                ++i;
            }
            return ms;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            return ms.server;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer curModuleServer = (ModuleServer)element;
            IServer curServer = curModuleServer.server;
            IModule[] curModule = curModuleServer.module;
            if (curServer != null && curModule != null) {
                IModule[] curChildModule = curServer.getChildModules(curModule, null);
                return curChildModule != null && curChildModule.length > 0;
            }
            return false;
        }
        if (element instanceof IServer) {
            return ((IServer)element).getModules().length > 0;
        }
        return false;
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)aViewer;
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            servers[i].removePublishListener(this.publishListener);
            servers[i].removeServerListener(this.serverListener);
            ++i;
        }
    }

    protected void addListeners() {
        this.serverResourceListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                ServerContentProvider.this.refreshServer(null);
                server.addServerListener(ServerContentProvider.this.serverListener);
                ((Server)server).addPublishListener(ServerContentProvider.this.publishListener);
            }

            public void serverChanged(IServer server) {
                ServerContentProvider.this.refreshServer(server);
            }

            public void serverRemoved(IServer server) {
                ServerContentProvider.this.refreshServer(null);
                server.removeServerListener(ServerContentProvider.this.serverListener);
                ((Server)server).removePublishListener(ServerContentProvider.this.publishListener);
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        this.publishListener = new PublishAdapter(){

            public void publishStarted(IServer server) {
                ServerContentProvider.this.handlePublishChange(server, true);
            }

            public void publishFinished(IServer server, IStatus status) {
                ServerContentProvider.this.handlePublishChange(server, false);
            }
        };
        this.serverListener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                if (event == null) {
                    return;
                }
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if ((eventKind & 0x10) != 0) {
                    if ((eventKind & 1) != 0) {
                        ServerContentProvider.this.refreshServer(server, true);
                        int state = event.getState();
                        String id = server.getId();
                        if (state == 1 || state == 3) {
                            boolean startThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (!starting.contains(id)) {
                                    if (starting.isEmpty()) {
                                        startThread = true;
                                    }
                                    starting.add(id);
                                }
                            }
                            if (startThread) {
                                ServerContentProvider.this.startThread();
                            }
                        } else {
                            boolean stopThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (starting.contains(id)) {
                                    starting.remove(id);
                                    if (starting.isEmpty()) {
                                        stopThread = true;
                                    }
                                }
                            }
                            if (stopThread) {
                                ServerContentProvider.this.stopThread();
                            }
                        }
                    } else {
                        ServerContentProvider.this.refreshServer(server);
                    }
                } else if ((eventKind & 0x20) != 0 && ((eventKind & 1) != 0 || (eventKind & 2) != 0)) {
                    ServerContentProvider.this.refreshServer(server);
                }
            }
        };
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].addServerListener(this.serverListener);
                ((Server)servers[i]).addPublishListener(this.publishListener);
                ++i;
            }
        }
    }

    protected void deferInitialization() {
        Job job = new Job(org.eclipse.wst.server.ui.internal.Messages.jobInitializingServersView){

            public IStatus run(IProgressMonitor monitor) {
                IServer[] servers = ServerCore.getServers();
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    ((Server)servers[i]).getAllModules().iterator();
                    ++i;
                }
                i = 0;
                while (i < size) {
                    IServer server = servers[i];
                    if (server.getServerType() != null && server.getServerState() == 0) {
                        UpdateServerJob job2 = new UpdateServerJob(server);
                        job2.schedule();
                    }
                    ++i;
                }
                ServerContentProvider.this.initialized = true;
                ServerContentProvider.this.refreshServer(null);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void updateServerLabel(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (ServerContentProvider.this.viewer != null && !ServerContentProvider.this.viewer.getControl().isDisposed()) {
                        ServerContentProvider.this.viewer.update((Object)server, null);
                    }
                }
                catch (Exception exception) {}
            }
        });
    }

    protected void refreshServer(IServer server) {
        this.refreshServer(server, false);
    }

    protected void refreshServer(final IServer server, final boolean resetSelection) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (ServerContentProvider.this.viewer != null && !ServerContentProvider.this.viewer.getControl().isDisposed()) {
                        ServerContentProvider.this.viewer.refresh((Object)server);
                        if (resetSelection) {
                            ISelection sel = ServerContentProvider.this.viewer.getSelection();
                            ServerContentProvider.this.viewer.setSelection(sel);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
    }

    protected void handlePublishChange(IServer server, boolean isPublishing) {
        String serverId = server.getId();
        if (isPublishing) {
            publishing.add(serverId);
        } else {
            publishing.remove(serverId);
        }
        this.refreshServer(server);
    }

    protected void startThread() {
        Runnable[] animator;
        if (this.animationActive) {
            return;
        }
        this.stopAnimation = false;
        final Display display = this.viewer == null ? Display.getDefault() : this.viewer.getControl().getDisplay();
        animator = new Runnable[]{new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!ServerContentProvider.this.stopAnimation) {
                    try {
                        String[] servers;
                        int size = 0;
                        Set<String> set = starting;
                        synchronized (set) {
                            size = starting.size();
                            servers = new String[size];
                            starting.toArray(servers);
                        }
                        int i = 0;
                        while (i < size) {
                            IServer server = ServerCore.findServer((String)servers[i]);
                            if (server != null) {
                                ServerContentProvider.this.updateServerLabel(server);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        Trace.trace((byte)4, (String)Messages.ServerContentProvider_ErrorInServersViewAnimation, (Throwable)e);
                    }
                    display.timerExec(200, animator[0]);
                }
            }
        }};
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                display.timerExec(200, animator[0]);
            }
        });
    }

    protected void stopThread() {
        this.stopAnimation = true;
    }
}

