/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.wst.server.ui.xpl;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.jboss.tools.as.wst.server.ui.xpl.ServerContentProvider;

public class ServerLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            if (ms.module == null) {
                return "";
            }
            int size = ms.module.length;
            String name = ms.module[size - 1].getName();
            return name;
        }
        if (element instanceof IServer) {
            IServer server = (IServer)element;
            return this.notNull(server.getName());
        }
        if (element == ServerContentProvider.INITIALIZING) {
            return Messages.viewInitializing;
        }
        return null;
    }

    public Image getImage(Object element) {
        IServer server;
        Image image = null;
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            ILabelProvider labelProvider = ServerUICore.getLabelProvider();
            image = labelProvider.getImage((Object)ms.module[ms.module.length - 1]);
            labelProvider.dispose();
        } else if (element instanceof IServer && (server = (IServer)element).getServerType() != null) {
            image = ImageResource.getImage((String)server.getServerType().getId());
        }
        return image;
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }
}

