/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.wst.server.ui.xpl;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;

public class ServersViewDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private List fElements;

    protected void doInit() {
    }

    public IStatus validatePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        this.initializeSelection((ISelection)aDragSelection);
        return this.internalValidate(aDropTarget, this.fElements);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            ISelection s = LocalSelectionTransfer.getInstance().getSelection();
            this.initializeSelection(s);
            return this.internalValidate(target, this.fElements);
        }
        return Status.CANCEL_STATUS;
    }

    protected void initializeSelection(ISelection s) {
        if (this.fElements != null) {
            return;
        }
        if (!(s instanceof IStructuredSelection)) {
            this.fElements = Collections.EMPTY_LIST;
            return;
        }
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected IStatus internalValidate(Object target, List elements) {
        if (target instanceof IServer) {
            IServer server = (IServer)target;
            if (elements != null) {
                for (Object next : elements) {
                    IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts(next);
                    if (moduleArtifacts == null || moduleArtifacts.length <= 0) continue;
                    int j = 0;
                    while (j < moduleArtifacts.length) {
                        IModuleType[] moduleTypes;
                        if (moduleArtifacts[j] != null && moduleArtifacts[j].getModule() != null && ServerUtil.isSupportedModule((IModuleType[])(moduleTypes = server.getServerType().getRuntimeType().getModuleTypes()), (IModuleType)moduleArtifacts[j].getModule().getModuleType())) {
                            return Status.OK_STATUS;
                        }
                        ++j;
                    }
                }
            }
        }
        this.clear();
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        IStatus ret = this.internalHandleDrop(target, this.fElements);
        if (ret.isOK()) {
            dropTargetEvent.detail = 0;
        }
        return ret;
    }

    public IStatus handlePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        return this.internalHandleDrop(aDropTarget, this.fElements);
    }

    protected IStatus internalHandleDrop(Object target, List elements) {
        boolean b = false;
        if (target instanceof IServer) {
            b = true;
            if (this.fElements != null) {
                for (Object data2 : elements) {
                    if (this.doSel((IServer)target, data2)) continue;
                    b = false;
                }
            }
        }
        this.clear();
        return b ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private void clear() {
        this.fElements = null;
    }

    protected boolean doSel(IServer server, Object data) {
        IModule[] modules;
        IProject project = (IProject)Platform.getAdapterManager().getAdapter(data, IProject.class);
        if (project != null && (modules = ServerUtil.getModules((IProject)project)) != null && modules.length == 1) {
            IModule[] parents;
            IServerWorkingCopy wc;
            block7: {
                block6: {
                    try {
                        wc = server.createWorkingCopy();
                        parents = wc.getRootModules(modules[0], null);
                        if (parents != null && parents.length != 0) break block6;
                        return false;
                    }
                    catch (CoreException ce) {
                        final Shell shell = Workbench.getInstance().getActiveWorkbenchWindow().getShell();
                        shell.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                EclipseUtil.openError((Shell)shell, (String)ce.getLocalizedMessage());
                            }
                        });
                        return true;
                    }
                }
                if (!ServerUtil.containsModule((IServer)server, (IModule)parents[0], null)) break block7;
                return false;
            }
            IModule[] add = new IModule[]{parents[0]};
            if (wc.canModifyModules(add, null, null).getSeverity() != 4) {
                wc.modifyModules(modules, null, null);
                wc.save(false, null);
                return true;
            }
        }
        final IServer finalServer = server;
        RunOnServerActionDelegate ros = new RunOnServerActionDelegate(){

            public IServer getServer(IModule module, IModuleArtifact moduleArtifact, IProgressMonitor monitor) throws CoreException {
                if (!ServerUIPlugin.isCompatibleWithLaunchMode((IServer)finalServer, (String)this.launchMode)) {
                    return null;
                }
                if (!ServerUtil.containsModule((IServer)finalServer, (IModule)module, (IProgressMonitor)monitor)) {
                    IServerWorkingCopy wc = finalServer.createWorkingCopy();
                    ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                    wc.save(false, monitor);
                }
                return finalServer;
            }
        };
        Action action = new Action(){};
        ros.selectionChanged((IAction)action, (ISelection)new StructuredSelection(data));
        ros.run((IAction)action);
        return true;
    }
}

