/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.util.NullModuleArtifact;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.ide.eclipse.as.wtp.ui.wizards.xpl.export.FullPublishToServerWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullPublishCommandHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
            IModule module = this.getModule(resource);
            IServer server = this.getServer(module, (IModuleArtifact)new NullModuleArtifact(module), (IProgressMonitor)new NullProgressMonitor());
            if (module != null && server != null) {
                IModule[] module2 = new IModule[]{module};
                ((Server)server).setModulePublishState(module2, 3);
                ArrayList allChildren = ServerModelUtilities.getDeepChildren((IServer)server, (IModule[])module2);
                int j = 0;
                while (j < allChildren.size()) {
                    ((Server)server).setModulePublishState((IModule[])allChildren.get(j), 3);
                    ++j;
                }
                new PublishServerJob(server, 1, true).schedule();
            }
            return null;
        }
        catch (CoreException ce) {
            throw new ExecutionException(ce.getMessage(), ce.getStatus().getException());
        }
    }

    public IServer getServer(IModule module) {
        IServer toRepublish = null;
        if (module != null) {
            IServer[] servers = ServerCore.getServers();
            ArrayList<IServer> matched = new ArrayList<IServer>();
            int i = 0;
            while (i < servers.length) {
                boolean found = false;
                IModule[] deployed = servers[i].getModules();
                int j = 0;
                while (j < deployed.length && !found) {
                    if (deployed[j].getId().equals(module.getId())) {
                        found = true;
                    }
                    ++j;
                }
                if (found) {
                    matched.add(servers[i]);
                }
                ++i;
            }
            toRepublish = matched.size() == 0 || matched.size() > 1 ? (IServer)matched.get(0) : (IServer)matched.get(0);
        }
        return toRepublish;
    }

    protected IModule getModule(IResource resource) {
        IModule module = null;
        ArrayList<IModule> possibleModules = new ArrayList<IModule>();
        if (resource != null) {
            IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)resource);
            if (moduleArtifacts != null && moduleArtifacts.length > 0) {
                int i = 0;
                while (i < moduleArtifacts.length) {
                    if (moduleArtifacts[i].getModule() != null && !possibleModules.contains(moduleArtifacts[i].getModule())) {
                        possibleModules.add(moduleArtifacts[i].getModule());
                    }
                    ++i;
                }
            }
            if (possibleModules.size() > 0) {
                module = this.promptForModule(possibleModules);
            }
        }
        return module;
    }

    protected IModule promptForModule(ArrayList<IModule> modules) {
        if (modules.size() == 1) {
            return modules.get(0);
        }
        return modules.get(0);
    }

    public IServer getServer(IModule module, IModuleArtifact moduleArtifact, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerCore.getDefaultServer((IModule)module);
        if (server != null && !ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)monitor)) {
            IServerWorkingCopy wc = server.createWorkingCopy();
            try {
                ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                wc.save(false, monitor);
            }
            catch (CoreException coreException) {
                server = null;
            }
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (server == null) {
            FullPublishToServerWizard wizard = new FullPublishToServerWizard(module, moduleArtifact);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() == 1) {
                if (monitor != null) {
                    monitor.setCanceled(true);
                }
                return null;
            }
            try {
                Job.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", null);
            }
            catch (Exception exception) {}
            server = wizard.getServer();
            boolean preferred = wizard.isPreferredServer();
            if (server != null && preferred) {
                try {
                    ServerCore.setDefaultServer((IModule)module, (IServer)server, (IProgressMonitor)monitor);
                }
                catch (CoreException ce) {
                    String message = "Could not save server preference information.";
                    ErrorDialog.openError((Shell)shell, (String)"Server Error", (String)message, (IStatus)ce.getStatus());
                }
            }
        }
        try {
            Job.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
        return server;
    }

    public boolean isEnabled() {
        IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
        IModule module = this.getModule(resource);
        return module != null;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

