/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.wtp.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.ui.WTPOveridePlugin;
import org.jboss.ide.eclipse.as.wtp.ui.propertypage.AddFolderDialog;
import org.jboss.ide.eclipse.as.wtp.ui.propertypage.ComponentDependencyContentProvider;
import org.jboss.ide.eclipse.as.wtp.ui.propertypage.DependencyPageExtensionManager;
import org.jboss.ide.eclipse.as.wtp.ui.propertypage.IModuleDependenciesControl;
import org.jboss.ide.eclipse.as.wtp.ui.propertypage.ModuleAssemblyRootPage;
import org.jboss.ide.eclipse.as.wtp.ui.propertypage.NewReferenceWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddModuleDependenciesPropertiesPage
implements Listener,
IModuleDependenciesControl,
ILabelProviderListener {
    private static final String DEPLOY_PATH_PROPERTY = new Integer(0).toString();
    private static final String SOURCE_PROPERTY = new Integer(1).toString();
    protected final String PATH_SEPARATOR = ComponentDependencyContentProvider.PATH_SEPARATOR;
    private boolean hasInitialized = false;
    protected final IProject project;
    protected final ModuleAssemblyRootPage propPage;
    protected IVirtualComponent rootComponent = null;
    protected Text componentNameText;
    protected Label availableModules;
    protected TableViewer availableComponentsViewer;
    protected Button addMappingButton;
    protected Button addReferenceButton;
    protected Button editReferenceButton;
    protected Button removeButton;
    protected Composite buttonColumn;
    protected static final IStatus OK_STATUS = IDataModelProvider.OK_STATUS;
    protected Listener tableListener;
    protected Listener labelListener;
    protected HashMap<IVirtualComponent, String> oldComponentToRuntimePath = new HashMap();
    protected HashMap<IVirtualComponent, String> objectToRuntimePath = new HashMap();
    protected ArrayList<IVirtualComponent> consumedReferences = new ArrayList();
    protected ArrayList<ComponentResourceProxy> resourceMappings = new ArrayList();
    protected boolean resourceMappingsChanged = false;

    public AddModuleDependenciesPropertiesPage(IProject project, ModuleAssemblyRootPage page) {
        this.project = project;
        this.propPage = page;
        this.rootComponent = ComponentCore.createComponent((IProject)project);
    }

    @Override
    public Composite createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ModuleAssemblyRootPage.createDescriptionComposite(composite, Messages.ModuleDependencyDescription);
        this.createListGroup(composite);
        this.refresh();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableModules = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableModules.setText("Module Assembly");
        this.availableModules.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.fillComposite(composite);
    }

    public void fillComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createTable(parent);
        this.createButtonColumn(parent);
    }

    protected void createButtonColumn(Composite parent) {
        this.buttonColumn = this.createButtonColumnComposite(parent);
        GridData data = new GridData(128);
        this.buttonColumn.setLayoutData((Object)data);
        this.createPushButtons();
    }

    protected void createPushButtons() {
        this.addMappingButton = this.createPushButton("Add Folder...");
        this.addReferenceButton = this.createPushButton("Add Reference...");
        this.editReferenceButton = this.createPushButton("Edit Reference...");
        this.removeButton = this.createPushButton("Remove selected");
    }

    protected Button createPushButton(String label) {
        Button aButton = new Button(this.buttonColumn, 8);
        aButton.setText(label);
        aButton.addListener(13, (Listener)this);
        aButton.setLayoutData((Object)new GridData(768));
        return aButton;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite aButtonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        aButtonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        aButtonColumn.setLayoutData((Object)data);
        return aButtonColumn;
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTable(Composite parent) {
        if (this.rootComponent != null) {
            this.availableComponentsViewer = this.createAvailableComponentsViewer(parent);
            GridData gd = new GridData(1296);
            this.availableComponentsViewer.getTable().setLayoutData((Object)gd);
            ComponentDependencyContentProvider provider = this.createProvider();
            provider.setRuntimePaths(this.objectToRuntimePath);
            provider.setResourceMappings(this.resourceMappings);
            this.availableComponentsViewer.setContentProvider((IContentProvider)provider);
            this.availableComponentsViewer.setLabelProvider((IBaseLabelProvider)provider);
            this.addTableListeners();
        }
    }

    protected ComponentDependencyContentProvider createProvider() {
        return new ComponentDependencyContentProvider(this);
    }

    protected void addTableListeners() {
        this.addHoverHelpListeners();
        this.addDoubleClickListener();
        this.addSelectionListener();
    }

    protected void addHoverHelpListeners() {
        Table table = this.availableComponentsViewer.getTable();
        this.createLabelListener(table);
        this.createTableListener(table);
        table.addListener(12, this.tableListener);
        table.addListener(1, this.tableListener);
        table.addListener(5, this.tableListener);
        table.addListener(32, this.tableListener);
    }

    protected void createLabelListener(final Table table) {
        this.labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        table.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
    }

    protected void createTableListener(final Table table) {
        this.tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null || item.getData() == null || AddModuleDependenciesPropertiesPage.this.canEditPath(item.getData())) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 540676);
                        this.tip.setBackground(Display.getDefault().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 64);
                        this.label.setForeground(Display.getDefault().getSystemColor(28));
                        this.label.setBackground(Display.getDefault().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(J2EEUIMessages.getResourceString((String)"HOVER_HELP_FOR_DISABLED_LIBS"));
                        this.label.addListener(7, AddModuleDependenciesPropertiesPage.this.labelListener);
                        this.label.addListener(3, AddModuleDependenciesPropertiesPage.this.labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = table.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y - size.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
    }

    protected boolean canEditPath(Object data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof VirtualArchiveComponent)) {
            return true;
        }
        VirtualArchiveComponent d2 = (VirtualArchiveComponent)data;
        boolean sameProject = d2.getWorkspaceRelativePath() != null && d2.getWorkspaceRelativePath().segment(0).equals(this.rootComponent.getProject().getName());
        return !sameProject || !this.isPhysicallyAdded(d2);
    }

    protected void addDoubleClickListener() {
        this.availableComponentsViewer.setColumnProperties(new String[]{DEPLOY_PATH_PROPERTY, SOURCE_PROPERTY});
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.availableComponentsViewer.getTable()), new TextCellEditor()};
        this.availableComponentsViewer.setCellEditors(editors);
        this.availableComponentsViewer.setCellModifier((ICellModifier)new RuntimePathCellModifier());
    }

    protected void addSelectionListener() {
        this.availableComponentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddModuleDependenciesPropertiesPage.this.viewerSelectionChanged();
            }
        });
    }

    protected void viewerSelectionChanged() {
        this.editReferenceButton.setEnabled(this.hasEditWizardPage(this.getSelectedObject()));
        this.removeButton.setEnabled(this.getSelectedObject() != null && this.canEditPath(this.getSelectedObject()));
    }

    protected boolean hasEditWizardPage(Object o) {
        if (o == null || !(o instanceof IVirtualComponent)) {
            return false;
        }
        WizardFragment wf = NewReferenceWizard.getFirstEditingFragment((IVirtualComponent)o);
        return wf != null;
    }

    protected Object getSelectedObject() {
        IStructuredSelection sel = (IStructuredSelection)this.availableComponentsViewer.getSelection();
        return sel.getFirstElement();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addMappingButton) {
            this.handleAddMappingButton();
        } else if (event.widget == this.addReferenceButton) {
            this.handleAddReferenceButton();
        } else if (event.widget == this.editReferenceButton) {
            this.handleEditReferenceButton();
        } else if (event.widget == this.removeButton) {
            this.handleRemoveSelectedButton();
        }
    }

    protected void handleAddMappingButton() {
        IContainer c;
        AddFolderDialog afd = new AddFolderDialog(this.addMappingButton.getShell(), this.project);
        if (afd.open() == 0 && (c = afd.getSelected()) != null) {
            IPath p = c.getProjectRelativePath();
            ComponentResourceProxy proxy = new ComponentResourceProxy(p, (IPath)new Path("/"));
            this.resourceMappings.add(proxy);
            this.refresh();
        }
    }

    protected void handleAddReferenceButton() {
        this.showReferenceWizard(false);
    }

    protected void handleEditReferenceButton() {
        this.showReferenceWizard(true);
    }

    protected DependencyPageExtensionManager.ReferenceExtension[] getReferenceExtensions() {
        return DependencyPageExtensionManager.getManager().getReferenceExtensions();
    }

    protected void showReferenceWizard(boolean editing) {
        WizardDialog wd;
        Object o;
        NewReferenceWizard wizard = new NewReferenceWizard(this.getReferenceExtensions());
        wizard.getTaskModel().putObject("root.project", (Object)this.project);
        wizard.getTaskModel().putObject("root.component", (Object)this.rootComponent);
        IVirtualComponent selected = null;
        if (editing && (o = ((IStructuredSelection)this.availableComponentsViewer.getSelection()).getFirstElement()) instanceof IVirtualComponent) {
            selected = (IVirtualComponent)o;
            wizard.getTaskModel().putObject("dependency.component", (Object)selected);
            wizard.getTaskModel().putObject("dependency.component.path", (Object)this.objectToRuntimePath.get(selected));
        }
        if ((wd = new WizardDialog(this.addReferenceButton.getShell(), (IWizard)wizard)).open() != 1) {
            String[] stringArray;
            IVirtualComponent[] compArr;
            IVirtualComponent[] iVirtualComponentArray;
            boolean consumed;
            if (editing && selected != null) {
                this.objectToRuntimePath.remove(selected);
                this.consumedReferences.remove(selected);
            }
            Object c1 = wizard.getTaskModel().getObject("dependency.component");
            Object p1 = wizard.getTaskModel().getObject("dependency.component.path");
            DependencyType type = (DependencyType)wizard.getTaskModel().getObject("dependency.type");
            boolean bl = consumed = type == null ? false : type.equals(DependencyType.CONSUMES_LITERAL);
            if (c1 instanceof IVirtualComponent) {
                IVirtualComponent[] iVirtualComponentArray2 = new IVirtualComponent[1];
                iVirtualComponentArray = iVirtualComponentArray2;
                iVirtualComponentArray2[0] = (IVirtualComponent)c1;
            } else {
                iVirtualComponentArray = compArr = (IVirtualComponent[])c1;
            }
            if (p1 instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)p1;
            } else {
                stringArray = (String[])p1;
            }
            String[] pathArr = stringArray;
            int i = 0;
            while (i < compArr.length) {
                this.objectToRuntimePath.put(compArr[i], pathArr[i]);
                if (consumed) {
                    this.consumedReferences.add(compArr[i]);
                }
                ++i;
            }
            this.refresh();
        }
    }

    protected void handleRemoveSelectedButton() {
        ISelection sel = this.availableComponentsViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)sel).getFirstElement();
            if (o instanceof IVirtualComponent) {
                this.objectToRuntimePath.remove(o);
            } else if (o instanceof ComponentResourceProxy) {
                this.resourceMappings.remove(o);
            }
            this.refresh();
        }
    }

    public TableViewer createAvailableComponentsViewer(Composite parent) {
        int flags = 67586;
        Table table = new Table(parent, flags);
        this.availableComponentsViewer = new TableViewer(table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(400, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(500, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.availableComponentsViewer.setSorter(null);
        TableColumn bndColumn = new TableColumn(table, 0, 0);
        bndColumn.setText(Messages.AddModuleDependenciesPropertiesPage_DeployPathColumn);
        bndColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(Messages.AddModuleDependenciesPropertiesPage_SourceColumn);
        projectColumn.setResizable(true);
        tableLayout.layout((Composite)table, true);
        return this.availableComponentsViewer;
    }

    protected boolean isPhysicallyAdded(VirtualArchiveComponent component) {
        try {
            component.getProjectRelativePath();
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void refresh() {
        this.resetTableUI();
        if (!this.hasInitialized) {
            this.initialize();
            this.resetTableUI();
        }
    }

    protected void resetTableUI() {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.availableComponentsViewer.setInput((Object)input);
        GridData data = new GridData(1808);
        int numlines = Math.min(10, this.availableComponentsViewer.getTable().getItemCount());
        data.heightHint = this.availableComponentsViewer.getTable().getItemHeight() * numlines;
        this.availableComponentsViewer.getTable().setLayoutData((Object)data);
        GridData btndata = new GridData(258);
        this.buttonColumn.setLayoutData((Object)btndata);
    }

    protected IVirtualReference[] getHardReferencesFromComponent(IVirtualComponent component) {
        return component.getReferences();
    }

    protected void initialize() {
        IVirtualReference[] refs = this.getHardReferencesFromComponent(this.rootComponent);
        int i = 0;
        while (i < refs.length) {
            IVirtualComponent comp = refs[i].getReferencedComponent();
            IPath val = refs[i].getRuntimePath();
            if (refs[i].getDependencyType() != 1 && refs[i].getArchiveName() != null) {
                val = val.append(refs[i].getArchiveName());
            }
            this.objectToRuntimePath.put(comp, val.toString());
            this.oldComponentToRuntimePath.put(comp, val.toString());
            if (refs[i].getDependencyType() == 1) {
                this.consumedReferences.add(comp);
            }
            ++i;
        }
        ComponentResource[] allMappings = this.findAllMappings();
        int i2 = 0;
        while (i2 < allMappings.length) {
            this.resourceMappings.add(new ComponentResourceProxy(allMappings[i2].getSourcePath(), allMappings[i2].getRuntimePath()));
            ++i2;
        }
        this.removeButton.setEnabled(false);
        this.editReferenceButton.setEnabled(false);
        this.hasInitialized = true;
    }

    protected ComponentResource[] findAllMappings() {
        StructureEdit structureEdit = null;
        try {
            structureEdit = StructureEdit.getStructureEditForRead((IProject)this.project);
            WorkbenchComponent component = structureEdit.getComponent();
            Object[] arr = component.getResources().toArray();
            ComponentResource[] result = new ComponentResource[arr.length];
            int i = 0;
            while (i < arr.length) {
                result[i] = (ComponentResource)arr[i];
                ++i;
            }
            ComponentResource[] componentResourceArray = result;
            return componentResourceArray;
        }
        catch (Exception exception) {
        }
        finally {
            structureEdit.dispose();
        }
        return new ComponentResource[0];
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public void performDefaults() {
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void dispose() {
        Table table = null;
        if (this.availableComponentsViewer != null) {
            table = this.availableComponentsViewer.getTable();
        }
        if (table == null || this.tableListener == null) {
            return;
        }
        table.removeListener(12, this.tableListener);
        table.removeListener(1, this.tableListener);
        table.removeListener(5, this.tableListener);
        table.removeListener(32, this.tableListener);
    }

    protected boolean preHandleChanges(IProgressMonitor monitor) {
        return true;
    }

    protected boolean postHandleChanges(IProgressMonitor monitor) {
        return true;
    }

    @Override
    public boolean performOk() {
        boolean result = true;
        result &= this.saveResourceChanges();
        return result &= this.saveReferenceChanges();
    }

    protected boolean saveResourceChanges() {
        this.removeAllResourceMappings();
        this.addNewResourceMappings();
        return true;
    }

    protected boolean addNewResourceMappings() {
        ComponentResourceProxy[] proxies = this.resourceMappings.toArray(new ComponentResourceProxy[this.resourceMappings.size()]);
        IVirtualFolder rootFolder = this.rootComponent.getRootFolder();
        int i = 0;
        while (i < proxies.length) {
            try {
                rootFolder.getFolder(proxies[i].runtimePath).createLink(proxies[i].source, 0, null);
            }
            catch (CoreException coreException) {}
            ++i;
        }
        this.resourceMappingsChanged = false;
        return true;
    }

    protected boolean removeAllResourceMappings() {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.project);
            moduleCore.getComponent().getResources().clear();
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                moduleCore.dispose();
            }
        }
        return true;
    }

    protected boolean saveReferenceChanges() {
        ArrayList<IVirtualComponent> added = new ArrayList<IVirtualComponent>();
        ArrayList<IVirtualComponent> removed = new ArrayList<IVirtualComponent>();
        ArrayList<IVirtualComponent> changed = new ArrayList<IVirtualComponent>();
        for (IVirtualComponent key : this.oldComponentToRuntimePath.keySet()) {
            String val = this.oldComponentToRuntimePath.get(key);
            if (!this.objectToRuntimePath.containsKey(key)) {
                removed.add(key);
                continue;
            }
            if (val.equals(this.objectToRuntimePath.get(key))) continue;
            changed.add(key);
        }
        for (IVirtualComponent key : this.objectToRuntimePath.keySet()) {
            if (this.oldComponentToRuntimePath.containsKey(key)) continue;
            added.add(key);
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        boolean subResult = this.preHandleChanges((IProgressMonitor)monitor);
        if (!subResult) {
            return false;
        }
        this.handleDeltas(removed, changed, added);
        subResult &= this.postHandleChanges((IProgressMonitor)monitor);
        this.oldComponentToRuntimePath.clear();
        ArrayList<IVirtualComponent> keys = new ArrayList<IVirtualComponent>();
        keys.addAll(this.objectToRuntimePath.keySet());
        for (IVirtualComponent vc : keys) {
            String path = this.objectToRuntimePath.get(vc);
            this.oldComponentToRuntimePath.put(vc, path);
        }
        return subResult;
    }

    protected void handleDeltas(ArrayList<IVirtualComponent> removed, ArrayList<IVirtualComponent> changed, ArrayList<IVirtualComponent> added) {
        ArrayList<IVirtualComponent> removed2 = new ArrayList<IVirtualComponent>();
        ArrayList<IVirtualComponent> added2 = new ArrayList<IVirtualComponent>();
        removed2.addAll(removed);
        removed2.addAll(changed);
        added2.addAll(added);
        added2.addAll(changed);
        this.handleRemoved(removed2);
        this.handleAdded(added2);
    }

    protected void handleRemoved(ArrayList<IVirtualComponent> removed) {
        Iterator<IVirtualComponent> i = removed.iterator();
        while (i.hasNext()) {
            try {
                IVirtualComponent component = i.next();
                IDataModelOperation operation = this.getRemoveComponentOperation(component);
                operation.execute(null, null);
            }
            catch (ExecutionException e) {
                WTPOveridePlugin.logError(e);
            }
        }
    }

    protected IDataModelOperation getRemoveComponentOperation(IVirtualComponent component) {
        String archiveName = null;
        String path = null;
        if (!this.consumedReferences.contains(component)) {
            path = new Path(this.oldComponentToRuntimePath.get(component)).removeLastSegments(1).toString();
            archiveName = new Path(this.oldComponentToRuntimePath.get(component)).lastSegment();
        } else {
            path = this.oldComponentToRuntimePath.get(component);
        }
        IDataModelProvider provider = this.getRemoveReferenceDataModelProvider(component);
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)provider);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.rootComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.add(component);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)path);
        HashMap<IVirtualComponent, String> uriMap = new HashMap<IVirtualComponent, String>();
        uriMap.put(component, archiveName);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", uriMap);
        return model.getDefaultOperation();
    }

    protected IDataModelProvider getRemoveReferenceDataModelProvider(IVirtualComponent component) {
        return new RemoveReferenceComponentsDataModelProvider();
    }

    protected void handleChanged(ArrayList<IVirtualComponent> changed) {
        for (IVirtualComponent component : changed) {
            IVirtualReference ref = this.rootComponent.getReference(component.getName());
            Path p = new Path(this.objectToRuntimePath.get(component));
            ref.setRuntimePath((IPath)p);
        }
    }

    protected void handleAdded(ArrayList<IVirtualComponent> added) {
        final ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        for (IVirtualComponent o : added) {
            components.add(o);
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AddModuleDependenciesPropertiesPage.this.addComponents(components);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            WTPOveridePlugin.logError(e);
        }
    }

    protected void addComponents(ArrayList<IVirtualComponent> components) throws CoreException {
        Iterator<IVirtualComponent> i = components.iterator();
        while (i.hasNext()) {
            this.addOneComponent(i.next());
        }
    }

    protected IDataModelProvider getAddReferenceDataModelProvider(IVirtualComponent component) {
        return new CreateReferenceComponentsDataModelProvider();
    }

    protected void addOneComponent(IVirtualComponent component) throws CoreException {
        String archiveName = null;
        String path = null;
        if (!this.consumedReferences.contains(component)) {
            path = new Path(this.objectToRuntimePath.get(component)).removeLastSegments(1).toString();
            archiveName = new Path(this.objectToRuntimePath.get(component)).lastSegment();
        } else {
            path = this.objectToRuntimePath.get(component);
        }
        IDataModelProvider provider = this.getAddReferenceDataModelProvider(component);
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.rootComponent);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", Arrays.asList(component));
        if (archiveName != null) {
            HashMap<IVirtualComponent, String> uriMap = new HashMap<IVirtualComponent, String>();
            uriMap.put(component, archiveName);
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", uriMap);
        }
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)path);
        IStatus stat = dm.validateProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        if (stat != OK_STATUS) {
            throw new CoreException(stat);
        }
        try {
            dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            WTPOveridePlugin.logError(e);
        }
    }

    protected String getVirtualComponentNameWithExtension(IVirtualComponent virtComp) {
        String virtCompURIMapName = this.getURIMappingName(virtComp);
        String extension = ".jar";
        virtCompURIMapName = String.valueOf(virtCompURIMapName) + extension;
        return virtCompURIMapName;
    }

    private String getURIMappingName(IVirtualComponent archive) {
        IPath componentPath = Path.fromOSString((String)archive.getName());
        String uriMapName = componentPath.lastSegment().replace(' ', '_');
        IVirtualReference[] existingRefs = this.rootComponent.getReferences();
        int i = 0;
        while (i < existingRefs.length) {
            existingRefs[i].getReferencedComponent().getName();
            if (existingRefs[i].getArchiveName().equals(uriMapName)) {
                boolean dupeArchiveName = true;
                int j = 1;
                while (dupeArchiveName) {
                    int lastDotIndex = uriMapName.lastIndexOf(46);
                    String increment = "_" + j;
                    uriMapName = lastDotIndex != -1 ? String.valueOf(uriMapName.substring(0, lastDotIndex)) + increment + uriMapName.substring(lastDotIndex) : String.valueOf(uriMapName.substring(0)) + increment;
                    int k = 0;
                    while (k < existingRefs.length) {
                        dupeArchiveName = existingRefs[k].getArchiveName().equals(uriMapName);
                        if (dupeArchiveName) break;
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return uriMapName;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        if (!this.availableComponentsViewer.getTable().isDisposed()) {
            this.availableComponentsViewer.refresh(true);
        }
    }

    public class ComponentResourceProxy {
        public IPath source;
        public IPath runtimePath;

        public ComponentResourceProxy(IPath source, IPath runtimePath) {
            this.source = source;
            this.runtimePath = runtimePath;
        }
    }

    private class RuntimePathCellModifier
    implements ICellModifier {
        private RuntimePathCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property.equals(DEPLOY_PATH_PROPERTY)) {
                if (element instanceof VirtualArchiveComponent) {
                    try {
                        return AddModuleDependenciesPropertiesPage.this.canEditPath(element);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                return true;
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            Object data = element;
            if (data instanceof IVirtualComponent) {
                return AddModuleDependenciesPropertiesPage.this.objectToRuntimePath.get(element) == null ? new Path("/").toString() : AddModuleDependenciesPropertiesPage.this.objectToRuntimePath.get(element);
            }
            if (data instanceof ComponentResourceProxy) {
                return ((ComponentResourceProxy)data).runtimePath.toString();
            }
            return new Path("/");
        }

        public void modify(Object element, String property, Object value) {
            if (property.equals(DEPLOY_PATH_PROPERTY)) {
                TableItem item = (TableItem)element;
                if (item.getData() instanceof IVirtualComponent) {
                    AddModuleDependenciesPropertiesPage.this.objectToRuntimePath.put((IVirtualComponent)item.getData(), (String)value);
                } else if (item.getData() instanceof ComponentResourceProxy) {
                    ComponentResourceProxy c = (ComponentResourceProxy)item.getData();
                    c.runtimePath = new Path((String)value);
                    AddModuleDependenciesPropertiesPage.this.resourceMappingsChanged = true;
                }
                AddModuleDependenciesPropertiesPage.this.refresh();
            }
        }
    }
}

