/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.classpathdep.UpdateClasspathAttributesDataModelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.wtp.core.vcf.ExportedClasspathFoldersVirtualComponent;
import org.jboss.ide.eclipse.as.wtp.ui.propertypage.IReferenceEditor;

public class ExportedClasspathFoldersReferenceWizardFragment
extends WizardFragment
implements IReferenceEditor {
    protected TreeViewer viewer;
    protected IPath[] paths;
    protected IWizardHandle handle;
    protected IStructuredSelection selected = null;
    protected IStructuredSelection initialSelection = null;
    protected Object[] allElements;

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        handle.setTitle("Add exported folders from the build pathx");
        handle.setDescription("This reference will allow you to add references to exported classpaths from this project's build page. Please select all entries you wish to be published.");
        IVirtualComponent parentComp = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        IProject project = parentComp.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.allElements = this.findAllClassFolderEntries(javaProject);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FormLayout());
        this.viewer = new TreeViewer(c, 2050);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -5);
        this.viewer.getTree().setLayoutData((Object)fd);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportedClasspathFoldersReferenceWizardFragment.this.selected = (IStructuredSelection)ExportedClasspathFoldersReferenceWizardFragment.this.viewer.getSelection();
            }
        });
        ArrayList<IClasspathEntry> withTag = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < this.allElements.length) {
            IClasspathAttribute attribute = ClasspathDependencyUtil.checkForComponentDependencyAttribute((IClasspathEntry)((IClasspathEntry)this.allElements[i]), (IClasspathDependencyConstants.DependencyAttributeType)IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY);
            if (attribute != null) {
                withTag.add((IClasspathEntry)this.allElements[i]);
            }
            ++i;
        }
        StructuredSelection newSel = new StructuredSelection(withTag);
        this.viewer.setSelection((ISelection)newSel);
        this.initialSelection = newSel;
        return c;
    }

    protected IClasspathEntry[] findAllClassFolderEntries(IJavaProject javaProject) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                if (ClasspathDependencyUtil.isClassFolderEntry((IClasspathEntry)entries[i])) {
                    list.add(entries[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    private ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                IVirtualComponent parentComp = (IVirtualComponent)ExportedClasspathFoldersReferenceWizardFragment.this.getTaskModel().getObject("root.component");
                IProject project = parentComp.getProject();
                IJavaProject jp = JavaCore.create((IProject)project);
                if (jp != null) {
                    return ExportedClasspathFoldersReferenceWizardFragment.this.findAllClassFolderEntries(jp);
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        };
    }

    private LabelProvider getLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }

            public String getText(Object element) {
                return element instanceof IProject ? ((IProject)element).getName() : element.toString();
            }
        };
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent parentComp = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        try {
            HashMap<IClasspathEntry, IPath> toAdd = new HashMap<IClasspathEntry, IPath>();
            HashMap<IClasspathEntry, IPath> toRemove = new HashMap<IClasspathEntry, IPath>();
            List<Object> pre = Arrays.asList(this.initialSelection.toArray());
            List<Object> post = Arrays.asList(this.selected.toArray());
            int i = 0;
            while (i < this.allElements.length) {
                if (pre.contains(this.allElements[i]) && !post.contains(this.allElements[i])) {
                    toRemove.put((IClasspathEntry)this.allElements[i], this.getOriginalPath((IClasspathEntry)this.allElements[i]));
                } else if (!pre.contains(this.allElements[i]) && post.contains(this.allElements[i])) {
                    toAdd.put((IClasspathEntry)this.allElements[i], this.getNewPath((IClasspathEntry)this.allElements[i]));
                }
                ++i;
            }
            UpdateClasspathAttributesDataModelProvider provider = new UpdateClasspathAttributesDataModelProvider();
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)provider);
            model.setProperty("UpdateClasspathAttributesDataModel.PROJECT_NAME", (Object)parentComp.getProject().getName());
            model.setProperty("UpdateClasspathAttributesDataModel.ENTRIES_TO_ADD_ATTRIBUTE", toAdd);
            model.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            provider = new UpdateClasspathAttributesDataModelProvider();
            model = DataModelFactory.createDataModel((IDataModelProvider)provider);
            model.setProperty("UpdateClasspathAttributesDataModel.PROJECT_NAME", (Object)parentComp.getProject().getName());
            model.setProperty("UpdateClasspathAttributesDataModel.ENTRIES_TO_REMOVE_ATTRIBUTE", toRemove);
            model.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {}
        ExportedClasspathFoldersVirtualComponent vc = new ExportedClasspathFoldersVirtualComponent(parentComp.getProject(), parentComp);
        this.getTaskModel().putObject("dependency.component", (Object)vc);
        this.getTaskModel().putObject("dependency.component.path", (Object)"/");
        this.getTaskModel().putObject("dependency.type", (Object)DependencyType.CONSUMES_LITERAL);
    }

    protected IPath getOriginalPath(IClasspathEntry entry) {
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            IClasspathAttribute attribute = attributes[i];
            String name = attribute.getName();
            if (name.equals("org.eclipse.jst.component.dependency")) {
                return new Path(attribute.getValue());
            }
            ++i;
        }
        return new Path("/");
    }

    protected IPath getNewPath(IClasspathEntry cpe) {
        return new Path("/");
    }

    public boolean canEdit(IVirtualComponent vc) {
        return vc instanceof ExportedClasspathFoldersVirtualComponent;
    }
}

