/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.propertypage;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class JarReferenceWizardFragment
extends WizardFragment {
    protected LabelProvider labelProvider = null;
    protected ITreeContentProvider contentProvider = null;
    protected TreeViewer viewer;
    protected Button browse;
    protected IPath[] paths;
    protected IWizardHandle handle;
    protected IPath[] selected = new IPath[0];

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        handle.setTitle("Add a Jar Reference");
        handle.setDescription("Here you can reference a workspace Jar\nThis is not a suggested use-case, but is here for backwards compatability.");
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FormLayout());
        this.viewer = new TreeViewer(c, 2052);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.browse = new Button(c, 0);
        this.browse.setText("Browse...");
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.bottom = new FormAttachment(100, -5);
        this.browse.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)this.browse, -5);
        this.viewer.getTree().setLayoutData((Object)fd);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JarReferenceWizardFragment.this.buttonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return c;
    }

    protected void buttonPressed() {
        IProject project = (IProject)this.getTaskModel().getObject("root.project");
        this.selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.browse.getShell(), (IPath)project.getLocation(), (IPath[])new IPath[0]);
        this.viewer.refresh();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent rootComponent = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        if (this.selected != null && this.selected.length > 0) {
            ArrayList<IVirtualComponent> compList = new ArrayList<IVirtualComponent>();
            ArrayList<String> paths = new ArrayList<String>();
            int i = 0;
            while (i < this.selected.length) {
                String type = "lib/";
                IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)rootComponent.getProject(), (String)(String.valueOf(type) + this.selected[i].makeRelative().toString()));
                compList.add(archive);
                paths.add(this.selected[i].lastSegment());
                ++i;
            }
            IVirtualComponent[] components = compList.toArray(new IVirtualComponent[compList.size()]);
            String[] paths2 = paths.toArray(new String[paths.size()]);
            this.getTaskModel().putObject("dependency.component", (Object)components);
            this.getTaskModel().putObject("dependency.component.path", (Object)paths2);
        }
    }

    protected LabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element == null ? "" : element.toString();
                }
            };
        }
        return this.labelProvider;
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return JarReferenceWizardFragment.this.selected == null ? new Object[]{} : JarReferenceWizardFragment.this.selected;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }
            };
        }
        return this.contentProvider;
    }
}

