/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class ProjectReferenceWizardFragment
extends WizardFragment {
    private LabelProvider labelProvider = null;
    private ITreeContentProvider contentProvider = null;
    private TreeViewer viewer;
    private IProject selected;

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        handle.setTitle("Add a Project Reference");
        handle.setDescription("Here you can make a project into a reference.\nIf the project is not already a flexible project, it will be converted into one.");
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(c, 2052);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectReferenceWizardFragment.this.selChanged();
            }
        });
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        return c;
    }

    private void selChanged() {
        IStructuredSelection sel;
        if (this.viewer != null && (sel = (IStructuredSelection)this.viewer.getSelection()) != null) {
            this.selected = (IProject)sel.getFirstElement();
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (!ModuleCoreNature.isFlexibleProject((IProject)this.selected)) {
            try {
                IDataModel migrationdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
                migrationdm.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)this.selected.getName());
                migrationdm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {}
        }
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.selected);
        String path = this.selected.getName();
        String extension = ".jar";
        path = String.valueOf(path) + extension;
        this.getTaskModel().putObject("dependency.component", (Object)comp);
        this.getTaskModel().putObject("dependency.component.path", (Object)path);
    }

    protected LabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }

                public String getText(Object element) {
                    if (element instanceof IProject) {
                        return ((IProject)element).getName();
                    }
                    return element == null ? "" : element.toString();
                }
            };
        }
        return this.labelProvider;
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    IProject root = (IProject)ProjectReferenceWizardFragment.this.getTaskModel().getObject("root.project");
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    ArrayList<IProject> list = new ArrayList<IProject>(Arrays.asList(projects));
                    Iterator<IProject> i = list.iterator();
                    while (i.hasNext()) {
                        IProject p = i.next();
                        if (!p.isOpen()) {
                            i.remove();
                            continue;
                        }
                        if (!p.equals((Object)root)) continue;
                        i.remove();
                    }
                    return list.toArray(new IProject[list.size()]);
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }
            };
        }
        return this.contentProvider;
    }
}

