/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans.editors;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.correction.IQuickAssistProcessor;
import org.eclipse.wst.sse.ui.internal.correction.IQuickFixProcessor;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.correction.CorrectionAssistantProviderXML;
import org.eclipse.wst.xml.ui.internal.correction.CorrectionProcessorXML;
import org.eclipse.wst.xml.ui.internal.correction.QuickAssistProcessorXML;
import org.eclipse.wst.xml.ui.internal.correction.QuickFixProcessorXML;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.jboss.ide.eclipse.as.ui.mbeans.Messages;
import org.jboss.ide.eclipse.as.ui.mbeans.editors.proposals.IServiceXMLQuickFixProposalProvider;
import org.jboss.ide.eclipse.as.ui.util.ServiceXMLEditorUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceXMLCorrectionAssistantProvider
extends CorrectionAssistantProviderXML {
    public static IServiceXMLQuickFixProposalProvider[] providers;

    public static IServiceXMLQuickFixProposalProvider[] getProviders() {
        if (providers == null) {
            ArrayList<IServiceXMLQuickFixProposalProvider> list = new ArrayList<IServiceXMLQuickFixProposalProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.ui.mbeans", "ServiceXMLQuickFixProvider");
            int i = 0;
            while (i < cf.length) {
                try {
                    list.add((IServiceXMLQuickFixProposalProvider)cf[i].createExecutableExtension("class"));
                }
                catch (CoreException coreException) {}
                ++i;
            }
            providers = list.toArray(new IServiceXMLQuickFixProposalProvider[list.size()]);
        }
        return providers;
    }

    public IContentAssistant getCorrectionAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = null;
        if (sourceViewer != null) {
            ContentAssistant assistant = new ContentAssistant();
            if (sourceViewer != null) {
                CorrectionProcessorServiceXML correctionProcessor = new CorrectionProcessorServiceXML(sourceViewer);
                assistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_DEFAULT");
                assistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_CDATA");
                assistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_COMMENT");
                assistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_DECL");
                assistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_PI");
                assistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.dtd.internal_subset");
            }
            ca = assistant;
        }
        return ca;
    }

    public static class CorrectionProcessorServiceXML
    extends CorrectionProcessorXML {
        protected IQuickAssistProcessor fQuickAssistProcessor;
        protected IQuickFixProcessor fQuickFixProcessor;

        public CorrectionProcessorServiceXML(ISourceViewer sourceViewer) {
            super(sourceViewer);
        }

        protected IQuickAssistProcessor getQuickAssistProcessor() {
            if (this.fQuickAssistProcessor == null) {
                this.fQuickAssistProcessor = new QuickAssistProcessorServiceXML();
            }
            return this.fQuickAssistProcessor;
        }

        protected IQuickFixProcessor getQuickFixProcessor() {
            if (this.fQuickFixProcessor == null) {
                this.fQuickFixProcessor = new QuickFixProcessorXML();
            }
            return this.fQuickFixProcessor;
        }
    }

    public static class QuickAssistProcessorServiceXML
    extends QuickAssistProcessorXML {
        public boolean canAssist(StructuredTextViewer viewer, int offset) {
            if (super.canAssist(viewer, offset)) {
                return true;
            }
            IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
            return this.mbeanHasAdditionalAttributes(node);
        }

        private boolean mbeanHasAdditionalAttributes(IDOMNode node) {
            int length = this.mbeanGetMissingAttributes(node).length;
            return length != 0;
        }

        private String[] mbeanGetMissingAttributes(IDOMNode node) {
            Node parentNode = node.getParentNode();
            if (node.getNodeName().equals("mbean") || node.getNodeName().equals("#text") && parentNode.getNodeName().equals("mbean")) {
                Object mbeanNode = node.getNodeName().equals("mbean") ? node : parentNode;
                NamedNodeMap attributes = mbeanNode.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    String codeClass;
                    IType type;
                    if (attributes.item(i).getNodeName().equals("code") && (type = ServiceXMLEditorUtil.findType(codeClass = attributes.item(i).getNodeValue())) != null) {
                        IMethod[] methods = ServiceXMLEditorUtil.getAllMethods(type);
                        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(ServiceXMLEditorUtil.findAttributesFromMethods(methods, "")));
                        NodeList mbeanChildren = mbeanNode.getChildNodes();
                        int j = 0;
                        while (j < mbeanChildren.getLength()) {
                            if (mbeanChildren.item(j).getNodeName().equals("attribute")) {
                                try {
                                    Node t = mbeanChildren.item(j).getAttributes().getNamedItem("name");
                                    String attName = t.getNodeValue();
                                    attributeNames.remove(attName);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            ++j;
                        }
                        return attributeNames.toArray(new String[attributeNames.size()]);
                    }
                    ++i;
                }
            }
            return new String[0];
        }

        public ICompletionProposal[] getProposals(StructuredTextViewer viewer, int offset) throws CoreException {
            ArrayList<ICompletionProposal> props = new ArrayList<ICompletionProposal>();
            if (super.canAssist(viewer, offset)) {
                props.addAll(Arrays.asList(super.getProposals(viewer, offset)));
            }
            IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
            this.addMissingAttributesProposal(node, props);
            this.addXPathProposals(viewer, offset, props);
            return props.toArray(new ICompletionProposal[props.size()]);
        }

        protected void addXPathProposals(StructuredTextViewer viewer, int offset, ArrayList proposals) {
            IServiceXMLQuickFixProposalProvider[] providers = ServiceXMLCorrectionAssistantProvider.getProviders();
            int i = 0;
            while (i < providers.length) {
                ICompletionProposal[] props = providers[i].getProposals((ITextViewer)viewer, offset);
                if (props != null) {
                    proposals.addAll(Arrays.asList(props));
                }
                ++i;
            }
        }

        protected void addMissingAttributesProposal(IDOMNode node, ArrayList proposals) {
            Object mbeanNode;
            String[] missing = this.mbeanGetMissingAttributes(node);
            if (missing.length == 0) {
                return;
            }
            Node parentNode = node.getParentNode();
            Object newParent = mbeanNode = node.getNodeName().equals("mbean") ? node : parentNode;
            StringBuffer attributeIndent = new StringBuffer();
            StringBuffer mbeanClosingIndent = new StringBuffer();
            boolean starting = true;
            attributeIndent.append("\n");
            mbeanClosingIndent.append("\n");
            while (newParent != null && !(newParent instanceof DocumentImpl)) {
                newParent = newParent.getParentNode();
                attributeIndent.append("\t");
                if (starting) {
                    starting = false;
                    continue;
                }
                mbeanClosingIndent.append("\t");
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < missing.length) {
                buf.append(attributeIndent);
                buf.append("<attribute name=\"");
                buf.append(missing[i]);
                buf.append("\"></attribute>");
                ++i;
            }
            buf.append(mbeanClosingIndent);
            IDOMNode lastChild = (IDOMNode)mbeanNode.getLastChild();
            int endOffset = lastChild.getEndOffset();
            Image elImage = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/element_obj.gif");
            proposals.add(new CompletionProposal(buf.toString().substring(2), endOffset, 0, 0, elImage, Messages.ServiceXMLAddAttributeTags, null, null));
        }
    }
}

