/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.wizards.NewModelWizard;
import org.jboss.ide.eclipse.as.ui.mbeans.Messages;

public class NewMBeanWizard
extends NewModelWizard
implements INewWizard {
    private IStructuredSelection sel;
    private MBeanInterfacePage interfacePage;
    private MBeanPage mbeanPage;
    private NewFilePageExtension newFilePage;
    private static final String INTERFACE_NAME = "__INTERFACE_NAME__";

    public NewMBeanWizard() {
        this.setWindowTitle(Messages.NewMBeanWizard_WindowTitle);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.newFilePage.setVisible(false);
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(Messages.NewMBeanWizard_CreatingTaskName, 100);
                    SubProgressMonitor interfaceMonitor = new SubProgressMonitor(monitor, 40);
                    SubProgressMonitor mbeanMonitor = new SubProgressMonitor(monitor, 40);
                    SubProgressMonitor xmlMonitor = new SubProgressMonitor(monitor, 20);
                    NewMBeanWizard.this.interfacePage.createType((IProgressMonitor)interfaceMonitor);
                    NewMBeanWizard.this.mbeanPage.createType((IProgressMonitor)mbeanMonitor);
                    xmlMonitor.beginTask(Messages.NewMBeanWizard_XMLTaskName, 1);
                    if (NewMBeanWizard.this.mbeanPage.shouldCreateDescriptor()) {
                        NewMBeanWizard.this.newFilePage.setFileName(String.valueOf(NewMBeanWizard.this.mbeanPage.getCreatedType().getElementName()) + "-service.xml");
                        IPath fullPath = NewMBeanWizard.this.newFilePage.getContainerFullPath();
                        IPath newPath = new Path(fullPath.segment(0)).append("META-INF");
                        NewMBeanWizard.this.createContainer(newPath);
                        NewMBeanWizard.this.newFilePage.setContainerFullPath(newPath);
                        IFile newFile = NewMBeanWizard.this.newFilePage.createNewFile();
                        NewMBeanWizard.this.createStubServiceDescriptor(newFile);
                    }
                    xmlMonitor.worked(1);
                    xmlMonitor.done();
                }
                catch (Throwable jme) {
                    jme.printStackTrace();
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(new Shell()).run(false, true, op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void createContainer(final IPath containerPath) {
        IFile fileHandle = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(containerPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(this.createRule((IResource)fileHandle)){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    ContainerGenerator generator = new ContainerGenerator(containerPath);
                    generator.generateContainer((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {}
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception exception) {}
    }

    protected ISchedulingRule createRule(IResource resource) {
        IContainer parent = resource.getParent();
        while (parent != null) {
            if (parent.exists()) {
                return resource.getWorkspace().getRuleFactory().createRule(resource);
            }
            resource = parent;
            parent = parent.getParent();
        }
        return resource.getWorkspace().getRoot();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.sel = selection;
    }

    public void addPages() {
        this.interfacePage = new MBeanInterfacePage();
        this.mbeanPage = new MBeanPage();
        this.addPage((IWizardPage)this.interfacePage);
        this.addPage((IWizardPage)this.mbeanPage);
        this.interfacePage.init(this.sel);
        this.mbeanPage.init(this.sel);
        this.newFilePage = new NewFilePageExtension(this.sel);
        XMLCorePlugin.getDefault().getPluginPreferences();
        String ext = "xml";
        this.newFilePage.defaultFileExtension = "." + ext;
        this.newFilePage.filterExtensions = new String[]{"*.xml"};
        this.addPage((IWizardPage)this.newFilePage);
    }

    private void createStubServiceDescriptor(IFile newFile) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String charSet = this.getUserPreferredCharset();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, charSet));
        writer.println("<?xml version=\"1.0\" encoding=\"" + charSet + "\"?>");
        writer.println("<server>");
        writer.println("\t<mbean code=\"" + this.mbeanPage.getCreatedType().getFullyQualifiedName() + "\" name=\"your.domain:key=value\">");
        writer.println("\t</mbean>");
        writer.println("</server>");
        writer.flush();
        outputStream.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        newFile.setContents((InputStream)inputStream, true, true, null);
        inputStream.close();
    }

    private String getUserPreferredCharset() {
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        return charSet;
    }

    private class MBeanInterfacePage
    extends NewTypeWizardPage {
        private StringDialogField fMBeanNameDialogField;
        private StringDialogField fMBeanInterfaceNameDialogField;
        private IStatus fMBeanNameStatus;

        public MBeanInterfacePage() {
            super(false, Messages.NewMBeanInterface);
            this.setTitle(Messages.NewMBeanInterface);
            this.setDescription(Messages.NewMBeanInterfaceDesc);
            this.fMBeanNameDialogField = new StringDialogField();
            this.fMBeanNameDialogField.setDialogFieldListener((IDialogFieldListener)new MBeanPage1DialogFieldAdapter());
            this.fMBeanNameDialogField.setLabelText(Messages.NewMBeanName);
            this.fMBeanInterfaceNameDialogField = new StringDialogField();
            this.fMBeanInterfaceNameDialogField.setDialogFieldListener((IDialogFieldListener)new MBeanPage1DialogFieldAdapter());
            this.fMBeanInterfaceNameDialogField.setLabelText(Messages.NewMBeanInterfaceName);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            int nColumns = 4;
            GridLayout layout = new GridLayout();
            layout.numColumns = nColumns;
            composite.setLayout((Layout)layout);
            this.createContainerControls(composite, nColumns);
            this.createPackageControls(composite, nColumns);
            this.createSeparator(composite, nColumns);
            this.createMBeanNameControls(composite, nColumns);
            this.createTypeNameControls(composite, nColumns);
            this.createSuperClassControls(composite, nColumns);
            this.createSuperInterfacesControls(composite, nColumns);
            this.fMBeanInterfaceNameDialogField.getTextControl(null).setEditable(false);
            this.setControl((Control)composite);
        }

        public String getTypeName() {
            return this.fMBeanInterfaceNameDialogField.getText();
        }

        protected void createTypeNameControls(Composite composite, int nColumns) {
            this.fMBeanInterfaceNameDialogField.doFillIntoGrid(composite, nColumns - 1);
            DialogField.createEmptySpace((Composite)composite);
            Text text = this.fMBeanInterfaceNameDialogField.getTextControl(null);
            LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
            TextFieldNavigationHandler.install((Text)text);
        }

        protected void createMBeanNameControls(Composite composite, int nColumns) {
            this.fMBeanNameDialogField.doFillIntoGrid(composite, nColumns - 1);
            DialogField.createEmptySpace((Composite)composite);
            Text text = this.fMBeanNameDialogField.getTextControl(null);
            LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
            TextFieldNavigationHandler.install((Text)text);
        }

        public void init(IStructuredSelection selection) {
            IJavaElement jelem = this.getInitialJavaElement(selection);
            this.initContainerPage(jelem);
            this.initTypePage(jelem);
        }

        protected void handleFieldChanged(String fieldName) {
            super.handleFieldChanged(fieldName);
            if (NewMBeanWizard.INTERFACE_NAME.equals(fieldName)) {
                NewMBeanWizard.this.mbeanPage.setMBeanName(this.fMBeanNameDialogField.getText());
            }
            this.doStatusUpdate();
        }

        private void doStatusUpdate() {
            IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fMBeanNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
            this.updateStatus(status);
        }

        protected IStatus typeNameChanged(String typeNameWithParameters) {
            IPackageFragmentRoot root;
            IPackageFragment pack;
            StatusInfo status = new StatusInfo();
            if (typeNameWithParameters.length() == 0) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnterTypeName);
                return status;
            }
            String typeName = this.getTypeNameWithoutParameters(typeNameWithParameters);
            if (typeName.indexOf(46) != -1) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_QualifiedName);
                return status;
            }
            IStatus val = JavaConventions.validateJavaTypeName((String)typeName);
            if (val.getSeverity() == 4) {
                status.setError(org.eclipse.jdt.internal.corext.util.Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(org.eclipse.jdt.internal.corext.util.Messages.format((String)NewWizardMessages.NewTypeWizardPage_warning_TypeNameDiscouraged, (Object)val.getMessage()));
            }
            if ((pack = this.getPackageFragment()) != null) {
                ICompilationUnit cu = pack.getCompilationUnit(this.getCompilationUnitName(typeName));
                cu.getType(typeName);
                IResource resource = cu.getResource();
                if (resource.exists()) {
                    status.setError(String.valueOf(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists) + "(" + typeName + ")");
                    return status;
                }
                URI location = resource.getLocationURI();
                if (location != null) {
                    try {
                        IFileStore store = EFS.getStore((URI)location);
                        if (store.fetchInfo().exists()) {
                            status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExistsDifferentCase);
                            return status;
                        }
                    }
                    catch (CoreException coreException) {
                        status.setError(org.eclipse.jdt.internal.corext.util.Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_uri_location_unkown, (Object)Resources.getLocationString((IResource)resource)));
                    }
                }
            }
            if (typeNameWithParameters != typeName && (root = this.getPackageFragmentRoot()) != null) {
                if (!JavaModelUtil.is50OrHigher((IJavaProject)root.getJavaProject())) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeParameters);
                    return status;
                }
                String typeDeclaration = "class " + typeNameWithParameters + " {}";
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(typeDeclaration.toCharArray());
                parser.setProject(root.getJavaProject());
                CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
                IProblem[] problems = compilationUnit.getProblems();
                if (problems.length > 0) {
                    status.setError(org.eclipse.jdt.internal.corext.util.Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, (Object)problems[0].getMessage()));
                    return status;
                }
            }
            return status;
        }

        private String getTypeNameWithoutParameters(String typeNameWithParameters) {
            int angleBracketOffset = typeNameWithParameters.indexOf(60);
            if (angleBracketOffset == -1) {
                return typeNameWithParameters;
            }
            return typeNameWithParameters.substring(0, angleBracketOffset);
        }

        private class MBeanPage1DialogFieldAdapter
        implements IDialogFieldListener {
            private MBeanPage1DialogFieldAdapter() {
            }

            public void dialogFieldChanged(DialogField field) {
                String fieldName = null;
                if (field == MBeanInterfacePage.this.fMBeanNameDialogField) {
                    String txt = MBeanInterfacePage.this.fMBeanNameDialogField.getText();
                    MBeanInterfacePage.this.fMBeanInterfaceNameDialogField.getTextControl(null).setText(String.valueOf(txt) + "MBean");
                    fieldName = NewMBeanWizard.INTERFACE_NAME;
                    MBeanInterfacePage.this.fTypeNameStatus = MBeanInterfacePage.this.typeNameChanged(MBeanInterfacePage.this.getTypeName());
                    MBeanInterfacePage.this.fMBeanNameStatus = MBeanInterfacePage.this.typeNameChanged(MBeanInterfacePage.this.fMBeanNameDialogField.getText());
                }
                MBeanInterfacePage.this.handleFieldChanged(fieldName);
            }
        }
    }

    private class MBeanPage
    extends NewTypeWizardPage {
        private StringDialogField fMBeanNameDialogField;
        private SelectionButtonDialogField fDescriptorDialogField;

        public MBeanPage() {
            super(true, Messages.NewMBeanClass);
            this.setTitle(Messages.NewMBeanClass);
            this.setDescription(Messages.MBeanClassDescription);
            MBeanPage2DialogFieldAdapter adapter = new MBeanPage2DialogFieldAdapter();
            this.fMBeanNameDialogField = new StringDialogField();
            this.fMBeanNameDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
            this.fMBeanNameDialogField.setLabelText(Messages.NewMBeanName);
            this.fDescriptorDialogField = new SelectionButtonDialogField(32);
            this.fDescriptorDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
            this.fDescriptorDialogField.setLabelText(Messages.MBeanServiceXML);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            int nColumns = 4;
            GridLayout layout = new GridLayout();
            layout.numColumns = nColumns;
            composite.setLayout((Layout)layout);
            this.createContainerControls(composite, nColumns);
            this.createPackageControls(composite, nColumns);
            this.createSeparator(composite, nColumns);
            this.createMBeanTypeNameControls(composite, nColumns);
            this.createSuperClassControls(composite, nColumns);
            this.createSuperInterfacesControls(composite, nColumns);
            this.createSeparator(composite, nColumns);
            this.createDescriptorControls(composite, nColumns);
            this.fMBeanNameDialogField.getTextControl(null).setEditable(false);
            this.setControl((Control)composite);
        }

        public List getSuperInterfaces() {
            List interfaces = super.getSuperInterfaces();
            if (NewMBeanWizard.this.interfacePage.getCreatedType() != null) {
                IType t = NewMBeanWizard.this.interfacePage.getCreatedType();
                interfaces.add(t.getFullyQualifiedName());
            }
            return interfaces;
        }

        protected void createDescriptorControls(Composite composite, int nColumns) {
            this.fDescriptorDialogField.doFillIntoGrid(composite, nColumns);
        }

        protected void createMBeanTypeNameControls(Composite composite, int nColumns) {
            this.fMBeanNameDialogField.doFillIntoGrid(composite, nColumns - 1);
            DialogField.createEmptySpace((Composite)composite);
            Text text = this.fMBeanNameDialogField.getTextControl(null);
            LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
            TextFieldNavigationHandler.install((Text)text);
        }

        public String getTypeName() {
            return this.fMBeanNameDialogField.getText();
        }

        public void setMBeanName(String s) {
            this.fMBeanNameDialogField.getTextControl(null).setText(s);
        }

        public void init(IStructuredSelection selection) {
            IJavaElement jelem = this.getInitialJavaElement(selection);
            this.initContainerPage(jelem);
            this.initTypePage(jelem);
        }

        protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
            this.createInheritedMethods(type, true, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }

        public boolean shouldCreateDescriptor() {
            return this.fDescriptorDialogField.isSelected();
        }

        public IWizardPage getNextPage() {
            return null;
        }

        private class MBeanPage2DialogFieldAdapter
        implements IDialogFieldListener {
            private MBeanPage2DialogFieldAdapter() {
            }

            public void dialogFieldChanged(DialogField field) {
            }
        }
    }

    public class NewFilePageExtension
    extends NewModelWizard.NewFilePage {
        private IFile newFile;
        private IPath fullPath;

        public NewFilePageExtension(IStructuredSelection selection) {
            super((NewModelWizard)NewMBeanWizard.this, selection);
        }

        public IFile createNewFile() {
            if (this.newFile != null) {
                return this.newFile;
            }
            final IPath containerPath = this.getContainerFullPath();
            IPath newFilePath = containerPath.append(this.getFileName());
            final IFile newFileHandle = this.createFileHandle(newFilePath);
            final InputStream initialContents = this.getInitialContents();
            this.createLinkTarget();
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(this.createRule((IResource)newFileHandle)){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    try {
                        monitor.beginTask(IDEWorkbenchMessages.WizardNewFileCreationPage_progress, 2000);
                        ContainerGenerator generator = new ContainerGenerator(containerPath);
                        generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        NewFilePageExtension.this.createFile(newFileHandle, initialContents, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof CoreException) {
                    ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
                } else {
                    IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)e.getTargetException());
                    MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()));
                }
                return null;
            }
            this.newFile = newFileHandle;
            return this.newFile;
        }

        public void setContainerFullPath(IPath path) {
            this.fullPath = path;
        }

        public IPath getContainerFullPath() {
            return this.fullPath == null ? super.getContainerFullPath() : this.fullPath;
        }
    }
}

