/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans.wizards.pages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.help.WorkbenchHelp;
import org.jboss.ide.eclipse.as.ui.mbeans.Messages;

public class NewSessionBeanWizardPage
extends NewTypeWizardPage {
    public static final String BEAN_PACKAGE_NAME = "NewSessionBeanWizard.beanPackageName";
    public static final String BEAN_NAME = "NewSessionBeanWizard.beanName";
    public static final String REMOTE_INTERFACE_PACKAGE_NAME = "NewSessionBeanWizard.remoteInterfacePackageName";
    public static final String STATEFUL = "Stateful";
    public static final String STATELESS = "Stateless";
    private String remoteInterfacePackage;
    private String beanClass;
    private String remoteInterfaceName;
    private String beanPackage;
    private Label remoteInterfaceNameLabel;
    private Label beanClassName;
    private Text beanNameText;
    private Text beanPackageName;
    private Text remoteInterfacePackageText;
    private JavaPackageCompletionProcessor packageCompletionProcessor;
    private Button statelessButton;
    private Button statefulButton;
    private Button useCustomRemoteInterfacePackageButton;
    private boolean useCustomRemoteInterfacePackage;
    private ModifyListener listener;
    private IPackageFragment beanPackageFragment;
    private IPackageFragment remoteInterfacePackageFragment;
    private String beanType;
    private IStructuredSelection selection;

    public NewSessionBeanWizardPage() {
        super(true, Messages.NewSessionBeanWizardTitle);
        this.setTitle(Messages.NewSessionBeanWizardMessage);
        this.setDescription(Messages.NewSessionBeanWizardDescription);
        this.packageCompletionProcessor = new JavaPackageCompletionProcessor();
        this.beanClass = "";
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        this.listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSessionBeanWizardPage.this.updateTypeNames();
                if (e.getSource() == NewSessionBeanWizardPage.this.remoteInterfacePackageText) {
                    NewSessionBeanWizardPage.this.handleFieldChanged(NewSessionBeanWizardPage.REMOTE_INTERFACE_PACKAGE_NAME);
                } else if (e.getSource() == NewSessionBeanWizardPage.this.beanPackageName) {
                    NewSessionBeanWizardPage.this.handleFieldChanged(NewSessionBeanWizardPage.BEAN_PACKAGE_NAME);
                    if (!NewSessionBeanWizardPage.this.useCustomRemoteInterfacePackage) {
                        NewSessionBeanWizardPage.this.handleFieldChanged(NewSessionBeanWizardPage.REMOTE_INTERFACE_PACKAGE_NAME);
                    }
                } else if (e.getSource() == NewSessionBeanWizardPage.this.beanNameText) {
                    NewSessionBeanWizardPage.this.handleFieldChanged(NewSessionBeanWizardPage.BEAN_NAME);
                }
            }
        };
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createBeanTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createBeanNameControls(composite, nColumns);
        this.createRemoteInterfaceControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.setControl((Control)composite);
        IJavaElement element = this.getInitialJavaElement(this.selection);
        if (element.getElementType() == 4) {
            this.beanPackageName.setText(element.getElementName());
            this.remoteInterfacePackageText.setText(element.getElementName());
        }
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    protected void createBeanTypeControls(Composite composite, int nColumns) {
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (NewSessionBeanWizardPage.this.statelessButton.getSelection()) {
                    NewSessionBeanWizardPage.this.beanType = NewSessionBeanWizardPage.STATELESS;
                } else {
                    NewSessionBeanWizardPage.this.beanType = NewSessionBeanWizardPage.STATEFUL;
                }
            }
        };
        this.createLabel(composite, Messages.NewSessionBeanWizardBeanTypeLabel);
        this.statefulButton = new Button(composite, 16);
        this.statefulButton.setText(Messages.NewSessionBeanWizardStatefulButtonLabel);
        this.statefulButton.addSelectionListener(listener);
        this.statelessButton = new Button(composite, 16);
        this.statelessButton.setText(Messages.NewSessionBeanWizardStatelessButtonLabel);
        this.statelessButton.setSelection(true);
        this.beanType = STATELESS;
        this.statelessButton.addSelectionListener(listener);
    }

    protected void createBeanNameControls(Composite composite, int nColumns) {
        this.createLabel(composite, Messages.NewSessionBeanWizardBeanPackageLabel);
        this.beanPackageName = new Text(composite, 2048);
        this.beanPackageName.addModifyListener(this.listener);
        this.fillAcrossColumns((Control)this.beanPackageName, nColumns - 1);
        ControlContentAssistHelper.createTextContentAssistant((Text)this.beanPackageName, (IContentAssistProcessor)this.packageCompletionProcessor);
        this.createLabel(composite, Messages.NewSessionBeanWizardBeanNameLabel);
        this.beanNameText = new Text(composite, 2048);
        this.beanNameText.addModifyListener(this.listener);
        this.fillAcrossColumns((Control)this.beanNameText, nColumns - 1);
        this.createLabel(composite, Messages.NewSessionBeanWizardBeanClassNameLabel);
        this.beanClassName = this.createLabelWithImage(composite, "", JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif"), nColumns - 1);
    }

    protected void createRemoteInterfaceControls(Composite composite, int nColumns) {
        this.useCustomRemoteInterfacePackageButton = new Button(composite, 32);
        this.useCustomRemoteInterfacePackageButton.setText(Messages.NewSessionBeanWizardUseCustomInterfacePackageButtonLabel);
        this.useCustomRemoteInterfacePackageButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                NewSessionBeanWizardPage.this.useCustomRemoteInterfacePackage = !NewSessionBeanWizardPage.this.useCustomRemoteInterfacePackage;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!NewSessionBeanWizardPage.this.useCustomRemoteInterfacePackage) {
                            NewSessionBeanWizardPage.this.remoteInterfacePackageText.removeModifyListener(NewSessionBeanWizardPage.this.listener);
                        } else {
                            NewSessionBeanWizardPage.this.remoteInterfacePackageText.addModifyListener(NewSessionBeanWizardPage.this.listener);
                        }
                        NewSessionBeanWizardPage.this.remoteInterfacePackageText.setEnabled(NewSessionBeanWizardPage.this.useCustomRemoteInterfacePackage);
                    }
                });
            }
        });
        this.remoteInterfacePackageText = new Text(composite, 2048);
        this.remoteInterfacePackageText.setEnabled(false);
        this.fillAcrossColumns((Control)this.remoteInterfacePackageText, nColumns - 1);
        ControlContentAssistHelper.createTextContentAssistant((Text)this.remoteInterfacePackageText, (IContentAssistProcessor)this.packageCompletionProcessor);
        this.createLabel(composite, Messages.NewSessionBeanWizardRemoteInterfaceNameLabel);
        this.remoteInterfaceNameLabel = this.createLabelWithImage(composite, "", JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif"), nColumns - 1);
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        super.createType(monitor);
        IType createdBeanType = this.getCreatedType();
        this.createRemoteInterface(monitor);
        ICompilationUnit beanUnit = createdBeanType.getCompilationUnit();
        Document doc = new Document(beanUnit.getSource());
        ASTParser c = ASTParser.newParser((int)3);
        c.setSource(beanUnit.getSource().toCharArray());
        c.setResolveBindings(true);
        CompilationUnit beanAstUnit = (CompilationUnit)c.createAST(null);
        AST ast = beanAstUnit.getAST();
        beanAstUnit.recordModifications();
        ImportDeclaration importDecl = ast.newImportDeclaration();
        importDecl.setName(ast.newName(new String[]{"javax", "ejb", this.beanType}));
        importDecl.setOnDemand(false);
        beanAstUnit.imports().add(importDecl);
        importDecl = ast.newImportDeclaration();
        String[] pkgElements = this.remoteInterfacePackage.split("\\.");
        String[] fullImport = new String[pkgElements.length + 1];
        System.arraycopy(pkgElements, 0, fullImport, 0, pkgElements.length);
        fullImport[fullImport.length - 1] = this.remoteInterfaceName;
        importDecl.setName(ast.newName(fullImport));
        importDecl.setOnDemand(false);
        beanAstUnit.imports().add(importDecl);
        MarkerAnnotation sessionAnnotation = ast.newMarkerAnnotation();
        sessionAnnotation.setTypeName((Name)ast.newSimpleName(this.beanType));
        TypeDeclaration type = (TypeDeclaration)beanAstUnit.types().get(0);
        type.modifiers().add(sessionAnnotation);
        type.superInterfaceTypes().add(ast.newSimpleType((Name)ast.newSimpleName(this.remoteInterfaceName)));
        TextEdit edit = beanAstUnit.rewrite((IDocument)doc, null);
        try {
            edit.apply((IDocument)doc);
            String source = doc.get();
            beanUnit.getBuffer().setContents(source);
            beanUnit.getBuffer().save(monitor, true);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public ICompilationUnit createRemoteInterface(IProgressMonitor monitor) throws CoreException, InterruptedException {
        String source = "package " + this.remoteInterfacePackage + ";\n" + "\n" + "import javax.ejb.Remote;\n" + "\n" + "@Remote\n" + "public interface " + this.remoteInterfaceName + " {\n" + "\n" + "}\n";
        return this.remoteInterfacePackageFragment.createCompilationUnit(String.valueOf(this.remoteInterfaceName) + ".java", source, true, monitor);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        try {
            if (fieldName.equals(BEAN_PACKAGE_NAME)) {
                this.beanPackageFragment = this.getPackageFragment(this.beanPackageName.getText());
                this.beanPackage = this.beanPackageName.getText();
                if (!this.useCustomRemoteInterfacePackage) {
                    this.updateRemoteInterfaceValues();
                }
            } else if (fieldName.equals(REMOTE_INTERFACE_PACKAGE_NAME)) {
                this.updateRemoteInterfaceValues();
            } else if (fieldName.equals(BEAN_NAME)) {
                this.remoteInterfaceName = this.beanNameText.getText();
                this.beanClass = String.valueOf(this.beanNameText.getText()) + "Bean";
            }
        }
        catch (CoreException coreException) {}
    }

    public IPackageFragment getPackageFragment() {
        return this.beanPackageFragment;
    }

    protected IPackageFragment getPackageFragment(String packageName) throws CoreException {
        IPackageFragmentRoot root;
        StatusInfo status = new StatusInfo();
        if (packageName.length() > 0) {
            IStatus val = JavaConventions.validatePackageName((String)packageName);
            if (val.getSeverity() == 4) {
                status.setError(NewWizardMessages.bind((String)NewWizardMessages.NewTypeWizardPage_error_InvalidPackageName, (Object)val.getMessage()));
                throw new CoreException((IStatus)status);
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewWizardMessages.bind((String)NewWizardMessages.NewTypeWizardPage_warning_DiscouragedPackageName, (Object)val.getMessage()));
            }
        } else {
            status.setWarning(NewWizardMessages.NewTypeWizardPage_warning_DefaultPackageDiscouraged);
        }
        if ((root = this.getPackageFragmentRoot()) != null) {
            if (root.getJavaProject().exists() && packageName.length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = root.getJavaProject().getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packageName.replace('.', '/')))) {
                        status.setError(NewWizardMessages.NewTypeWizardPage_error_ClashOutputLocation);
                        throw new CoreException((IStatus)status);
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((Throwable)e);
                }
            }
            return root.getPackageFragment(packageName);
        }
        status.setError("");
        throw new CoreException((IStatus)status);
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        this.packageCompletionProcessor.setPackageFragmentRoot(this.getPackageFragmentRoot());
        return status;
    }

    public String getTypeName() {
        return this.beanClass;
    }

    String getClassName(String pkg, String clazz) {
        if (pkg != null && pkg.length() > 0) {
            return String.valueOf(pkg) + "." + clazz;
        }
        return clazz;
    }

    void updateTypeNames() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String packageName = NewSessionBeanWizardPage.this.beanPackageName.getText();
                if (!NewSessionBeanWizardPage.this.useCustomRemoteInterfacePackage) {
                    NewSessionBeanWizardPage.this.remoteInterfacePackageText.setText(packageName);
                }
                String interfacePackageName = NewSessionBeanWizardPage.this.remoteInterfacePackageText.getText();
                String beanName = NewSessionBeanWizardPage.this.beanNameText.getText();
                NewSessionBeanWizardPage.this.beanClassName.setText(String.valueOf(NewSessionBeanWizardPage.this.getClassName(packageName, beanName)) + (beanName != null && beanName.length() > 0 ? "Bean" : ""));
                NewSessionBeanWizardPage.this.remoteInterfaceNameLabel.setText(NewSessionBeanWizardPage.this.getClassName(interfacePackageName, beanName));
                NewSessionBeanWizardPage.this.updateRemoteInterfaceValues();
            }
        });
    }

    void updateRemoteInterfaceValues() {
        try {
            this.remoteInterfaceName = this.beanNameText.getText();
            this.remoteInterfacePackage = this.remoteInterfacePackageText.getText();
            this.remoteInterfacePackageFragment = this.getPackageFragment(this.remoteInterfacePackage);
        }
        catch (CoreException coreException) {}
    }

    protected void fillAcrossColumns(Control control, int nColumns) {
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = nColumns;
        control.setLayoutData((Object)data);
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected Label createLabelWithImage(Composite parent, String text, Image image, int compositeColSpan) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        this.fillAcrossColumns((Control)c, compositeColSpan);
        Label imgLabel = new Label(c, 0);
        imgLabel.setImage(image);
        Label label = new Label(c, 0);
        label.setText(text);
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        label.setLayoutData((Object)d);
        return label;
    }

    public void init(IStructuredSelection selection) {
        this.selection = selection;
        IJavaElement element = this.getInitialJavaElement(selection);
        this.initContainerPage(element);
        this.initTypePage(element);
    }

    class TypeNameGetter
    implements Runnable {
        public String typeName = "";

        public void run() {
            if (NewSessionBeanWizardPage.this.beanNameText == null) {
                this.typeName = "";
                return;
            }
            if (!NewSessionBeanWizardPage.this.beanNameText.isDisposed()) {
                this.typeName = String.valueOf(NewSessionBeanWizardPage.this.beanNameText.getText()) + "Bean";
            }
        }
    }
}

