/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.ide.eclipse.as.ui.util.PackageTypeSearcher;

public class ServiceXMLEditorUtil {
    public static IType findType(String codeClass) {
        final String codeClass2 = codeClass;
        if (codeClass == null) {
            return null;
        }
        PackageTypeSearcher.ResultFilter filter = new PackageTypeSearcher.ResultFilter(){

            public boolean accept(Object found) {
                if (found instanceof IType) {
                    IType type = (IType)found;
                    return type.getFullyQualifiedName().equals(codeClass2);
                }
                return true;
            }
        };
        PackageTypeSearcher searcher = new PackageTypeSearcher(codeClass, filter);
        ArrayList foundTypes = searcher.getTypeMatches();
        if (foundTypes.size() == 1) {
            return (IType)foundTypes.get(0);
        }
        return null;
    }

    public static IMethod[] getAllMethods(IType type) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        try {
            methods.addAll(Arrays.asList(type.getMethods()));
            String parentTypeName = type.getSuperclassName();
            IType parentType = ServiceXMLEditorUtil.findType(parentTypeName);
            if (parentType != null) {
                methods.addAll(Arrays.asList(ServiceXMLEditorUtil.getAllMethods(parentType)));
            }
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static String[] findAttributesFromMethods(IMethod[] methods, String attributeCurrentValue) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        String getterPrefix = "get" + attributeCurrentValue;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().startsWith(getterPrefix)) {
                String atName = methods[i].getElementName().substring(3);
                String setterName = "set" + atName;
                int j = 0;
                while (j < methods.length) {
                    if (methods[j].getElementName().equals(setterName)) {
                        try {
                            if (methods[j].getParameterNames().length == 1) {
                                String[] paramTypes = methods[j].getParameterTypes();
                                String getterReturnType = methods[i].getReturnType();
                                if (getterReturnType.equals(paramTypes[0])) {
                                    attributeNames.add(atName);
                                }
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    ++j;
                }
            }
            ++i;
        }
        return attributeNames.toArray(new String[attributeNames.size()]);
    }
}

