/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.wtp.core.modules.IJBTModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModelUtilities {
    public static ArrayList<IModule[]> getShallowChildren(IServer server, IModule[] root) {
        ArrayList<IModule[]> list = new ArrayList<IModule[]>();
        IModule[] children = server.getChildModules(root, (IProgressMonitor)new NullProgressMonitor());
        int length = children == null ? 0 : children.length;
        int i = 0;
        while (i < length) {
            ArrayList<IModule> inner = new ArrayList<IModule>();
            inner.addAll(Arrays.asList(root));
            inner.add(children[i]);
            IModule[] innerMods = inner.toArray(new IModule[inner.size()]);
            list.add(innerMods);
            ++i;
        }
        return list;
    }

    public static ArrayList<IModule[]> getDeepChildren(IServer server, IModule[] mod) {
        ArrayList<IModule[]> deep = ServerModelUtilities.getShallowChildren(server, mod);
        int i = 0;
        while (i < deep.size()) {
            IModule[] toBeSearched = deep.get(i);
            deep.addAll(ServerModelUtilities.getShallowChildren(server, toBeSearched));
            ++i;
        }
        return deep;
    }

    public static IModule[] getChildModules(IModule[] module) {
        int last = module.length - 1;
        if (module[last] != null && module[last].getModuleType() != null) {
            IEnterpriseApplication enterpriseApplication = (IEnterpriseApplication)module[last].loadAdapter(IEnterpriseApplication.class, null);
            if (enterpriseApplication != null) {
                return enterpriseApplication.getModules() == null ? new IModule[]{} : enterpriseApplication.getModules();
            }
            IJBTModule jbtMod = (IJBTModule)module[last].loadAdapter(IJBTModule.class, null);
            if (jbtMod != null) {
                return jbtMod.getModules();
            }
        }
        return new IModule[0];
    }
}

