/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class VCFUtil {
    public static void addReference(IVirtualComponent component, IVirtualComponent rootComponent, String path, String archiveName) throws CoreException {
        Throwable t;
        CreateReferenceComponentsDataModelProvider provider = new CreateReferenceComponentsDataModelProvider();
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)rootComponent);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", Arrays.asList(component));
        HashMap<IVirtualComponent, String> uriMap = new HashMap<IVirtualComponent, String>();
        uriMap.put(component, archiveName);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", uriMap);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)path);
        IStatus stat = dm.validateProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        Throwable throwable = t = stat == null ? null : stat.getException();
        if (stat == null || stat.isOK()) {
            try {
                dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                return;
            }
            catch (ExecutionException e) {
                t = e;
            }
        }
        if (t != null) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.wtp.core", t.getMessage(), t);
            throw new CoreException((IStatus)status);
        }
    }

    public static IProjectFacet getModuleFacet(IProject proj) {
        if (ModuleCoreNature.isFlexibleProject((IProject)proj)) {
            try {
                IGroup group = ProjectFacetsManager.getGroup((String)"modules");
                if (group != null) {
                    Set set = group.getMembers();
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        IProjectFacet facet = ((IProjectFacetVersion)i.next()).getProjectFacet();
                        if (!FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)facet.getId())) continue;
                        return facet;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static String getModuleFacetExtension(IProject project) {
        IProjectFacet facet = VCFUtil.getModuleFacet(project);
        if (facet != null) {
            if (facet.getId().equals("jst.web")) {
                return ".war";
            }
            if (facet.getId().equals("jst.ejb")) {
                return ".jar";
            }
            if (facet.getId().equals("jst.utility")) {
                return ".jar";
            }
            if (facet.getId().equals("jst.ear")) {
                return ".ear";
            }
            if (facet.getId().equals("wst.web")) {
                return ".war";
            }
            if (facet.getId().equals("jst.appclient")) {
                return ".jar";
            }
            if (facet.getId().equals("jst.connector")) {
                return ".rar";
            }
            if (facet.getId().equals("jst.jboss.esb")) {
                return ".esb";
            }
            if (facet.getId().equals("jbt.bpel.facet.core")) {
                return ".bpel";
            }
        }
        return null;
    }
}

