/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.vcf;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.jboss.ide.eclipse.as.wtp.core.vcf.IReferenceResolver;

public class DefaultReferenceResolver
implements IReferenceResolver {
    public boolean canResolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        return false;
    }

    public boolean canResolve(IVirtualReference reference) {
        return false;
    }

    public IVirtualReference resolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        IVirtualComponent targetComponent = null;
        IProject targetProject = null;
        URI uri = referencedComponent.getHandle();
        if (uri == null) {
            return null;
        }
        boolean isClassPathURI = ModuleURIUtil.isClassPathURI((URI)uri);
        if (!isClassPathURI) {
            try {
                targetProject = StructureEdit.getContainingProject((URI)uri);
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            targetComponent = ComponentCore.createComponent((IProject)targetProject);
        } else {
            String archiveType = "";
            String archiveName = "";
            try {
                archiveType = ModuleURIUtil.getArchiveType((URI)uri);
                archiveName = ModuleURIUtil.getArchiveName((URI)uri);
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            targetComponent = ComponentCore.createArchiveComponent((IProject)context.getProject(), (String)(String.valueOf(archiveType) + '/' + archiveName));
        }
        return new VirtualReference(context, targetComponent, referencedComponent.getRuntimePath(), referencedComponent.getDependencyType().getValue());
    }

    public ReferencedComponent resolve(IVirtualReference reference) {
        IVirtualComponent referencedComponent = reference.getReferencedComponent();
        ReferencedComponent refComp = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createReferencedComponent();
        refComp.setRuntimePath(reference.getRuntimePath());
        refComp.setDependencyType(DependencyType.get((int)reference.getDependencyType()));
        refComp.setArchiveName(reference.getArchiveName());
        if (referencedComponent != null) {
            if (!referencedComponent.isBinary()) {
                refComp.setHandle(ModuleURIUtil.fullyQualifyURI((IProject)referencedComponent.getProject()));
            } else {
                refComp.setHandle(ModuleURIUtil.archiveComponentfullyQualifyURI((String)referencedComponent.getName()));
            }
        }
        return refComp;
    }
}

