/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.ide.eclipse.as.classpath.ui.Messages;

public class DirectoryLibraryPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IProject ownerProject;
    private String libsProjectName;
    private Combo projectsCombo;

    public DirectoryLibraryPage() {
        super("DirectoryLibrariesContainerPage");
        this.setTitle(Messages.DirectoryLibraryPage_Title);
        this.setDescription(Messages.DirectoryLibraryPage_Description);
    }

    public IClasspathEntry getSelection() {
        Path path = new Path("org.jboss.ide.eclipse.as.classpath.core.DirectoryLibraryContainer");
        int index = this.projectsCombo.getSelectionIndex();
        String selectedProjectName = this.projectsCombo.getItem(index);
        if (this.ownerProject == null || !selectedProjectName.equals(this.ownerProject.getName())) {
            path = path.append(selectedProjectName);
        }
        return JavaCore.newContainerEntry((IPath)path);
    }

    public void setSelection(IClasspathEntry cpentry) {
        IPath path;
        IPath iPath = path = cpentry == null ? null : cpentry.getPath();
        if (path == null || path.segmentCount() == 1) {
            if (this.ownerProject != null) {
                this.libsProjectName = this.ownerProject.getName();
            }
        } else {
            this.libsProjectName = path.segment(1);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.DirectoryLibraryPage_LabelProject);
        String[] webProjects = DirectoryLibraryPage.getWebProjects();
        this.projectsCombo = new Combo(composite, 8);
        this.projectsCombo.setItems(webProjects);
        int index = this.ownerProject != null ? DirectoryLibraryPage.indexOf(webProjects, this.libsProjectName) : (this.projectsCombo.getItemCount() > 0 ? 0 : -1);
        if (index != -1) {
            this.projectsCombo.select(index);
        }
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        this.projectsCombo.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public boolean finish() {
        return true;
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.ownerProject = project == null ? null : project.getProject();
    }

    private static String[] getWebProjects() {
        return new String[]{Messages.DirectoryLibraryPage_WebProjects};
    }

    private static int indexOf(String[] array, String str) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

