/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools;

import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.ide.eclipse.archives.webtools.IntegrationPlugin;
import org.osgi.framework.Bundle;

public class SharedImages {
    private static SharedImages instance;
    public static final String FILESET_IMAGE = "multiple_files";
    private Hashtable<String, Object> images;
    private Hashtable<String, Object> descriptors;

    private SharedImages() {
        instance = this;
        this.images = new Hashtable();
        this.descriptors = new Hashtable();
        Bundle pluginBundle = IntegrationPlugin.getDefault().getBundle();
        this.descriptors.put(FILESET_IMAGE, this.createImageDescriptor(pluginBundle, "/icons/multiple_files.gif"));
        for (String key : this.descriptors.keySet()) {
            ImageDescriptor descriptor = this.descriptor(key);
            this.images.put(key, descriptor.createImage());
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle pluginBundle, String relativePath) {
        return ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(relativePath));
    }

    public static SharedImages instance() {
        if (instance == null) {
            instance = new SharedImages();
        }
        return instance;
    }

    public static Image getImage(String key) {
        return SharedImages.instance().image(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return SharedImages.instance().descriptor(key);
    }

    public Image image(String key) {
        return (Image)this.images.get(key);
    }

    public ImageDescriptor descriptor(String key) {
        return (ImageDescriptor)this.descriptors.get(key);
    }

    public void cleanup() {
        Iterator<String> iter = this.images.keySet().iterator();
        while (iter.hasNext()) {
            Image image = (Image)this.images.get(iter.next());
            image.dispose();
        }
        this.images = null;
        instance = null;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

