/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.archivetypes;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.wst.server.core.IModule;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveType;
import org.jboss.ide.eclipse.archives.webtools.archivetypes.J2EEArchiveType;
import org.jboss.ide.eclipse.archives.webtools.modules.ModulePackageTypeConverter;

public class EarArchiveType
extends J2EEArchiveType {
    public static final String ID = "org.jboss.ide.eclipse.as.core.packages.earPackageType";
    private static final String EXTENSION = ".ear";
    private static final String JAR_EXTENSION = ".jar";

    public String getAssociatedModuleType() {
        return "jst.ear";
    }

    public String getId() {
        return ID;
    }

    public String getLabel() {
        return "EAR";
    }

    public IArchive createDefaultConfiguration(String project, IProgressMonitor monitor) {
        IModule mod = this.getModule(project);
        if (mod != null) {
            return this.createDefaultConfigFromModule(mod, monitor);
        }
        return this.createDefaultConfiguration2(project, monitor);
    }

    public IArchive createDefaultConfiguration2(String projectName, IProgressMonitor monitor) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IArchive topLevel = EarArchiveType.createGenericIArchive(project, null, String.valueOf(project.getName()) + EXTENSION);
        topLevel.setDestinationPath((IPath)new Path(project.getName()));
        topLevel.setInWorkspace(true);
        this.fillDefaultConfiguration(projectName, topLevel, monitor);
        return topLevel;
    }

    public IArchive createDefaultConfigFromModule(IModule module, IProgressMonitor monitor) {
        IProject project = module.getProject();
        IFolder sourceContainer = project.getFolder("EarContent");
        IArchive topLevel = EarArchiveType.createGenericIArchive(project, null, String.valueOf(project.getName()) + EXTENSION, (IContainer)sourceContainer);
        topLevel.setDestinationPath((IPath)new Path(project.getName()));
        topLevel.setInWorkspace(true);
        this.fillDefaultConfiguration(project.getName(), topLevel, monitor);
        return topLevel;
    }

    public IArchive fillDefaultConfiguration(String projectName, IArchive topLevel, IProgressMonitor monitor) {
        block9: {
            try {
                IModule mod = this.getModule(projectName);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (mod == null) {
                    IArchiveFolder metainf = EarArchiveType.addFolder(project, (IArchiveNode)topLevel, "META-INF");
                    EarArchiveType.addFileset(project, (IArchiveNode)metainf, new Path(projectName).append("META-INF").toOSString(), null);
                    break block9;
                }
                EarArchiveType.addFileset(project, (IArchiveNode)topLevel, new Path(project.getName()).append("EarContent").toOSString(), "**/*.*");
                IEnterpriseApplication earModule = (IEnterpriseApplication)mod.loadAdapter(IEnterpriseApplication.class, monitor);
                IModule[] childModules = earModule.getModules();
                int i = 0;
                while (i < childModules.length) {
                    block10: {
                        IArchive childPack;
                        block12: {
                            IArchiveType type;
                            IModule child;
                            block11: {
                                child = childModules[i];
                                IJ2EEModule j2eeChild = (IJ2EEModule)child.loadAdapter(IJ2EEModule.class, (IProgressMonitor)new NullProgressMonitor());
                                if (j2eeChild == null || j2eeChild.isBinary()) break block10;
                                type = ModulePackageTypeConverter.getPackageTypeFor(child);
                                if (type != null) break block11;
                                childPack = EarArchiveType.createGenericIArchive(child.getProject(), null, String.valueOf(child.getProject().getName()) + JAR_EXTENSION);
                                break block12;
                            }
                            if (new Path(childModules[i].getName()).segmentCount() > 1) break block10;
                            childPack = type.createDefaultConfiguration(child.getProject().getName(), (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (childPack != null) {
                            topLevel.addChild((IArchiveNode)childPack);
                        }
                    }
                    ++i;
                }
            }
            catch (ArchivesModelException archivesModelException) {}
        }
        return topLevel;
    }
}

