/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.archivetypes;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveType;
import org.jboss.ide.eclipse.archives.webtools.IntegrationPlugin;
import org.jboss.ide.eclipse.archives.webtools.Messages;

public abstract class J2EEArchiveType
implements IArchiveType {
    public static final String METAINF = "META-INF";
    public static final String WEBINF = "WEB-INF";
    public static final String CLASSES = "classes";
    public static final String LIB = "lib";
    public static final String WEBCONTENT = "WebContent";
    public static final String EARCONTENT = "EarContent";
    public static final String EJBMODULE = "ejbModule";

    protected boolean isModuleType(IModule module, String moduleTypeId) {
        return module.getModuleType() != null && moduleTypeId.equals(module.getModuleType().getId());
    }

    protected IModule getModule(String projectName) {
        IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)this.getProject(projectName));
        if (moduleArtifacts != null && moduleArtifacts.length > 0) {
            return moduleArtifacts[0].getModule();
        }
        return null;
    }

    protected IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IArchive createGenericIArchive(IProject project, String deployDirectory, String packageName) {
        IPath sourcePath;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            Assert.isNotNull((Object)javaProject);
            try {
                sourcePath = javaProject.getOutputLocation();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        catch (Exception e) {
            IntegrationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.archives.webtools", Messages.ExceptionUnexpectedException, (Throwable)e));
            return null;
        }
        sourcePath = sourcePath.removeFirstSegments(1);
        Object sourcePathContainer = sourcePath.segmentCount() == 0 ? project : project.getFolder(sourcePath);
        return J2EEArchiveType.createGenericIArchive(project, deployDirectory, packageName, (IContainer)sourcePathContainer);
    }

    public static IArchive createGenericIArchive(IProject project, String deployDirectory, String packageName, IContainer sourceContainer) {
        IArchive jar = ArchivesCore.getInstance().getNodeFactory().createArchive();
        if (deployDirectory != null) {
            jar.setDestinationPath((IPath)new Path(deployDirectory));
            jar.setInWorkspace(ResourcesPlugin.getWorkspace().getRoot().getLocation().isPrefixOf((IPath)new Path(deployDirectory)));
            jar.setExploded(false);
        } else {
            jar.setDestinationPath(project.getFullPath());
            jar.setInWorkspace(true);
            jar.setExploded(false);
        }
        jar.setName(packageName);
        return jar;
    }

    public static IArchiveFolder addFolder(IProject project, IArchiveNode parent, String name) throws ArchivesModelException {
        IArchiveFolder folder = ArchivesCore.getInstance().getNodeFactory().createFolder();
        folder.setName(name);
        parent.addChild((IArchiveNode)folder);
        return folder;
    }

    public static IArchiveStandardFileSet addFileset(IProject project, IArchiveNode parent, String sourcePath, String includePattern) throws ArchivesModelException {
        IProject sourceContainer;
        IArchiveStandardFileSet fs = ArchivesCore.getInstance().getNodeFactory().createFileset();
        Assert.isNotNull((Object)project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Assert.isNotNull((Object)javaProject);
        if (sourcePath != null && !sourcePath.equals("")) {
            Path p = new Path(sourcePath);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            sourceContainer = p.segmentCount() != 1 ? root.getFolder((IPath)p) : root.getProject(p.segment(0));
        } else {
            sourceContainer = project;
        }
        fs.setRawSourcePath(sourceContainer.getFullPath().toString());
        fs.setInWorkspace(true);
        fs.setIncludesPattern(includePattern == null ? "**/*" : includePattern);
        parent.addChild((IArchiveNode)fs);
        return fs;
    }

    public abstract String getAssociatedModuleType();

    public static DirectoryScannerFactory.DirectoryScannerExtension createDirectoryScanner(String rawPath, String includes, String excludes, boolean scan) {
        return DirectoryScannerFactory.createDirectoryScanner((String)rawPath, null, (String)includes, (String)excludes, null, (boolean)false, (double)1.0, (boolean)scan);
    }
}

