/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.archivetypes;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.jboss.ide.eclipse.archives.core.ArchivesCorePlugin;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.webtools.IntegrationPlugin;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.archivetypes.J2EEArchiveType;

public class WarArchiveType
extends J2EEArchiveType {
    public static final String WAR_PACKAGE_TYPE = "org.jboss.ide.eclipse.as.core.packages.warPackage";

    public String getAssociatedModuleType() {
        return "jst.web";
    }

    public IArchive createDefaultConfiguration(String projectName, IProgressMonitor monitor) {
        IModule mod = this.getModule(projectName);
        if (mod == null) {
            return this.createDefaultConfiguration2(projectName, monitor);
        }
        return this.createDefaultConfigFromModule(mod, monitor);
    }

    protected IArchive createDefaultConfiguration2(String projectName, IProgressMonitor monitor) {
        IProject project = this.getProject(projectName);
        IArchive topLevel = WarArchiveType.createGenericIArchive(project, null, String.valueOf(project.getName()) + ".war");
        return this.fillDefaultConfiguration(project, topLevel, monitor);
    }

    public IArchive fillDefaultConfiguration(String projectName, IArchive topLevel, IProgressMonitor monitor) {
        return this.fillDefaultConfiguration(this.getProject(projectName), topLevel, monitor);
    }

    public IArchive fillDefaultConfiguration(IProject project, IArchive topLevel, IProgressMonitor monitor) {
        try {
            IModule mod = this.getModule(project.getName());
            IArchiveFolder webinf = WarArchiveType.addFolder(project, (IArchiveNode)topLevel, "WEB-INF");
            IArchiveFolder lib = WarArchiveType.addFolder(project, (IArchiveNode)webinf, "lib");
            IArchiveFolder classes = WarArchiveType.addFolder(project, (IArchiveNode)webinf, "classes");
            this.addReferencedProjectsAsLibs(project, lib);
            this.addLibFileset(project, lib, true);
            this.addClassesFileset(project, classes);
            if (mod == null) {
                this.addWebinfFileset(project, webinf);
            } else {
                this.addWebContentFileset(project, (IArchiveNode)topLevel);
            }
        }
        catch (ArchivesModelException archivesModelException) {}
        return topLevel;
    }

    protected void addWebContentFileset(IProject project, IArchiveNode packageRoot) throws ArchivesModelException {
        try {
            IPath projectPath = project.getLocation();
            DirectoryScannerFactory.DirectoryScannerExtension scanner = WarArchiveType.createDirectoryScanner(projectPath.toString(), "**/WEB-INF/web.xml", null, true);
            String[] files = scanner.getIncludedFiles();
            if (files.length > 0) {
                Path path = new Path(files[0]);
                path = path.removeLastSegments(2);
                path = new Path(project.getName()).append((IPath)path);
                IArchiveStandardFileSet fs = WarArchiveType.addFileset(project, packageRoot, path.toOSString(), "**/*");
                fs.setExcludesPattern("**/WEB-INF/lib/*.jar");
            }
        }
        catch (IllegalStateException ise) {
            Status status = new Status(2, "org.jboss.ide.eclipse.archives.webtools", Messages.ExceptionCannotScanDirectory, (Throwable)ise);
            IntegrationPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void addClassesFileset(IProject project, IArchiveFolder folder) throws ArchivesModelException {
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp != null) {
            try {
                IPath outputLoc = project.getWorkspace().getRoot().getLocation();
                outputLoc = outputLoc.append(jp.getOutputLocation());
                WarArchiveType.addFileset(project, (IArchiveNode)folder, jp.getOutputLocation().toOSString(), "**/*");
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void addWebinfFileset(IProject project, IArchiveFolder folder) throws ArchivesModelException {
        try {
            IPath projectPath = project.getLocation();
            DirectoryScannerFactory.DirectoryScannerExtension scanner = WarArchiveType.createDirectoryScanner(projectPath.toString(), "**/web.xml", null, true);
            String[] files = scanner.getIncludedFiles();
            if (files.length > 0) {
                Path path = new Path(files[0]);
                path = path.removeLastSegments(1);
                path = new Path(project.getName()).append((IPath)path);
                WarArchiveType.addFileset(project, (IArchiveNode)folder, path.toOSString(), "**/*");
            }
        }
        catch (IllegalStateException ise) {
            Status status = new Status(2, "org.jboss.ide.eclipse.archives.core", Messages.ExceptionCannotScanDirectory, (Throwable)ise);
            ArchivesCorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void addLibFileset(IProject project, IArchiveFolder folder, boolean includeTopLevelJars) throws ArchivesModelException {
        String sourcePath = null;
        IPath projectPath = project.getLocation();
        DirectoryScannerFactory.DirectoryScannerExtension scanner = WarArchiveType.createDirectoryScanner(projectPath.toString(), "**/WEB-INF/web.xml", null, true);
        String[] files = scanner.getIncludedFiles();
        if (files != null && files.length > 0) {
            Path path = new Path(files[0]);
            path = path.removeLastSegments(1).append("lib");
            sourcePath = project.getFullPath().append((IPath)path).toString();
            WarArchiveType.addFileset(project, (IArchiveNode)folder, sourcePath, "*.jar");
        } else {
            sourcePath = project.getName();
            DirectoryScannerFactory.DirectoryScannerExtension scanner2 = WarArchiveType.createDirectoryScanner(projectPath.toString(), "**/*.jar", null, true);
            String[] files2 = scanner2.getIncludedFiles();
            ArrayList<IPath> list = new ArrayList<IPath>();
            int i = 0;
            while (i < files2.length) {
                IPath p = project.getFullPath().append(files2[i]).removeLastSegments(1);
                if (!list.contains(p)) {
                    list.add(p);
                    WarArchiveType.addFileset(project, (IArchiveNode)folder, p.toString(), "*.jar");
                }
                ++i;
            }
        }
    }

    protected void addReferencedProjectsAsLibs(IProject project, IArchiveFolder folder) throws ArchivesModelException {
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp != null && jp.exists()) {
            try {
                IClasspathEntry[] entries = jp.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getEntryKind() == 2) {
                        IPath path = entries[i].getPath();
                        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                        if (res instanceof IProject) {
                            this.createLibFromProject((IProject)res, folder);
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void createLibFromProject(IProject project, IArchiveFolder folder) throws ArchivesModelException {
        IArchive pack = WarArchiveType.createGenericIArchive(project, null, String.valueOf(project.getName()) + ".jar");
        folder.addChild((IArchiveNode)pack);
    }

    protected IArchive createDefaultConfigFromModule(IModule mod, IProgressMonitor monitor) {
        try {
            IProject project = mod.getProject();
            IArchive topLevel = WarArchiveType.createGenericIArchive(project, null, String.valueOf(project.getName()) + ".war");
            topLevel.setDestinationPath((IPath)new Path(project.getName()));
            topLevel.setInWorkspace(true);
            IArchiveFolder webinf = WarArchiveType.addFolder(project, (IArchiveNode)topLevel, "WEB-INF");
            IArchiveFolder lib = WarArchiveType.addFolder(project, (IArchiveNode)webinf, "lib");
            IArchiveFolder classes = WarArchiveType.addFolder(project, (IArchiveNode)webinf, "classes");
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            IPath webContentPath = vc.getRootFolder().getUnderlyingFolder().getFullPath();
            WarArchiveType.addFileset(project, (IArchiveNode)topLevel, webContentPath.toOSString(), "**/*");
            this.addClassesFileset(project, classes);
            IWebModule webModule = (IWebModule)mod.loadAdapter(IWebModule.class, monitor);
            IModule[] childModules = webModule.getModules();
            int i = 0;
            while (i < childModules.length) {
                IModule child = childModules[i];
                IJ2EEModule j2eeChild = (IJ2EEModule)child.loadAdapter(IJ2EEModule.class, (IProgressMonitor)new NullProgressMonitor());
                if (j2eeChild != null && !j2eeChild.isBinary()) {
                    lib.addChild((IArchiveNode)WarArchiveType.createGenericIArchive(child.getProject(), null, String.valueOf(child.getProject().getName()) + ".jar"));
                }
                ++i;
            }
            return topLevel;
        }
        catch (Exception e) {
            IntegrationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.archives.webtools", Messages.ExceptionUnexpectedException, (Throwable)e));
            return null;
        }
    }

    public String getId() {
        return WAR_PACKAGE_TYPE;
    }

    public String getLabel() {
        return "WAR";
    }
}

