/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetDialog;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetLabelProvider;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetUtil;

public class DefaultFilesetPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo servers;
    private TreeViewer viewer;
    private Button addButton;
    private Button removeButton;
    private HashMap<String, ArrayList<Fileset>> cacheMap = new HashMap();
    private ArrayList<String> changed = new ArrayList();
    private IServerType[] types = null;

    public DefaultFilesetPreferencePage() {
    }

    public DefaultFilesetPreferencePage(String title) {
        super(title);
    }

    public DefaultFilesetPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FormLayout());
        c.setLayoutData((Object)new GridData(1808));
        Label l = new Label(c, 0);
        l.setText(Messages.DefaultFilesetsLabel);
        l.setLayoutData((Object)this.createFormData(0, 5, null, 0, 0, 5, 100, -5));
        this.servers = new Combo(c, 8);
        this.servers.setLayoutData((Object)this.createFormData(l, 5, null, 0, 0, 5, null, 0));
        this.servers.setItems(this.getComboItems());
        this.viewer = new TreeViewer(c);
        this.viewer.getTree().setLayoutData((Object)this.createFormData(this.servers, 5, 100, -5, 0, 5, 80, 0));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.addButton = new Button(c, 8);
        this.addButton.setText(Messages.DefaultFilesetsAdd);
        this.addButton.setLayoutData((Object)this.createFormData(this.servers, 5, null, 0, this.viewer.getTree(), 5, 100, -5));
        this.removeButton = new Button(c, 8);
        this.removeButton.setText(Messages.DefaultFilesetsRemove);
        this.removeButton.setLayoutData((Object)this.createFormData(this.addButton, 5, null, 0, this.viewer.getTree(), 5, 100, -5));
        this.servers.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DefaultFilesetPreferencePage.this.getCurrentServerSets();
                DefaultFilesetPreferencePage.this.viewer.refresh();
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DefaultFilesetPreferencePage.this.addPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DefaultFilesetPreferencePage.this.removePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.servers.select(0);
        this.getCurrentServerSets();
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        c.layout();
        return c;
    }

    protected void addPressed() {
        FilesetDialog d = new FilesetDialog(this.addButton.getShell(), "", null);
        d.setShowViewer(false);
        if (d.open() == 0) {
            Fileset fs = d.getFileset();
            String id = this.getCurrentId();
            this.cacheMap.get(id).add(fs);
            if (!this.changed.contains(id)) {
                this.changed.add(id);
            }
            this.viewer.refresh();
        }
    }

    protected void removePressed() {
        Fileset fs = null;
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        fs = (Fileset)sel.getFirstElement();
        if (fs != null) {
            String id = this.getCurrentId();
            this.cacheMap.get(id).remove(fs);
            if (!this.changed.contains(id)) {
                this.changed.add(id);
            }
            this.viewer.refresh();
        }
    }

    protected String getCurrentId() {
        int index = this.servers.getSelectionIndex();
        if (index == 0) {
            return FilesetUtil.DEFAULT_FS_ALL_SERVERS;
        }
        if (index == -1) {
            return null;
        }
        IServerType type = this.getServerTypes()[index - 1];
        String id = type.getId();
        return id;
    }

    protected Fileset[] getCurrentServerSets() {
        String id = this.getCurrentId();
        List<Object> list = new ArrayList();
        if (id != null && (list = (List)this.cacheMap.get(id)) == null) {
            IPath fileToRead = FilesetUtil.DEFAULT_FS_ROOT.append(id);
            Fileset[] sets = FilesetUtil.loadFilesets(fileToRead.toFile(), null);
            list = Arrays.asList(sets);
            this.cacheMap.put(id, new ArrayList(list));
        }
        return list.toArray(new Fileset[list.size()]);
    }

    protected LabelProvider getLabelProvider() {
        return new FilesetLabelProvider();
    }

    protected ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return DefaultFilesetPreferencePage.this.getCurrentServerSets();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        };
    }

    private String[] getComboItems() {
        ArrayList<String> list = new ArrayList<String>();
        IServerType[] types = this.getServerTypes();
        list.add(Messages.DefaultFilesetsAllServerTypes);
        int i = 0;
        while (i < types.length) {
            list.add(types[i].getName());
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private IServerType[] getServerTypes() {
        if (this.types == null) {
            ArrayList<IServerType> sorted = new ArrayList<IServerType>();
            ArrayList<IServerType> all = new ArrayList<IServerType>(Arrays.asList(ServerCore.getServerTypes()));
            Iterator<IServerType> i = all.iterator();
            while (i.hasNext()) {
                IServerType t = i.next();
                if (!t.getId().startsWith("org.jboss.ide.eclipse.as.")) continue;
                sorted.add(t);
                i.remove();
            }
            sorted.addAll(all);
            this.types = sorted.toArray(new IServerType[sorted.size()]);
        }
        return this.types;
    }

    private FormData createFormData(Object topStart, int topOffset, Object bottomStart, int bottomOffset, Object leftStart, int leftOffset, Object rightStart, int rightOffset) {
        FormData data = new FormData();
        if (topStart != null) {
            FormAttachment formAttachment = data.top = topStart instanceof Control ? new FormAttachment((Control)topStart, topOffset) : new FormAttachment(((Integer)topStart).intValue(), topOffset);
        }
        if (bottomStart != null) {
            FormAttachment formAttachment = data.bottom = bottomStart instanceof Control ? new FormAttachment((Control)bottomStart, bottomOffset) : new FormAttachment(((Integer)bottomStart).intValue(), bottomOffset);
        }
        if (leftStart != null) {
            FormAttachment formAttachment = data.left = leftStart instanceof Control ? new FormAttachment((Control)leftStart, leftOffset) : new FormAttachment(((Integer)leftStart).intValue(), leftOffset);
        }
        if (rightStart != null) {
            data.right = rightStart instanceof Control ? new FormAttachment((Control)rightStart, rightOffset) : new FormAttachment(((Integer)rightStart).intValue(), rightOffset);
        }
        return data;
    }

    public boolean performOk() {
        String[] changed2 = this.changed.toArray(new String[this.changed.size()]);
        int i = 0;
        while (i < changed2.length) {
            ArrayList<Fileset> list = this.cacheMap.get(changed2[i]);
            Fileset[] arr = list.toArray(new Fileset[list.size()]);
            IPath fileToWrite = FilesetUtil.DEFAULT_FS_ROOT.append(changed2[i]);
            FilesetUtil.saveFilesets(fileToWrite.toFile(), arr);
            ++i;
        }
        this.changed.clear();
        return true;
    }
}

