/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import org.eclipse.core.internal.variables.StringSubstitutionEngine;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.wst.server.core.IServer;

public class Fileset
implements Cloneable {
    private static final String HASH_SEPARATOR = "::_::";
    private static final String SEP = "\n";
    private String name;
    private String folder;
    private String includesPattern;
    private String excludesPattern;
    private IServer server;

    public Fileset() {
    }

    public Fileset(String string) {
        try {
            this.excludesPattern = "";
            this.includesPattern = "";
            this.folder = "";
            this.name = "";
            String[] parts = string.split(SEP);
            this.name = parts[0];
            this.folder = parts[1];
            this.includesPattern = parts[2];
            this.excludesPattern = parts[3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public Fileset(String name, String folder, String inc, String exc) {
        this.name = name;
        this.folder = folder;
        this.includesPattern = inc;
        this.excludesPattern = exc;
    }

    public String toString() {
        return String.valueOf(this.name) + SEP + this.folder + SEP + this.includesPattern + SEP + this.excludesPattern;
    }

    public String getFolder() {
        String tmp = this.folder == null ? "" : this.folder;
        tmp = tmp.replace("${jboss_config_dir}", "${jboss_config_dir:" + this.server.getName() + "}");
        tmp = tmp.replace("${jboss_config}", "${jboss_config:" + this.server.getName() + "}");
        try {
            StringSubstitutionEngine engine = new StringSubstitutionEngine();
            tmp = engine.performStringSubstitution(tmp, true, true, (IStringVariableManager)StringVariableManager.getDefault());
        }
        catch (CoreException coreException) {}
        Path p = new Path(tmp);
        if (!p.isAbsolute() && this.server != null && this.server.getRuntime() != null) {
            p = this.server.getRuntime().getLocation().append((IPath)p);
        }
        return p.toString();
    }

    public String getRawFolder() {
        return this.folder == null ? "" : this.folder;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String getExcludesPattern() {
        return this.excludesPattern == null ? "" : this.excludesPattern;
    }

    public String getIncludesPattern() {
        return this.includesPattern == null ? "" : this.includesPattern;
    }

    public void setExcludesPattern(String excludesPattern) {
        this.excludesPattern = excludesPattern;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setIncludesPattern(String includesPattern) {
        this.includesPattern = includesPattern;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IServer getServer() {
        return this.server;
    }

    public void setServer(IServer server) {
        this.server = server;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Fileset)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Fileset o = (Fileset)other;
        return o.getName().equals(this.getName()) && o.getFolder().equals(this.getFolder()) && o.getIncludesPattern().equals(this.getIncludesPattern()) && o.getExcludesPattern().equals(this.getExcludesPattern());
    }

    public int hashCode() {
        return (String.valueOf(this.name) + HASH_SEPARATOR + this.folder + HASH_SEPARATOR + this.includesPattern + HASH_SEPARATOR + this.excludesPattern + HASH_SEPARATOR).hashCode();
    }
}

