/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetUtil;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesetContentProvider
implements ITreeContentProvider {
    private static final String FILESET_KEY = "org.jboss.ide.eclipse.as.ui.views.server.providers.FilesetViewProvider.PropertyKey";

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IServer) {
            return new Object[]{new ServerWrapper((IServer)parentElement)};
        }
        if (parentElement instanceof ServerWrapper) {
            return ((ServerWrapper)parentElement).getFilesets();
        }
        if (parentElement instanceof Fileset) {
            Fileset fs = (Fileset)parentElement;
            IPath[] paths = null;
            try {
                paths = this.findPaths(fs.getFolder(), fs.getIncludesPattern(), fs.getExcludesPattern());
            }
            catch (BuildException buildException) {
                return new Object[0];
            }
            HashMap<String, FolderWrapper> folders = new HashMap<String, FolderWrapper>();
            ArrayList<PathWrapper> wrappers = new ArrayList<PathWrapper>();
            int i = 0;
            while (i < paths.length) {
                if (paths[i].segmentCount() == 1) {
                    wrappers.add(new PathWrapper(paths[i], (IPath)new Path(fs.getFolder())));
                } else {
                    FilesetContentProvider.addPath(wrappers, folders, paths[i], (IPath)new Path(fs.getFolder()));
                }
                ++i;
            }
            return wrappers.toArray(new Object[wrappers.size()]);
        }
        if (parentElement instanceof FolderWrapper) {
            return ((FolderWrapper)parentElement).getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private IPath[] findPaths(String dir, String includes, String excludes) {
        IPath[] paths = new IPath[]{};
        try {
            DirectoryScannerFactory.DirectoryScannerExtension scanner;
            if (dir != null && (scanner = DirectoryScannerFactory.createDirectoryScanner((String)dir, null, (String)includes, (String)excludes, null, (boolean)false, (double)1.0, (boolean)true)) != null) {
                String[] files = scanner.getIncludedFiles();
                paths = new IPath[files.length];
                int i = 0;
                while (i < files.length) {
                    paths[i] = new Path(files[i]);
                    ++i;
                }
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return paths;
    }

    private static void addPath(ArrayList<PathWrapper> children, HashMap<String, FolderWrapper> folders, IPath path, IPath folder) {
        try {
            FolderWrapper fw = null;
            if (!folders.containsKey(path.segment(0))) {
                fw = new FolderWrapper(path.removeLastSegments(path.segmentCount() - 1), folder);
                folders.put(path.segment(0), fw);
                children.add(fw);
            } else {
                fw = folders.get(path.segment(0));
            }
            fw.addChild(path.removeFirstSegments(1));
        }
        catch (Exception exception) {}
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FolderWrapper
    extends PathWrapper {
        private HashMap<String, FolderWrapper> childrenFolders;
        private ArrayList<PathWrapper> children = new ArrayList();

        public FolderWrapper(IPath path, IPath folder) {
            super(path, folder);
            this.childrenFolders = new HashMap();
        }

        public void addChild(IPath path) {
            if (path.segmentCount() == 1) {
                this.children.add(new PathWrapper(path, this.getFolder().append(this.getLocalizedResourceName())));
            } else {
                this.addPath(this.children, this.childrenFolders, path, this.getFolder().append(this.getLocalizedResourceName()));
            }
        }

        public Object[] getChildren() {
            return this.children.toArray(new Object[this.children.size()]);
        }

        private void addPath(ArrayList<PathWrapper> children, HashMap<String, FolderWrapper> folders, IPath path, IPath folder) {
            try {
                FolderWrapper fw = null;
                if (!folders.containsKey(path.segment(0))) {
                    fw = new FolderWrapper(path.removeLastSegments(path.segmentCount() - 1), folder);
                    folders.put(path.segment(0), fw);
                    children.add(fw);
                } else {
                    fw = folders.get(path.segment(0));
                }
                fw.addChild(path.removeFirstSegments(1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class PathWrapper {
        private IPath path;
        private IPath folder;

        public PathWrapper(IPath path, IPath folder) {
            this.path = path;
            this.folder = folder;
        }

        public IPath getFolder() {
            return this.folder;
        }

        public IPath getPath() {
            return this.folder.append(this.path);
        }

        public String getLocalizedResourceName() {
            return this.path.toOSString();
        }

        public boolean equals(Object o) {
            return o == null ? false : (!(o instanceof PathWrapper) ? false : ((PathWrapper)o).folder.equals((Object)this.folder) && ((PathWrapper)o).path.equals((Object)this.path));
        }

        public int hashCode() {
            return this.path.hashCode() + this.folder.hashCode();
        }
    }

    public class ServerWrapper {
        public IServer server;
        private Fileset[] children;

        public ServerWrapper(IServer server) {
            this.server = server;
        }

        public int hashCode() {
            return this.server.getId().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof ServerWrapper && ((ServerWrapper)other).server.getId().equals(this.server.getId());
        }

        public void addFileset(Fileset fs) {
            Fileset[] filesetsNew = new Fileset[this.children.length + 1];
            System.arraycopy(this.children, 0, filesetsNew, 0, this.children.length);
            filesetsNew[filesetsNew.length - 1] = fs;
            this.children = filesetsNew;
            this.saveFilesets();
        }

        public void removeFileset(Fileset fs) {
            ArrayList<Fileset> asList = new ArrayList<Fileset>(Arrays.asList(this.children));
            asList.remove(fs);
            this.children = asList.toArray(new Fileset[asList.size()]);
            this.saveFilesets();
        }

        public Fileset[] getFilesets() {
            if (this.children == null) {
                this.children = this.loadFilesets();
            }
            return this.children;
        }

        private Fileset[] loadFilesets() {
            if (FilesetUtil.getFile(this.server).exists()) {
                return FilesetUtil.loadFilesets(this.server);
            }
            return this.loadFilesets_LEGACY();
        }

        @Deprecated
        private Fileset[] loadFilesets_LEGACY() {
            Fileset[] filesets = new Fileset[]{};
            if (this.server != null) {
                ServerAttributeHelper helper = ServerAttributeHelper.createHelper((IServer)this.server);
                ArrayList tmp = (ArrayList)helper.getAttribute(FilesetContentProvider.FILESET_KEY, new ArrayList());
                String[] asStrings = tmp.toArray(new String[tmp.size()]);
                filesets = new Fileset[asStrings.length];
                int i = 0;
                while (i < asStrings.length) {
                    filesets[i] = new Fileset(asStrings[i]);
                    filesets[i].setServer(this.server);
                    ++i;
                }
            }
            return filesets;
        }

        public void saveFilesets() {
            FilesetUtil.saveFilesets(this.server, this.children);
        }
    }
}

