/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.ui.util.composites.FilesetPreviewComposite;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.filesets.Fileset;

public class FilesetDialog
extends TitleAreaDialog {
    protected Fileset fileset;
    private String name;
    private String dir;
    private String includes;
    private String excludes;
    private Button browse;
    private Text includesText;
    private Text excludesText;
    private Text folderText;
    private Text nameText;
    private Composite main;
    private FilesetPreviewComposite preview;
    private IServer server;
    private boolean showViewer = true;

    protected FilesetDialog(Shell parentShell, String defaultLocation, IServer server) {
        super(parentShell);
        this.fileset = new Fileset();
        this.fileset.setFolder(defaultLocation);
        this.fileset.setServer(server);
        this.fileset.setFolder("server/${jboss_config}/");
        this.fileset.setIncludesPattern("**/*.xml");
        this.server = server;
    }

    protected FilesetDialog(Shell parentShell, Fileset fileset) {
        super(parentShell);
        this.fileset = (Fileset)fileset.clone();
        this.server = fileset.getServer();
    }

    public void setShowViewer(boolean val) {
        this.showViewer = val;
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return new Point(500, p.y);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.FilesetsNewFileset);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FilesetsDialogTitle);
        this.setMessage(Messages.FilesetsDialogMessage);
        Composite sup = (Composite)super.createDialogArea(parent);
        this.main = new Composite(sup, 0);
        this.main.setLayout((Layout)new GridLayout(3, false));
        this.main.setLayoutData((Object)new GridData(1808));
        this.fillArea(this.main);
        this.nameText.setText(this.fileset.getName());
        this.folderText.setText(this.fileset.getRawFolder());
        this.includesText.setText(this.fileset.getIncludesPattern());
        this.excludesText.setText(this.fileset.getExcludesPattern());
        this.addListeners();
        this.getShell().layout();
        this.textModified();
        return sup;
    }

    protected void addListeners() {
        ModifyListener mListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilesetDialog.this.textModified();
            }
        };
        this.nameText.addModifyListener(mListener);
        this.folderText.addModifyListener(mListener);
        this.includesText.addModifyListener(mListener);
        this.excludesText.addModifyListener(mListener);
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog d = new DirectoryDialog(new Shell());
                String txt = FilesetDialog.this.folderText.getText();
                if (!new Path(txt).isAbsolute() && FilesetDialog.this.server != null && FilesetDialog.this.server.getRuntime() != null) {
                    txt = FilesetDialog.this.server.getRuntime().getLocation().append(txt).toString();
                }
                d.setFilterPath(txt);
                String x = d.open();
                if (x != null) {
                    FilesetDialog.this.folderText.setText(FilesetDialog.this.makeRelative(x));
                }
            }
        });
    }

    protected String makeRelative(String path) {
        if (this.server != null && this.server.getRuntime() != null && this.server.getRuntime().getLocation().isPrefixOf((IPath)new Path(path))) {
            String p2 = path.substring(this.server.getRuntime().getLocation().toString().length());
            return new Path(p2).makeRelative().toString();
        }
        return path;
    }

    protected void textModified() {
        this.name = this.nameText.getText();
        this.dir = this.folderText.getText();
        this.includes = this.includesText.getText();
        this.excludes = this.excludesText.getText();
        this.fileset.setName(this.name);
        this.fileset.setFolder(this.dir);
        this.fileset.setIncludesPattern(this.includes);
        this.fileset.setExcludesPattern(this.excludes);
        this.validate();
        this.updatePreview();
    }

    protected void validate() {
        String error = null;
        error = this.name.equals("") ? Messages.FilesetsDialogEmptyName : (this.dir.equals("") ? Messages.FilesetsDialogEmptyFolder : null);
        this.setErrorMessage(error);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(error == null);
        }
    }

    public void create() {
        super.create();
        this.validate();
    }

    protected void fillArea(Composite main) {
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(Messages.FilesetsNewName);
        this.nameText = new Text(main, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label folderLabel = new Label(main, 0);
        folderLabel.setText(Messages.FilesetsNewRootDir);
        this.folderText = new Text(main, 2048);
        this.folderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.browse = new Button(main, 8);
        this.browse.setText(Messages.FilesetsNewBrowse);
        Label includesLabel = new Label(main, 0);
        includesLabel.setText(Messages.FilesetsNewIncludes);
        this.includesText = new Text(main, 2048);
        this.includesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label excludeLabel = new Label(main, 0);
        excludeLabel.setText(Messages.FilesetsNewExcludes);
        this.excludesText = new Text(main, 2048);
        this.excludesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (this.showViewer) {
            Group previewWrapper = new Group(main, 0);
            previewWrapper.setLayout((Layout)new GridLayout());
            GridData data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalSpan = 3;
            data.minimumHeight = 200;
            previewWrapper.setLayoutData((Object)data);
            previewWrapper.setText(Messages.FilesetsNewPreview);
            previewWrapper.setLayout((Layout)new FillLayout());
            this.preview = new FilesetPreviewComposite((Composite)previewWrapper, 0);
        }
    }

    private void updatePreview() {
        if (this.preview != null) {
            this.preview.setInput((Object[])FilesetDialog.findPaths(this.fileset.getFolder(), this.includes, this.excludes));
        }
    }

    public String getDir() {
        return this.dir;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getName() {
        return this.name;
    }

    public Fileset getFileset() {
        return this.fileset;
    }

    private static IPath[] findPaths(String dir, String includes, String excludes) {
        try {
            DirectoryScannerFactory.DirectoryScannerExtension scanner;
            if (dir != null && (scanner = DirectoryScannerFactory.createDirectoryScanner((String)dir, null, (String)includes, (String)excludes, null, (boolean)false, (double)1.0, (boolean)false)) != null) {
                Iterator i = scanner.iterator();
                ArrayList<Path> paths2 = new ArrayList<Path>();
                while (i.hasNext() && paths2.size() < 30) {
                    DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper fw = (DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper)i.next();
                    paths2.add(new Path(fw.getFilesetRelative()));
                }
                return paths2.toArray(new IPath[paths2.size()]);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new IPath[0];
    }
}

