/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets.vcf;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.jboss.ide.eclipse.archives.webtools.filesets.vcf.WorkspaceFilesetVirtualComponent;
import org.jboss.ide.eclipse.as.wtp.core.vcf.IReferenceResolver;

public class FilesetComponentResolver
implements IReferenceResolver {
    public static final String FILESET_SEGMENT = "org.jboss.ide.eclipse.archives.webtools.filesets.vcf.FilesetComponentResolver";
    public static final String FILESET_PROTOCOL = "module:/org.jboss.ide.eclipse.archives.webtools.filesets.vcf.FilesetComponentResolver/";

    public boolean canResolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        URI handle = referencedComponent.getHandle();
        String s = handle.toString();
        return s.startsWith(FILESET_PROTOCOL);
    }

    public boolean canResolve(IVirtualReference reference) {
        IVirtualComponent vc = reference.getReferencedComponent();
        return vc instanceof WorkspaceFilesetVirtualComponent;
    }

    public IVirtualReference resolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        IProject p = context.getProject();
        URI uri = referencedComponent.getHandle();
        String main = uri.segment(1);
        String[] split = main.split("&");
        String excludes = null;
        String includes = null;
        String path = null;
        try {
            int i = 0;
            while (i < split.length) {
                split[i].contains("=");
                String pre = split[i].substring(0, split[i].indexOf("="));
                String post = split[i].substring(split[i].indexOf("=") + 1);
                post = URLDecoder.decode(post, "UTF-8");
                if ("path".equals(pre)) {
                    path = post;
                } else if ("includes".equals(pre)) {
                    includes = post;
                } else if ("excludes".equals(pre)) {
                    excludes = post;
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        WorkspaceFilesetVirtualComponent comp = new WorkspaceFilesetVirtualComponent(p, context, path);
        comp.setIncludes(includes);
        comp.setExcludes(excludes);
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)context, (IVirtualComponent)comp);
        ref.setArchiveName(referencedComponent.getArchiveName());
        ref.setRuntimePath(referencedComponent.getRuntimePath());
        ref.setDependencyType(referencedComponent.getDependencyType().getValue());
        return ref;
    }

    public ReferencedComponent resolve(IVirtualReference reference) {
        IVirtualComponent vc = reference.getReferencedComponent();
        WorkspaceFilesetVirtualComponent fsvc = (WorkspaceFilesetVirtualComponent)vc;
        String path = fsvc.getRootFolderPath();
        String includes = fsvc.getIncludes();
        String excludes = fsvc.getExcludes();
        try {
            String url = "path=" + URLEncoder.encode(path, "UTF-8");
            url = String.valueOf(url) + "&includes=" + URLEncoder.encode(includes, "UTF-8");
            url = String.valueOf(url) + "&excludes=" + URLEncoder.encode(excludes, "UTF-8");
            ReferencedComponent rc = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createReferencedComponent();
            rc.setArchiveName(reference.getArchiveName());
            rc.setRuntimePath(reference.getRuntimePath());
            fsvc.getId();
            rc.setHandle(URI.createURI((String)(String.valueOf(fsvc.getId()) + url)));
            rc.setDependencyType(DependencyType.CONSUMES_LITERAL);
            return rc;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

