/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.modules;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.jboss.ide.eclipse.archives.core.model.AbstractBuildListener;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveBuildListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.modules.PackageModuleFactory;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServerBehavior;
import org.jboss.ide.eclipse.as.core.util.FileUtil;

public class ArchivesModuleModelListener
extends AbstractBuildListener
implements IArchiveModelListener {
    public static ArchivesModuleModelListener instance;
    public static final String DEPLOY_SERVERS = "org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployServers";
    public static final String DEPLOY_AFTER_BUILD = "org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployAfterBuild";
    private IPublishListener publishListener;
    private ArrayList<IServer> publishing;

    public static ArchivesModuleModelListener getInstance() {
        if (instance == null) {
            instance = new ArchivesModuleModelListener();
        }
        return instance;
    }

    public ArchivesModuleModelListener() {
        ArchivesModel.instance().addModelListener((IArchiveModelListener)this);
        ArchivesModel.instance().addBuildListener((IArchiveBuildListener)this);
        this.publishing = new ArrayList();
        this.publishListener = new IPublishListener(){

            public void publishFinished(IServer server, IStatus status) {
                ArchivesModuleModelListener.this.publishing.remove(server);
            }

            public void publishStarted(IServer server) {
                ArchivesModuleModelListener.this.publishing.add(server);
            }
        };
    }

    public void finishedBuildingArchive(IArchive pkg) {
        if (pkg.isTopLevel() && new Boolean(pkg.getProperty(DEPLOY_AFTER_BUILD)).booleanValue()) {
            String servers = pkg.getProperty(DEPLOY_SERVERS);
            this.publish(pkg, servers, 1);
        }
    }

    public void publish(IArchive pkg, String servers, int publishType) {
        IModule[] module = this.getModule(pkg);
        if (module[0] == null) {
            return;
        }
        DeployableServerBehavior[] serverBehaviors = ArchivesModuleModelListener.getServers(servers);
        if (serverBehaviors != null) {
            int i = 0;
            while (i < serverBehaviors.length) {
                if (!this.publishing.contains(serverBehaviors[i].getServer())) {
                    try {
                        serverBehaviors[i].getServer().addPublishListener(this.publishListener);
                        this.publish(serverBehaviors[i].getServer(), publishType, module);
                    }
                    finally {
                        serverBehaviors[i].getServer().removePublishListener(this.publishListener);
                    }
                }
                ++i;
            }
        }
    }

    protected IStatus publish(IServer server, int publishType, IModule[] module) {
        try {
            IServerWorkingCopy copy = server.createWorkingCopy();
            copy.modifyModules(module, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
            IServer saved = copy.save(false, (IProgressMonitor)new NullProgressMonitor());
            saved.publish(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            return new Status(4, "org.jboss.ide.eclipse.archives.webtools", NLS.bind((String)Messages.ExceptionCannotDeployFile, (Object)module[0].getName()), (Throwable)ce);
        }
        return Status.OK_STATUS;
    }

    protected IModule[] getModule(IArchive node) {
        ModuleFactory factory = ServerPlugin.findModuleFactory((String)"org.jboss.ide.eclipse.as.core.PackageModuleFactory");
        IModule mod = factory.findModule(PackageModuleFactory.getId(node), (IProgressMonitor)new NullProgressMonitor());
        return new IModule[]{mod};
    }

    protected PackageModuleFactory.PackagedModuleDelegate getModuleDelegate(IArchive node) {
        IModule mod = this.getModule(node)[0];
        return (PackageModuleFactory.PackagedModuleDelegate)((Object)mod.loadAdapter(PackageModuleFactory.PackagedModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor()));
    }

    protected IDeployableServer getDeployableServerFromBehavior(DeployableServerBehavior dsb) {
        IServer server = dsb.getServer();
        IDeployableServer ids = (IDeployableServer)server.loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
        return ids;
    }

    public static DeployableServerBehavior[] getServers(String servers) {
        if (servers == null || "".equals(servers)) {
            return null;
        }
        ArrayList<DeployableServerBehavior> list = new ArrayList<DeployableServerBehavior>();
        String[] byId = servers.split(",");
        int i = 0;
        while (i < byId.length) {
            Object o;
            IServer server = ServerCore.findServer((String)byId[i]);
            if (server != null && (o = server.loadAdapter(DeployableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
                list.add((DeployableServerBehavior)o);
            }
            ++i;
        }
        return list.toArray(new DeployableServerBehavior[list.size()]);
    }

    public void packageBuildTypeChanged(IArchive topLevelPackage, boolean isExploded) {
        String servers = topLevelPackage.getProperty(DEPLOY_SERVERS);
        DeployableServerBehavior[] serverBehaviors = ArchivesModuleModelListener.getServers(servers);
        if (serverBehaviors != null) {
            int i = 0;
            while (i < serverBehaviors.length) {
                IPath sourcePath = topLevelPackage.getArchiveFilePath();
                IDeployableServer depServer = this.getDeployableServerFromBehavior(serverBehaviors[i]);
                IPath destPath = new Path(depServer.getDeployFolder()).append(sourcePath.lastSegment());
                FileUtil.safeDelete((File)destPath.toFile());
                FileUtil.fileSafeCopy((File)sourcePath.toFile(), (File)destPath.toFile());
                ++i;
            }
        }
    }

    public void modelChanged(IArchiveNodeDelta delta) {
        IPath p = delta.getPreNode() == null ? delta.getPostNode().getProjectPath() : delta.getPreNode().getProjectPath();
        PackageModuleFactory.getFactory().refreshProject(p);
    }
}

